/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ai.proxy.enhanced.cache;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shenyu.common.dto.ProxyApiKeyData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AiProxyApiKeyCache {
    private static final Logger LOG = LoggerFactory.getLogger(AiProxyApiKeyCache.class);
    private static final AiProxyApiKeyCache INSTANCE = new AiProxyApiKeyCache();
    private final Map<String, ProxyApiKeyData> dataMap = new ConcurrentHashMap<String, ProxyApiKeyData>();

    private AiProxyApiKeyCache() {
    }

    private String key(ProxyApiKeyData data) {
        return data.getSelectorId() + "::" + data.getProxyApiKey();
    }

    private String key(String selectorId, String proxyApiKey) {
        return selectorId + "::" + proxyApiKey;
    }

    public static AiProxyApiKeyCache getInstance() {
        return INSTANCE;
    }

    public void cache(ProxyApiKeyData data) {
        if (Objects.nonNull(data) && Boolean.TRUE.equals(data.getEnabled())) {
            this.dataMap.put(this.key(data), data);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[AiProxyApiKeyCache] cache key={}, size={}", (Object)this.key(data), (Object)this.dataMap.size());
            }
        }
    }

    public void remove(ProxyApiKeyData data) {
        if (Objects.nonNull(data) && Objects.nonNull(data.getProxyApiKey())) {
            this.dataMap.remove(this.key(data));
            if (LOG.isDebugEnabled()) {
                LOG.debug("[AiProxyApiKeyCache] remove key={}, size={}", (Object)this.key(data), (Object)this.dataMap.size());
            }
        }
    }

    public String getRealApiKey(String selectorId, String proxyApiKey) {
        ProxyApiKeyData data = this.dataMap.get(this.key(selectorId, proxyApiKey));
        return Objects.nonNull(data) && Boolean.TRUE.equals(data.getEnabled()) ? data.getRealApiKey() : null;
    }

    public void refresh() {
        this.dataMap.clear();
        if (LOG.isDebugEnabled()) {
            LOG.debug("[AiProxyApiKeyCache] refresh clear, size=0");
        }
    }

    public void removeBySelectorId(String selectorId) {
        if (Objects.isNull(selectorId)) {
            return;
        }
        String prefix = selectorId + "::";
        int before = this.dataMap.size();
        this.dataMap.keySet().removeIf(k -> k.equals(selectorId) || k.startsWith(prefix));
        int after = this.dataMap.size();
        LOG.info("[AiProxyApiKeyCache] invalidate selectorId={}, removed={} entries", (Object)selectorId, (Object)(before - after));
    }

    public int size() {
        return this.dataMap.size();
    }
}

