/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.resilience4j;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.Resilience4JHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.UriUtils;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.resilience4j.build.Resilience4JBuilder;
import org.apache.shenyu.plugin.resilience4j.conf.Resilience4JConf;
import org.apache.shenyu.plugin.resilience4j.executor.CombinedExecutor;
import org.apache.shenyu.plugin.resilience4j.executor.Executor;
import org.apache.shenyu.plugin.resilience4j.executor.RateLimiterExecutor;
import org.apache.shenyu.plugin.resilience4j.handler.Resilience4JHandler;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class Resilience4JPlugin
extends AbstractShenyuPlugin {
    private final CombinedExecutor combinedExecutor;
    private final RateLimiterExecutor ratelimiterExecutor;

    public Resilience4JPlugin(CombinedExecutor combinedExecutor, RateLimiterExecutor ratelimiterExecutor) {
        this.combinedExecutor = combinedExecutor;
        this.ratelimiterExecutor = ratelimiterExecutor;
    }

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        Objects.requireNonNull(shenyuContext);
        Resilience4JHandle resilience4JHandle = (Resilience4JHandle)Resilience4JHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        resilience4JHandle.checkData(resilience4JHandle);
        if (resilience4JHandle.getCircuitEnable() == 1) {
            return this.combined(exchange, chain, rule);
        }
        return this.rateLimiter(exchange, chain, rule);
    }

    private Mono<Void> rateLimiter(ServerWebExchange exchange, ShenyuPluginChain chain, RuleData rule) {
        return this.ratelimiterExecutor.run(chain.execute(exchange), this.fallback(this.ratelimiterExecutor, exchange, null), Resilience4JBuilder.build(rule)).onErrorResume(throwable -> this.ratelimiterExecutor.withoutFallback(exchange, (Throwable)throwable));
    }

    private Mono<Void> combined(ServerWebExchange exchange, ShenyuPluginChain chain, RuleData rule) {
        Resilience4JConf conf = Resilience4JBuilder.build(rule);
        return this.combinedExecutor.run(chain.execute(exchange).doOnSuccess(v -> {
            HttpStatusCode status = exchange.getResponse().getStatusCode();
            if (Objects.isNull(status) || !status.is2xxSuccessful()) {
                exchange.getResponse().setStatusCode(null);
                throw new CircuitBreakerStatusCodeException((HttpStatusCode)(Objects.isNull(status) ? HttpStatus.INTERNAL_SERVER_ERROR : status));
            }
        }), this.fallback(this.combinedExecutor, exchange, conf.getFallBackUri()), conf);
    }

    private Function<Throwable, Mono<Void>> fallback(Executor executor, ServerWebExchange exchange, String uri) {
        return throwable -> executor.fallback(exchange, UriUtils.createUri((String)uri), (Throwable)throwable).doFinally(monoV -> {
            Consumer consumer = (Consumer)exchange.getAttribute("metricsResilience4j");
            Optional.ofNullable(consumer).ifPresent(c -> c.accept(exchange.getResponse().getStatusCode()));
        });
    }

    public int getOrder() {
        return PluginEnum.RESILIENCE4J.getCode();
    }

    public String named() {
        return PluginEnum.RESILIENCE4J.getName();
    }

    public static class CircuitBreakerStatusCodeException
    extends HttpStatusCodeException {
        public CircuitBreakerStatusCodeException(HttpStatusCode statusCode) {
            super(statusCode);
        }
    }
}

