/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.discovery;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.Event;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class NacosWatch
implements ApplicationEventPublisherAware,
SmartLifecycle,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(NacosWatch.class);
    private Map<String, EventListener> listenerMap = new ConcurrentHashMap<String, EventListener>(16);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicLong nacosWatchIndex = new AtomicLong(0L);
    private ApplicationEventPublisher publisher;
    private ScheduledFuture<?> watchFuture;
    private NacosServiceManager nacosServiceManager;
    private final NacosDiscoveryProperties properties;
    private final ThreadPoolTaskScheduler taskScheduler;

    public NacosWatch(NacosServiceManager nacosServiceManager, NacosDiscoveryProperties properties) {
        this.nacosServiceManager = nacosServiceManager;
        this.properties = properties;
        this.taskScheduler = NacosWatch.getTaskScheduler();
    }

    @Deprecated
    public NacosWatch(NacosServiceManager nacosServiceManager, NacosDiscoveryProperties properties, ObjectProvider<ThreadPoolTaskScheduler> taskScheduler) {
        this.nacosServiceManager = nacosServiceManager;
        this.properties = properties;
        this.taskScheduler = taskScheduler.stream().findAny().orElseGet(NacosWatch::getTaskScheduler);
    }

    private static ThreadPoolTaskScheduler getTaskScheduler() {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setBeanName("Nacos-Watch-Task-Scheduler");
        taskScheduler.initialize();
        return taskScheduler;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            EventListener eventListener = this.listenerMap.computeIfAbsent(this.buildKey(), event -> new EventListener(){

                public void onEvent(Event event) {
                    if (event instanceof NamingEvent) {
                        List instances = ((NamingEvent)event).getInstances();
                        Optional instanceOptional = NacosWatch.this.selectCurrentInstance(instances);
                        instanceOptional.ifPresent(currentInstance -> NacosWatch.this.resetIfNeeded(currentInstance));
                    }
                }
            });
            NamingService namingService = this.nacosServiceManager.getNamingService(this.properties.getNacosProperties());
            try {
                namingService.subscribe(this.properties.getService(), this.properties.getGroup(), Arrays.asList(this.properties.getClusterName()), eventListener);
            }
            catch (Exception e) {
                log.error("namingService subscribe failed, properties:{}", (Object)this.properties, (Object)e);
            }
            this.watchFuture = this.taskScheduler.scheduleWithFixedDelay(this::nacosServicesWatch, this.properties.getWatchDelay());
        }
    }

    private String buildKey() {
        return String.join((CharSequence)":", this.properties.getService(), this.properties.getGroup());
    }

    private void resetIfNeeded(Instance instance) {
        if (!this.properties.getMetadata().equals(instance.getMetadata())) {
            this.properties.setMetadata(instance.getMetadata());
        }
    }

    private Optional<Instance> selectCurrentInstance(List<Instance> instances) {
        return instances.stream().filter(instance -> this.properties.getIp().equals(instance.getIp()) && this.properties.getPort() == instance.getPort()).findFirst();
    }

    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            if (this.watchFuture != null) {
                this.taskScheduler.shutdown();
                this.watchFuture.cancel(true);
            }
            EventListener eventListener = this.listenerMap.get(this.buildKey());
            try {
                NamingService namingService = this.nacosServiceManager.getNamingService(this.properties.getNacosProperties());
                namingService.unsubscribe(this.properties.getService(), this.properties.getGroup(), Arrays.asList(this.properties.getClusterName()), eventListener);
            }
            catch (Exception e) {
                log.error("namingService unsubscribe failed, properties:{}", (Object)this.properties, (Object)e);
            }
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getPhase() {
        return 0;
    }

    public void nacosServicesWatch() {
        this.publisher.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)this, (Object)this.nacosWatchIndex.getAndIncrement()));
    }

    public void destroy() {
        this.stop();
    }
}

