/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.logging.logback;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.ActionUtil;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.util.OptionHelper;
import com.alibaba.nacos.client.env.NacosClientProperties;
import org.xml.sax.Attributes;

class NacosClientPropertyAction
extends Action {
    private static final String DEFAULT_VALUE_ATTRIBUTE = "defaultValue";
    private static final String SOURCE_ATTRIBUTE = "source";

    NacosClientPropertyAction() {
    }

    public void begin(InterpretationContext ic, String elementName, Attributes attributes) throws ActionException {
        String name = attributes.getValue("name");
        String source = attributes.getValue(SOURCE_ATTRIBUTE);
        ActionUtil.Scope scope = ActionUtil.stringToScope((String)attributes.getValue("scope"));
        String defaultValue = attributes.getValue(DEFAULT_VALUE_ATTRIBUTE);
        if (OptionHelper.isEmpty((String)name)) {
            this.addError("The \"name\" and \"source\"  attributes of <nacosClientProperty> must be set");
        }
        ActionUtil.setProperty((InterpretationContext)ic, (String)name, (String)this.getValue(source, defaultValue), (ActionUtil.Scope)scope);
    }

    public void end(InterpretationContext ic, String name) throws ActionException {
    }

    private String getValue(String source, String defaultValue) {
        return NacosClientProperties.PROTOTYPE.getProperty(source, defaultValue);
    }
}

