/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.plugin.oauth2;

import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.oauth2.OAuth2Plugin;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.autoconfigure.security.reactive.ReactiveSecurityAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientService;
import org.springframework.security.web.server.SecurityWebFilterChain;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"shenyu.plugins.oauth2.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnClass(value={OAuth2AuthorizedClient.class, SecurityWebFilterChain.class, SecurityProperties.class})
@AutoConfigureAfter(value={ReactiveSecurityAutoConfiguration.class})
public class OAuth2PluginConfiguration {
    @Bean
    public ShenyuPlugin oAuth2Plugin(ObjectProvider<ReactiveOAuth2AuthorizedClientService> authorizedClientServiceProvider) {
        return new OAuth2Plugin(authorizedClientServiceProvider);
    }
}

