/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.cls.producer.http.client;

import com.tencentcloudapi.cls.producer.common.Constants;
import com.tencentcloudapi.cls.producer.http.comm.RequestMessage;
import com.tencentcloudapi.cls.producer.http.utils.HttpUtil;
import com.tencentcloudapi.cls.producer.response.PutLogsResponse;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class Sender {
    public static PutLogsResponse doPost(RequestMessage requestMessage) throws Exception {
        URL url = new URL(Sender.buildUri(requestMessage));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(requestMessage.getMethod().toString());
        connection.setConnectTimeout(Constants.HTTP_CONNECT_TIME_OUT);
        connection.setReadTimeout(Constants.HTTP_SEND_TIME_OUT);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        for (Map.Entry<String, String> entry : requestMessage.getHeaders().entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        connection.setRequestProperty("User-Agent", "cls-java-sdk-1.0.8");
        OutputStream outputStream = connection.getOutputStream();
        outputStream.write(requestMessage.getContent());
        PutLogsResponse resp = new PutLogsResponse(connection.getHeaderFields());
        resp.SetHttpStatusCode(connection.getResponseCode());
        outputStream.close();
        return resp;
    }

    private static String buildUri(RequestMessage requestMessage) {
        String paramString;
        String delimiter = "/";
        String uri = requestMessage.getEndpoint().toString();
        if (!(uri.endsWith("/") || requestMessage.getResourcePath() != null && requestMessage.getResourcePath().startsWith("/"))) {
            uri = uri + "/";
        }
        if (requestMessage.getResourcePath() != null) {
            uri = uri + requestMessage.getResourcePath();
        }
        if ((paramString = HttpUtil.paramToQueryString(requestMessage.getParameters(), "UTF-8")) != null) {
            uri = uri + "?" + paramString;
        }
        return uri;
    }
}

