/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mock.generator;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.shenyu.plugin.mock.api.MockRequest;
import org.apache.shenyu.plugin.mock.generator.Generator;
import org.apache.shenyu.plugin.mock.generator.GeneratorFactory;
import org.apache.shenyu.spi.Join;

@Join
public class ArrayGenerator
implements Generator<String> {
    @Override
    public String getName() {
        return "array";
    }

    @Override
    public String doGenerate(List<String> params, String rule, MockRequest mockRequest) {
        int length = Integer.parseInt(rule.substring(rule.lastIndexOf("|") + 1));
        String replaceContentCopy = rule.substring(rule.indexOf("|") + 1, rule.lastIndexOf("|"));
        return IntStream.rangeClosed(0, length - 1).mapToObj(i -> GeneratorFactory.dealRule(replaceContentCopy, mockRequest)).collect(Collectors.joining(","));
    }

    @Override
    public int getParamSize() {
        return 0;
    }

    @Override
    public boolean match(String rule) {
        return rule.matches("^array\\|.+\\|\\d+$");
    }

    @Override
    public String[] getPrefixAndSuffix() {
        return new String[]{"[", "]"};
    }
}

