/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.controller;

import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.dto.BaseData;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.dto.DiscoveryUpstreamData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.selector.DivideUpstream;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.enums.ParamTypeEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.common.enums.TrieCacheTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.apache.shenyu.plugin.api.utils.SpringBeanUtils;
import org.apache.shenyu.plugin.base.cache.BaseDataCache;
import org.apache.shenyu.plugin.base.cache.MatchDataCache;
import org.apache.shenyu.plugin.base.trie.ShenyuTrie;
import org.apache.shenyu.sync.data.api.DiscoveryUpstreamDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/shenyu"}, produces={"application/json", "application/xml"})
public class LocalPluginController {
    private static final Logger LOG = LoggerFactory.getLogger(LocalPluginController.class);
    private final PluginDataSubscriber subscriber;
    private final DiscoveryUpstreamDataSubscriber discoveryUpstreamDataSubscriber;

    public LocalPluginController(PluginDataSubscriber subscriber, DiscoveryUpstreamDataSubscriber discoveryUpstreamDataSubscriber) {
        this.subscriber = subscriber;
        this.discoveryUpstreamDataSubscriber = discoveryUpstreamDataSubscriber;
    }

    @GetMapping(value={"/cleanAll"})
    public Mono<String> cleanAll() {
        LOG.info("clean all apache shenyu local plugin");
        this.subscriber.refreshPluginDataAll();
        this.subscriber.refreshSelectorDataAll();
        this.subscriber.refreshRuleDataAll();
        return Mono.just((Object)"success");
    }

    @GetMapping(value={"/cleanPlugin"})
    public Mono<String> cleanPlugin(@RequestParam(value="name") String name) {
        LOG.info("clean apache shenyu local plugin for {}", (Object)name);
        BaseDataCache.getInstance().removePluginDataByPluginName(name);
        List selectorData = Optional.ofNullable(BaseDataCache.getInstance().obtainSelectorData(name)).orElse(Collections.emptyList());
        ArrayList newSelectorData = CollectionUtils.isNotEmpty(selectorData) ? Lists.newArrayList(selectorData) : Collections.emptyList();
        List selectorIds = newSelectorData.stream().map(BaseData::getId).collect(Collectors.toList());
        BaseDataCache.getInstance().removeSelectDataByPluginName(name);
        MatchDataCache.getInstance().removeSelectorData(name);
        MatchDataCache.getInstance().removeRuleData(name);
        ShenyuTrie selectorTrie = (ShenyuTrie)SpringBeanUtils.getInstance().getBean(TrieCacheTypeEnum.SELECTOR.getTrieType());
        ShenyuTrie ruleTrie = (ShenyuTrie)SpringBeanUtils.getInstance().getBean(TrieCacheTypeEnum.RULE.getTrieType());
        ShenyuConfig shenyuConfig = (ShenyuConfig)SpringBeanUtils.getInstance().getBean(ShenyuConfig.class);
        if (Boolean.TRUE.equals(shenyuConfig.getSelectorMatchCache().getTrie().getEnabled())) {
            newSelectorData.forEach(selector -> {
                List filterConditions;
                List conditionDataList = selector.getConditionList();
                if (CollectionUtils.isNotEmpty((Collection)conditionDataList) && CollectionUtils.isNotEmpty(filterConditions = conditionDataList.stream().filter(conditionData -> ParamTypeEnum.URI.getName().equals(conditionData.getParamType())).collect(Collectors.toList()))) {
                    List uriPaths = filterConditions.stream().map(ConditionData::getParamValue).collect(Collectors.toList());
                    selectorTrie.remove(uriPaths, selector, TrieCacheTypeEnum.SELECTOR);
                }
            });
        }
        for (String selectorId : selectorIds) {
            List ruleDataList = BaseDataCache.getInstance().obtainRuleData(selectorId);
            ArrayList newRuleDataList = CollectionUtils.isNotEmpty((Collection)ruleDataList) ? Lists.newArrayList((Iterable)ruleDataList) : Collections.emptyList();
            BaseDataCache.getInstance().removeRuleDataBySelectorId(selectorId);
            if (!Boolean.TRUE.equals(shenyuConfig.getRuleMatchCache().getTrie().getEnabled()) || !CollectionUtils.isNotEmpty((Collection)newRuleDataList)) continue;
            newRuleDataList.forEach(rule -> {
                List filterConditions;
                List conditionDataList = rule.getConditionDataList();
                if (CollectionUtils.isNotEmpty((Collection)conditionDataList) && CollectionUtils.isNotEmpty(filterConditions = conditionDataList.stream().filter(conditionData -> ParamTypeEnum.URI.getName().equals(conditionData.getParamType())).collect(Collectors.toList()))) {
                    List uriPaths = filterConditions.stream().map(ConditionData::getParamValue).collect(Collectors.toList());
                    ruleTrie.remove(uriPaths, rule, TrieCacheTypeEnum.RULE);
                }
            });
        }
        return Mono.just((Object)"success");
    }

    @PostMapping(value={"/plugin/saveOrUpdate"})
    public Mono<String> saveOrUpdate(@RequestBody PluginData pluginData) {
        LOG.info("saveOrUpdate apache shenyu local plugin for {}", (Object)pluginData.getName());
        this.subscriber.onSubscribe(pluginData);
        return Mono.just((Object)"success");
    }

    @GetMapping(value={"/plugin/delete"})
    public Mono<String> delete(@RequestParam(value="name") String name) {
        LOG.info("delete apache shenyu local plugin for {}", (Object)name);
        PluginData pluginData = PluginData.builder().name(name).build();
        this.subscriber.unSubscribe(pluginData);
        return Mono.just((Object)"success");
    }

    @GetMapping(value={"/plugin/deleteAll"})
    public Mono<String> deleteAll() {
        LOG.info("delete all apache shenyu local plugin");
        this.subscriber.refreshPluginDataAll();
        return Mono.just((Object)"success");
    }

    @GetMapping(value={"/plugin/findByName"})
    public Mono<String> findByName(@RequestParam(value="name") String name) {
        PluginData pluginData = BaseDataCache.getInstance().obtainPluginData(name);
        if (Objects.isNull(pluginData)) {
            return Mono.just((Object)("can not find this plugin : " + name));
        }
        return Mono.just((Object)JsonUtils.toJson((Object)pluginData));
    }

    @PostMapping(value={"/plugin/selector/saveOrUpdate"})
    public Mono<String> saveSelector(@RequestBody SelectorData selectorData) {
        if (StringUtils.isEmpty((CharSequence)selectorData.getPluginName())) {
            return Mono.just((Object)"Error: please add pluginName!");
        }
        SelectorData defaultSelectorData = this.buildDefaultSelectorData(selectorData);
        this.subscriber.onSelectorSubscribe(defaultSelectorData);
        this.saveDiscoveryUpstreamData(defaultSelectorData);
        return Mono.just((Object)selectorData.getId());
    }

    private void saveDiscoveryUpstreamData(SelectorData defaultSelectorData) {
        DiscoverySyncData discoverySyncData = new DiscoverySyncData();
        discoverySyncData.setSelectorId(defaultSelectorData.getId());
        discoverySyncData.setSelectorName(defaultSelectorData.getName());
        discoverySyncData.setPluginName(defaultSelectorData.getPluginName());
        List upstreamList = GsonUtils.getInstance().fromList(defaultSelectorData.getHandle(), DivideUpstream.class);
        if (CollectionUtils.isNotEmpty((Collection)upstreamList)) {
            List discoveryUpstreamDataList = upstreamList.stream().map(up -> {
                DiscoveryUpstreamData upstreamData = new DiscoveryUpstreamData();
                upstreamData.setUrl(up.getUpstreamUrl());
                upstreamData.setProtocol(up.getProtocol());
                upstreamData.setWeight(up.getWeight());
                upstreamData.setStatus(up.isStatus() ? 0 : 1);
                Properties properties = new Properties();
                properties.setProperty("warmup", String.valueOf(up.getWarmup()));
                properties.setProperty("upstreamHost", String.valueOf(up.getUpstreamHost()));
                upstreamData.setDateUpdated(Optional.of(up.getTimestamp()).map(Timestamp::new).orElse(new Timestamp(System.currentTimeMillis())));
                upstreamData.setProps(GsonUtils.getInstance().toJson((Object)properties));
                upstreamData.setDateCreated(Optional.of(up.getTimestamp()).map(Timestamp::new).orElse(new Timestamp(System.currentTimeMillis())));
                return upstreamData;
            }).collect(Collectors.toList());
            discoverySyncData.setUpstreamDataList(discoveryUpstreamDataList);
            this.discoveryUpstreamDataSubscriber.onSubscribe(discoverySyncData);
        }
    }

    @PostMapping(value={"/plugin/selectorAndRule"})
    public Mono<String> selectorAndRule(@RequestBody SelectorRuleData selectorRuleData) {
        SelectorData selectorData = SelectorData.builder().pluginName(selectorRuleData.getPluginName()).handle(selectorRuleData.getSelectorHandler()).conditionList(selectorRuleData.getConditionDataList()).type(Integer.valueOf(SelectorTypeEnum.CUSTOM_FLOW.getCode())).build();
        SelectorData result = this.buildDefaultSelectorData(selectorData);
        this.subscriber.onSelectorSubscribe(result);
        this.saveDiscoveryUpstreamData(result);
        RuleData ruleData = RuleData.builder().selectorId(result.getId()).matchRestful(Boolean.FALSE).pluginName(selectorRuleData.getPluginName()).handle(selectorRuleData.getRuleHandler()).conditionDataList(selectorRuleData.getConditionDataList()).build();
        this.subscriber.onRuleSubscribe(this.buildDefaultRuleData(ruleData));
        return Mono.just((Object)"success");
    }

    @PostMapping(value={"/plugin/selectorAndRules"})
    public Mono<String> selectorAndRules(@RequestBody SelectorRulesData selectorRulesData) {
        SelectorData selectorData = SelectorData.builder().pluginName(selectorRulesData.getPluginName()).handle(selectorRulesData.getSelectorHandler()).matchMode(selectorRulesData.getMatchMode()).conditionList(selectorRulesData.getConditionDataList()).type(Integer.valueOf(SelectorTypeEnum.CUSTOM_FLOW.getCode())).sort(Optional.ofNullable(selectorRulesData.getSort()).orElse(10)).build();
        SelectorData result = this.buildDefaultSelectorData(selectorData);
        this.subscriber.onSelectorSubscribe(result);
        this.saveDiscoveryUpstreamData(result);
        List<RuleLocalData> ruleDataList = selectorRulesData.getRuleDataList();
        for (RuleLocalData data : ruleDataList) {
            RuleData ruleData = RuleData.builder().selectorId(result.getId()).pluginName(result.getPluginName()).name(data.getRuleName()).matchMode(data.getMatchMode()).handle(data.getRuleHandler()).conditionDataList(data.getConditionDataList()).build();
            this.subscriber.onRuleSubscribe(this.buildDefaultRuleData(ruleData));
        }
        return Mono.just((Object)"success");
    }

    @GetMapping(value={"/plugin/selector/delete"})
    public Mono<String> deleteSelector(@RequestParam(value="pluginName") String pluginName, @RequestParam(value="id") String id) {
        SelectorData selectorData = SelectorData.builder().pluginName(pluginName).id(id).build();
        this.subscriber.unSelectorSubscribe(selectorData);
        return Mono.just((Object)"success");
    }

    @GetMapping(value={"/plugin/selector/findList"})
    public Mono<String> findListSelector(@RequestParam(value="pluginName") String pluginName, @RequestParam(value="id", required=false) String id) {
        List selectorDataList = BaseDataCache.getInstance().obtainSelectorData(pluginName);
        if (CollectionUtils.isEmpty((Collection)selectorDataList)) {
            return Mono.just((Object)("Error: can not find selector data by pluginName :" + pluginName));
        }
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            List result = selectorDataList.stream().filter(selectorData -> selectorData.getId().equals(id)).collect(Collectors.toList());
            return Mono.just((Object)JsonUtils.toJson(result));
        }
        return Mono.just((Object)JsonUtils.toJson((Object)selectorDataList));
    }

    @PostMapping(value={"/plugin/rule/saveOrUpdate"})
    public Mono<String> saveRule(@RequestBody RuleData ruleData) {
        if (StringUtils.isEmpty((CharSequence)ruleData.getSelectorId())) {
            return Mono.just((Object)"Error: please add selectorId!");
        }
        this.subscriber.onRuleSubscribe(this.buildDefaultRuleData(ruleData));
        return Mono.just((Object)ruleData.getId());
    }

    @GetMapping(value={"/plugin/rule/delete"})
    public Mono<String> deleteRule(@RequestParam(value="selectorId") String selectorId, @RequestParam(value="id") String id, @RequestParam(value="pluginName") String pluginName) {
        RuleData ruleData = RuleData.builder().selectorId(selectorId).id(id).pluginName(pluginName).build();
        this.subscriber.unRuleSubscribe(ruleData);
        return Mono.just((Object)"success");
    }

    @GetMapping(value={"/plugin/rule/findList"})
    public Mono<String> findListRule(@RequestParam(value="selectorId") String selectorId, @RequestParam(value="id", required=false) String id) {
        List ruleDataList = BaseDataCache.getInstance().obtainRuleData(selectorId);
        if (CollectionUtils.isEmpty((Collection)ruleDataList)) {
            return Mono.just((Object)("Error: can not find rule data by selector id :" + selectorId));
        }
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            List result = ruleDataList.stream().filter(ruleData -> ruleData.getId().equals(id)).collect(Collectors.toList());
            return Mono.just((Object)JsonUtils.toJson(result));
        }
        return Mono.just((Object)JsonUtils.toJson((Object)ruleDataList));
    }

    private SelectorData buildDefaultSelectorData(SelectorData selectorData) {
        if (StringUtils.isEmpty((CharSequence)selectorData.getId())) {
            selectorData.setId(UUIDUtils.getInstance().generateShortUuid());
        }
        if (StringUtils.isEmpty((CharSequence)selectorData.getName())) {
            selectorData.setName(selectorData.getPluginName() + ":selector" + RandomUtils.nextInt((int)1, (int)1000));
        }
        if (Objects.isNull(selectorData.getMatchMode())) {
            selectorData.setMatchMode(Integer.valueOf(MatchModeEnum.AND.getCode()));
        }
        if (Objects.isNull(selectorData.getType())) {
            selectorData.setType(Integer.valueOf(SelectorTypeEnum.FULL_FLOW.getCode()));
        }
        if (Objects.isNull(selectorData.getSort())) {
            selectorData.setSort(Integer.valueOf(10));
        }
        if (Objects.isNull(selectorData.getEnabled())) {
            selectorData.setEnabled(Boolean.valueOf(true));
        }
        if (Objects.isNull(selectorData.getLogged())) {
            selectorData.setLogged(Boolean.valueOf(false));
        }
        if (Objects.isNull(selectorData.getMatchRestful())) {
            selectorData.setMatchRestful(Boolean.valueOf(false));
        }
        return selectorData;
    }

    private RuleData buildDefaultRuleData(RuleData ruleData) {
        if (StringUtils.isEmpty((CharSequence)ruleData.getId())) {
            ruleData.setId(UUIDUtils.getInstance().generateShortUuid());
        }
        if (StringUtils.isEmpty((CharSequence)ruleData.getName())) {
            ruleData.setName(ruleData.getPluginName() + ":rule" + RandomUtils.nextInt((int)1, (int)1000));
        }
        if (Objects.isNull(ruleData.getMatchMode())) {
            ruleData.setMatchMode(Integer.valueOf(MatchModeEnum.AND.getCode()));
        }
        if (Objects.isNull(ruleData.getSort())) {
            ruleData.setSort(Integer.valueOf(10));
        }
        if (Objects.isNull(ruleData.getEnabled())) {
            ruleData.setEnabled(Boolean.valueOf(true));
        }
        if (Objects.isNull(ruleData.getLoged())) {
            ruleData.setLoged(Boolean.valueOf(false));
        }
        if (Objects.isNull(ruleData.getMatchRestful())) {
            ruleData.setMatchRestful(Boolean.valueOf(false));
        }
        return ruleData;
    }

    public static class SelectorRuleData {
        private String pluginName;
        private String selectorName;
        private String selectorHandler;
        private String ruleHandler;
        private List<ConditionData> conditionDataList;

        public String getPluginName() {
            return this.pluginName;
        }

        public void setPluginName(String pluginName) {
            this.pluginName = pluginName;
        }

        public String getSelectorName() {
            return this.selectorName;
        }

        public void setSelectorName(String selectorName) {
            this.selectorName = selectorName;
        }

        public String getSelectorHandler() {
            return this.selectorHandler;
        }

        public void setSelectorHandler(String selectorHandler) {
            this.selectorHandler = selectorHandler;
        }

        public String getRuleHandler() {
            return this.ruleHandler;
        }

        public void setRuleHandler(String ruleHandler) {
            this.ruleHandler = ruleHandler;
        }

        public List<ConditionData> getConditionDataList() {
            return this.conditionDataList;
        }

        public void setConditionDataList(List<ConditionData> conditionDataList) {
            this.conditionDataList = conditionDataList;
        }
    }

    public static class SelectorRulesData {
        private String pluginName;
        private String selectorName;
        private Integer matchMode;
        private String selectorHandler;
        private Integer sort;
        private List<ConditionData> conditionDataList;
        private List<RuleLocalData> ruleDataList;

        public String getPluginName() {
            return this.pluginName;
        }

        public void setPluginName(String pluginName) {
            this.pluginName = pluginName;
        }

        public String getSelectorName() {
            return this.selectorName;
        }

        public void setSelectorName(String selectorName) {
            this.selectorName = selectorName;
        }

        public String getSelectorHandler() {
            return this.selectorHandler;
        }

        public void setSelectorHandler(String selectorHandler) {
            this.selectorHandler = selectorHandler;
        }

        public Integer getMatchMode() {
            return this.matchMode;
        }

        public void setMatchMode(Integer matchMode) {
            this.matchMode = matchMode;
        }

        public Integer getSort() {
            return this.sort;
        }

        public void setSort(Integer sort) {
            this.sort = sort;
        }

        public List<ConditionData> getConditionDataList() {
            return this.conditionDataList;
        }

        public void setConditionDataList(List<ConditionData> conditionDataList) {
            this.conditionDataList = conditionDataList;
        }

        public List<RuleLocalData> getRuleDataList() {
            return this.ruleDataList;
        }

        public void setRuleDataList(List<RuleLocalData> ruleDataList) {
            this.ruleDataList = ruleDataList;
        }
    }

    public static class RuleLocalData {
        private String ruleName;
        private String ruleHandler;
        private Integer matchMode;
        private List<ConditionData> conditionDataList;

        public String getRuleName() {
            return this.ruleName;
        }

        public void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public String getRuleHandler() {
            return this.ruleHandler;
        }

        public void setRuleHandler(String ruleHandler) {
            this.ruleHandler = ruleHandler;
        }

        public Integer getMatchMode() {
            return this.matchMode;
        }

        public void setMatchMode(Integer matchMode) {
            this.matchMode = matchMode;
        }

        public List<ConditionData> getConditionDataList() {
            return this.conditionDataList;
        }

        public void setConditionDataList(List<ConditionData> conditionDataList) {
            this.conditionDataList = conditionDataList;
        }
    }
}

