/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.accessLog.core.element.impl;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import org.apache.servicecomb.common.accessLog.core.element.AccessLogItem;
import org.apache.servicecomb.common.rest.codec.param.RestClientRequestImpl;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.ServerAccessLogEvent;

public class LocalPortAccessItem
implements AccessLogItem<RoutingContext> {
    public static final String EMPTY_RESULT = "-";

    @Override
    public void appendServerFormattedItem(ServerAccessLogEvent accessLogEvent, StringBuilder builder) {
        HttpServerRequest request = accessLogEvent.getRoutingContext().request();
        if (null == request || null == request.localAddress()) {
            builder.append(EMPTY_RESULT);
            return;
        }
        builder.append(request.localAddress().port());
    }

    @Override
    public void appendClientFormattedItem(InvocationFinishEvent finishEvent, StringBuilder builder) {
        RestClientRequestImpl restRequestImpl = (RestClientRequestImpl)finishEvent.getInvocation().getHandlerContext().get("servicecomb-invocation-hanlder-requestclient");
        if (null == restRequestImpl || null == restRequestImpl.getRequest() || null == restRequestImpl.getRequest().connection() || null == restRequestImpl.getRequest().connection().localAddress()) {
            builder.append(EMPTY_RESULT);
            return;
        }
        builder.append(restRequestImpl.getRequest().connection().localAddress().port());
    }
}

