/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.config.v1;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.BrokerPathConfigHelper;
import org.apache.rocketmq.broker.config.v1.RocksDBConfigManager;
import org.apache.rocketmq.broker.config.v1.RocksDBOffsetSerializeWrapper;
import org.apache.rocketmq.broker.offset.ConsumerOffsetManager;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.utils.DataConverter;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.rocksdb.CompressionType;
import org.rocksdb.WriteBatch;

public class RocksDBConsumerOffsetManager
extends ConsumerOffsetManager {
    protected static final Logger log = LoggerFactory.getLogger((String)"RocketmqBroker");
    private static final String VERSION_COLUMN_FAMILY = "consumerOffsetVersion";
    private static final String OFFSET_COLUMN_FAMILY = "consumerOffset";
    protected transient RocksDBConfigManager rocksDBConfigManager;
    private final boolean useSingleRocksDBForAllConfigs;
    private final String storePathRootDir;

    public RocksDBConsumerOffsetManager(BrokerController brokerController, boolean useSingleRocksDB, String storePathRootDir) {
        super(brokerController);
        this.useSingleRocksDBForAllConfigs = useSingleRocksDB;
        this.storePathRootDir = StringUtils.isBlank((CharSequence)storePathRootDir) ? brokerController.getMessageStoreConfig().getStorePathRootDir() : storePathRootDir;
        long flushInterval = brokerController.getMessageStoreConfig().getMemTableFlushIntervalMs();
        CompressionType compressionType = CompressionType.getCompressionType((String)brokerController.getMessageStoreConfig().getRocksdbCompressionType());
        String rocksDBPath = this.rocksdbConfigFilePath(storePathRootDir, useSingleRocksDB);
        this.rocksDBConfigManager = useSingleRocksDB ? new RocksDBConfigManager(rocksDBPath, flushInterval, compressionType, OFFSET_COLUMN_FAMILY, VERSION_COLUMN_FAMILY) : new RocksDBConfigManager(rocksDBPath, flushInterval, compressionType);
    }

    public RocksDBConsumerOffsetManager(BrokerController brokerController, boolean useSingleRocksDBForAllConfigs) {
        this(brokerController, useSingleRocksDBForAllConfigs, null);
    }

    public RocksDBConsumerOffsetManager(BrokerController brokerController) {
        this(brokerController, brokerController.getBrokerConfig().isUseSingleRocksDBForAllConfigs(), null);
    }

    public boolean load() {
        if (!this.rocksDBConfigManager.init()) {
            return false;
        }
        if (!this.loadDataVersion() || !this.loadConsumerOffset()) {
            return false;
        }
        if (this.useSingleRocksDBForAllConfigs) {
            this.migrateFromSeparateRocksDBs();
        }
        return true;
    }

    public boolean loadConsumerOffset() {
        return this.rocksDBConfigManager.loadData(this::decodeOffset) && this.merge();
    }

    private boolean merge() {
        if (!UtilAll.isPathExists((String)this.configFilePath()) && !UtilAll.isPathExists((String)(this.configFilePath() + ".bak"))) {
            log.info("consumerOffset json file does not exist, so skip merge");
            return true;
        }
        if (!super.loadDataVersion()) {
            log.error("load json consumerOffset dataVersion error, startup will exit");
            return false;
        }
        DataVersion dataVersion = super.getDataVersion();
        DataVersion kvDataVersion = this.getDataVersion();
        if (dataVersion.getCounter().get() > kvDataVersion.getCounter().get()) {
            if (!super.load()) {
                log.error("load json consumerOffset info failed, startup will exit");
                return false;
            }
            this.persist();
            this.getDataVersion().assignNewOne(dataVersion);
            this.updateDataVersion();
            log.info("update offset from json, dataVersion:{}, offsetTable: {} ", (Object)this.getDataVersion(), (Object)JSON.toJSONString(this.getOffsetTable()));
        }
        return true;
    }

    public boolean stop() {
        return this.rocksDBConfigManager.stop();
    }

    @Override
    protected void removeConsumerOffset(String topicAtGroup) {
        try {
            byte[] keyBytes = topicAtGroup.getBytes(DataConverter.CHARSET_UTF8);
            this.rocksDBConfigManager.delete(keyBytes);
        }
        catch (Exception e) {
            log.error("kv remove consumerOffset Failed, {}", (Object)topicAtGroup);
        }
    }

    protected void decodeOffset(byte[] key, byte[] body) {
        String topicAtGroup = new String(key, DataConverter.CHARSET_UTF8);
        RocksDBOffsetSerializeWrapper wrapper = (RocksDBOffsetSerializeWrapper)((Object)JSON.parseObject((byte[])body, RocksDBOffsetSerializeWrapper.class, (Feature[])new Feature[0]));
        this.offsetTable.put(topicAtGroup, wrapper.getOffsetTable());
        log.info("load exist local offset, {}, {}", (Object)topicAtGroup, wrapper.getOffsetTable());
    }

    public String rocksdbConfigFilePath(String storePathRootDir, boolean useSingleRocksDBForAllConfigs) {
        if (StringUtils.isBlank((CharSequence)storePathRootDir)) {
            storePathRootDir = this.brokerController.getMessageStoreConfig().getStorePathRootDir();
        }
        Path rootPath = Paths.get(storePathRootDir, new String[0]);
        if (useSingleRocksDBForAllConfigs) {
            return rootPath.resolve("config").resolve("metadata").toString();
        }
        return rootPath.resolve("config").resolve("consumerOffsets").toString();
    }

    @Override
    public String configFilePath() {
        return BrokerPathConfigHelper.getConsumerOffsetPath(this.storePathRootDir);
    }

    public synchronized void persist() {
        if (this.rocksDBConfigManager.isLoaded()) {
            try (WriteBatch writeBatch = new WriteBatch();){
                for (Map.Entry entry : this.offsetTable.entrySet()) {
                    this.putWriteBatch(writeBatch, (String)entry.getKey(), (ConcurrentMap)entry.getValue());
                    if (writeBatch.getDataSize() < 4096L) continue;
                    this.rocksDBConfigManager.batchPutWithWal(writeBatch);
                }
                this.rocksDBConfigManager.batchPutWithWal(writeBatch);
                this.rocksDBConfigManager.flushWAL();
            }
            catch (Exception e) {
                log.error("consumer offset persist Failed", (Throwable)e);
            }
        } else {
            log.warn("RocksDBConsumerOffsetManager has been stopped, persist fail");
        }
    }

    public synchronized void exportToJson() {
        log.info("RocksDBConsumerOffsetManager export consumer offset to json file");
        super.persist();
    }

    private void putWriteBatch(WriteBatch writeBatch, String topicGroupName, ConcurrentMap<Integer, Long> offsetMap) throws Exception {
        byte[] keyBytes = topicGroupName.getBytes(DataConverter.CHARSET_UTF8);
        RocksDBOffsetSerializeWrapper wrapper = new RocksDBOffsetSerializeWrapper();
        wrapper.setOffsetTable(offsetMap);
        byte[] valueBytes = JSON.toJSONBytes((Object)((Object)wrapper), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.BrowserCompatible});
        this.rocksDBConfigManager.writeBatchPutOperation(writeBatch, keyBytes, valueBytes);
    }

    @Override
    public boolean loadDataVersion() {
        return this.rocksDBConfigManager.loadDataVersion();
    }

    @Override
    public DataVersion getDataVersion() {
        return this.rocksDBConfigManager.getKvDataVersion();
    }

    @Override
    public void updateDataVersion() {
        try {
            this.rocksDBConfigManager.updateKvDataVersion();
        }
        catch (Exception e) {
            log.error("update consumer offset dataVersion error", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateFromSeparateRocksDBs() {
        String separateRocksDBPath = this.rocksdbConfigFilePath(this.storePathRootDir, false);
        if (!UtilAll.isPathExists((String)separateRocksDBPath)) {
            log.info("Separate RocksDB for consumer offsets does not exist at {}, no migration needed", (Object)separateRocksDBPath);
            return;
        }
        log.info("Starting migration from separate RocksDB at {} to unified RocksDB", (Object)separateRocksDBPath);
        RocksDBConfigManager separateRocksDBConfigManager = null;
        try {
            long memTableFlushIntervalMs = this.brokerController.getMessageStoreConfig().getMemTableFlushIntervalMs();
            CompressionType compressionType = CompressionType.getCompressionType((String)this.brokerController.getMessageStoreConfig().getRocksdbCompressionType());
            separateRocksDBConfigManager = new RocksDBConfigManager(separateRocksDBPath, memTableFlushIntervalMs, compressionType);
            if (!separateRocksDBConfigManager.init(true)) {
                log.error("Failed to initialize separate RocksDB in read-only mode");
                return;
            }
            if (!separateRocksDBConfigManager.loadDataVersion()) {
                log.error("Failed to load data version from separate RocksDB");
                return;
            }
            DataVersion separateDataVersion = separateRocksDBConfigManager.getKvDataVersion();
            DataVersion unifiedDataVersion = this.getDataVersion();
            log.info("Comparing data versions - Separate: {}, Unified: {}", (Object)separateDataVersion, (Object)unifiedDataVersion);
            if (separateDataVersion.getCounter().get() > unifiedDataVersion.getCounter().get()) {
                log.info("Separate RocksDB has newer data, importing...");
                if (separateRocksDBConfigManager.loadData(this::importConsumerOffset)) {
                    log.info("Successfully imported consumer offsets from separate RocksDB");
                    this.getDataVersion().assignNewOne(separateDataVersion);
                    this.getDataVersion().nextVersion();
                    this.updateDataVersion();
                    log.info("Updated unified data version to {}", (Object)this.getDataVersion());
                } else {
                    log.error("Failed to import consumer offsets from separate RocksDB");
                }
            } else {
                log.info("Unified RocksDB is already up-to-date, no migration needed");
            }
        }
        catch (Exception e) {
            log.error("Error during migration from separate RocksDB", (Throwable)e);
        }
        finally {
            if (separateRocksDBConfigManager != null) {
                try {
                    separateRocksDBConfigManager.stop();
                }
                catch (Exception e) {
                    log.warn("Error stopping separate RocksDB config manager", (Throwable)e);
                }
            }
        }
    }

    private void importConsumerOffset(byte[] key, byte[] body) {
        try {
            this.decodeOffset(key, body);
            this.rocksDBConfigManager.put(key, body);
        }
        catch (Exception e) {
            log.error("Error importing consumer offset", (Throwable)e);
        }
    }
}

