/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum LanguageCode {
    JAVA(0),
    CPP(1),
    DOTNET(2),
    PYTHON(3),
    DELPHI(4),
    ERLANG(5),
    RUBY(6),
    OTHER(7),
    HTTP(8),
    GO(9),
    PHP(10),
    OMS(11),
    RUST(12),
    NODE_JS(13);

    private byte code;
    private static final Map<String, LanguageCode> MAP;

    private LanguageCode(byte code) {
        this.code = code;
    }

    public static LanguageCode valueOf(byte code) {
        for (LanguageCode languageCode : LanguageCode.values()) {
            if (languageCode.getCode() != code) continue;
            return languageCode;
        }
        return null;
    }

    public byte getCode() {
        return this.code;
    }

    public static LanguageCode getCode(String language) {
        return MAP.get(language);
    }

    static {
        MAP = Arrays.stream(LanguageCode.values()).collect(Collectors.toMap(Enum::name, Function.identity()));
    }
}

