/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.kafka;

import org.apache.kafka.common.TopicPartition;

public class AtlasKafkaMessage<T> {
    private final T message;
    private final long offset;
    private final TopicPartition topicPartition;
    private final boolean spooled;
    private final long msgCreated;
    private final String source;
    private final String rawRecordData;

    public AtlasKafkaMessage(T message, long offset, String topic, int partition, long msgCreated, boolean spooled, String source, String rawRecordData) {
        this.message = message;
        this.offset = offset;
        this.topicPartition = new TopicPartition(topic, partition);
        this.msgCreated = msgCreated;
        this.spooled = spooled;
        this.source = source;
        this.rawRecordData = rawRecordData;
    }

    public AtlasKafkaMessage(T message, long offset, String topic, int partition, long msgCreated, boolean spooled, String source) {
        this(message, offset, topic, partition, msgCreated, spooled, source, null);
    }

    public AtlasKafkaMessage(T message, long offset, String topic, int partition, long msgCreated, boolean spooled) {
        this(message, offset, topic, partition, msgCreated, spooled, null);
    }

    public AtlasKafkaMessage(T message, long offset, String topic, int partition) {
        this(message, offset, topic, partition, 0L, false);
    }

    public T getMessage() {
        return this.message;
    }

    public long getOffset() {
        return this.offset;
    }

    public TopicPartition getTopicPartition() {
        return this.topicPartition;
    }

    public String getTopic() {
        return this.topicPartition.topic();
    }

    public int getPartition() {
        return this.topicPartition.partition();
    }

    public boolean getSpooled() {
        return this.spooled;
    }

    public long getMsgCreated() {
        return this.msgCreated;
    }

    public String getSource() {
        return this.source;
    }

    public String getRawRecordData() {
        return this.rawRecordData;
    }
}

