/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class NLMUpdateKeyUpdate extends NLM implements Message {

  // Accessors for discriminator values.
  public Short getMessageType() {
    return (short) 0x0E;
  }

  // Properties.
  protected final NLMUpdateKeyUpdateControlFlags controlFlags;
  protected final Byte set1KeyRevision;
  protected final Long set1ActivationTime;
  protected final Long set1ExpirationTime;
  protected final Short set1KeyCount;
  protected final List<NLMUpdateKeyUpdateKeyEntry> set1Keys;
  protected final Byte set2KeyRevision;
  protected final Long set2ActivationTime;
  protected final Long set2ExpirationTime;
  protected final Short set2KeyCount;
  protected final List<NLMUpdateKeyUpdateKeyEntry> set2Keys;

  // Arguments.
  protected final Integer apduLength;

  public NLMUpdateKeyUpdate(
      NLMUpdateKeyUpdateControlFlags controlFlags,
      Byte set1KeyRevision,
      Long set1ActivationTime,
      Long set1ExpirationTime,
      Short set1KeyCount,
      List<NLMUpdateKeyUpdateKeyEntry> set1Keys,
      Byte set2KeyRevision,
      Long set2ActivationTime,
      Long set2ExpirationTime,
      Short set2KeyCount,
      List<NLMUpdateKeyUpdateKeyEntry> set2Keys,
      Integer apduLength) {
    super(apduLength);
    this.controlFlags = controlFlags;
    this.set1KeyRevision = set1KeyRevision;
    this.set1ActivationTime = set1ActivationTime;
    this.set1ExpirationTime = set1ExpirationTime;
    this.set1KeyCount = set1KeyCount;
    this.set1Keys = set1Keys;
    this.set2KeyRevision = set2KeyRevision;
    this.set2ActivationTime = set2ActivationTime;
    this.set2ExpirationTime = set2ExpirationTime;
    this.set2KeyCount = set2KeyCount;
    this.set2Keys = set2Keys;
    this.apduLength = apduLength;
  }

  public NLMUpdateKeyUpdateControlFlags getControlFlags() {
    return controlFlags;
  }

  public Byte getSet1KeyRevision() {
    return set1KeyRevision;
  }

  public Long getSet1ActivationTime() {
    return set1ActivationTime;
  }

  public Long getSet1ExpirationTime() {
    return set1ExpirationTime;
  }

  public Short getSet1KeyCount() {
    return set1KeyCount;
  }

  public List<NLMUpdateKeyUpdateKeyEntry> getSet1Keys() {
    return set1Keys;
  }

  public Byte getSet2KeyRevision() {
    return set2KeyRevision;
  }

  public Long getSet2ActivationTime() {
    return set2ActivationTime;
  }

  public Long getSet2ExpirationTime() {
    return set2ExpirationTime;
  }

  public Short getSet2KeyCount() {
    return set2KeyCount;
  }

  public List<NLMUpdateKeyUpdateKeyEntry> getSet2Keys() {
    return set2Keys;
  }

  @Override
  protected void serializeNLMChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("NLMUpdateKeyUpdate");

    // Simple Field (controlFlags)
    writeSimpleField("controlFlags", controlFlags, writeComplex(writeBuffer));

    // Optional Field (set1KeyRevision) (Can be skipped, if the value is null)
    writeOptionalField(
        "set1KeyRevision",
        set1KeyRevision,
        writeByte(writeBuffer, 8),
        getControlFlags().getSet1KeyRevisionActivationTimeExpirationTimePresent());

    // Optional Field (set1ActivationTime) (Can be skipped, if the value is null)
    writeOptionalField(
        "set1ActivationTime",
        set1ActivationTime,
        writeUnsignedLong(writeBuffer, 32),
        getControlFlags().getSet1KeyRevisionActivationTimeExpirationTimePresent());

    // Optional Field (set1ExpirationTime) (Can be skipped, if the value is null)
    writeOptionalField(
        "set1ExpirationTime",
        set1ExpirationTime,
        writeUnsignedLong(writeBuffer, 32),
        getControlFlags().getSet1KeyCountKeyParametersPresent());

    // Optional Field (set1KeyCount) (Can be skipped, if the value is null)
    writeOptionalField(
        "set1KeyCount",
        set1KeyCount,
        writeUnsignedShort(writeBuffer, 8),
        getControlFlags().getSet1KeyCountKeyParametersPresent());

    // Array Field (set1Keys)
    writeComplexTypeArrayField("set1Keys", set1Keys, writeBuffer);

    // Optional Field (set2KeyRevision) (Can be skipped, if the value is null)
    writeOptionalField(
        "set2KeyRevision",
        set2KeyRevision,
        writeByte(writeBuffer, 8),
        getControlFlags().getSet1KeyRevisionActivationTimeExpirationTimePresent());

    // Optional Field (set2ActivationTime) (Can be skipped, if the value is null)
    writeOptionalField(
        "set2ActivationTime",
        set2ActivationTime,
        writeUnsignedLong(writeBuffer, 32),
        getControlFlags().getSet1KeyRevisionActivationTimeExpirationTimePresent());

    // Optional Field (set2ExpirationTime) (Can be skipped, if the value is null)
    writeOptionalField(
        "set2ExpirationTime",
        set2ExpirationTime,
        writeUnsignedLong(writeBuffer, 32),
        getControlFlags().getSet1KeyCountKeyParametersPresent());

    // Optional Field (set2KeyCount) (Can be skipped, if the value is null)
    writeOptionalField(
        "set2KeyCount",
        set2KeyCount,
        writeUnsignedShort(writeBuffer, 8),
        getControlFlags().getSet1KeyCountKeyParametersPresent());

    // Array Field (set2Keys)
    writeComplexTypeArrayField("set2Keys", set2Keys, writeBuffer);

    writeBuffer.popContext("NLMUpdateKeyUpdate");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    NLMUpdateKeyUpdate _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (controlFlags)
    lengthInBits += controlFlags.getLengthInBits();

    // Optional Field (set1KeyRevision)
    if (set1KeyRevision != null) {
      lengthInBits += 8;
    }

    // Optional Field (set1ActivationTime)
    if (set1ActivationTime != null) {
      lengthInBits += 32;
    }

    // Optional Field (set1ExpirationTime)
    if (set1ExpirationTime != null) {
      lengthInBits += 32;
    }

    // Optional Field (set1KeyCount)
    if (set1KeyCount != null) {
      lengthInBits += 8;
    }

    // Array field
    if (set1Keys != null) {
      int i = 0;
      for (NLMUpdateKeyUpdateKeyEntry element : set1Keys) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= set1Keys.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Optional Field (set2KeyRevision)
    if (set2KeyRevision != null) {
      lengthInBits += 8;
    }

    // Optional Field (set2ActivationTime)
    if (set2ActivationTime != null) {
      lengthInBits += 32;
    }

    // Optional Field (set2ExpirationTime)
    if (set2ExpirationTime != null) {
      lengthInBits += 32;
    }

    // Optional Field (set2KeyCount)
    if (set2KeyCount != null) {
      lengthInBits += 8;
    }

    // Array field
    if (set2Keys != null) {
      int i = 0;
      for (NLMUpdateKeyUpdateKeyEntry element : set2Keys) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= set2Keys.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static NLMBuilder staticParseNLMBuilder(ReadBuffer readBuffer, Integer apduLength)
      throws ParseException {
    readBuffer.pullContext("NLMUpdateKeyUpdate");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    NLMUpdateKeyUpdateControlFlags controlFlags =
        readSimpleField(
            "controlFlags",
            readComplex(() -> NLMUpdateKeyUpdateControlFlags.staticParse(readBuffer), readBuffer));

    Byte set1KeyRevision =
        readOptionalField(
            "set1KeyRevision",
            readByte(readBuffer, 8),
            controlFlags.getSet1KeyRevisionActivationTimeExpirationTimePresent());

    Long set1ActivationTime =
        readOptionalField(
            "set1ActivationTime",
            readUnsignedLong(readBuffer, 32),
            controlFlags.getSet1KeyRevisionActivationTimeExpirationTimePresent());

    Long set1ExpirationTime =
        readOptionalField(
            "set1ExpirationTime",
            readUnsignedLong(readBuffer, 32),
            controlFlags.getSet1KeyCountKeyParametersPresent());

    Short set1KeyCount =
        readOptionalField(
            "set1KeyCount",
            readUnsignedShort(readBuffer, 8),
            controlFlags.getSet1KeyCountKeyParametersPresent());

    List<NLMUpdateKeyUpdateKeyEntry> set1Keys =
        readCountArrayField(
            "set1Keys",
            readComplex(() -> NLMUpdateKeyUpdateKeyEntry.staticParse(readBuffer), readBuffer),
            (((set1KeyCount) != (null)) ? set1KeyCount : 0));

    Byte set2KeyRevision =
        readOptionalField(
            "set2KeyRevision",
            readByte(readBuffer, 8),
            controlFlags.getSet1KeyRevisionActivationTimeExpirationTimePresent());

    Long set2ActivationTime =
        readOptionalField(
            "set2ActivationTime",
            readUnsignedLong(readBuffer, 32),
            controlFlags.getSet1KeyRevisionActivationTimeExpirationTimePresent());

    Long set2ExpirationTime =
        readOptionalField(
            "set2ExpirationTime",
            readUnsignedLong(readBuffer, 32),
            controlFlags.getSet1KeyCountKeyParametersPresent());

    Short set2KeyCount =
        readOptionalField(
            "set2KeyCount",
            readUnsignedShort(readBuffer, 8),
            controlFlags.getSet1KeyCountKeyParametersPresent());

    List<NLMUpdateKeyUpdateKeyEntry> set2Keys =
        readCountArrayField(
            "set2Keys",
            readComplex(() -> NLMUpdateKeyUpdateKeyEntry.staticParse(readBuffer), readBuffer),
            (((set1KeyCount) != (null)) ? set1KeyCount : 0));

    readBuffer.closeContext("NLMUpdateKeyUpdate");
    // Create the instance
    return new NLMUpdateKeyUpdateBuilderImpl(
        controlFlags,
        set1KeyRevision,
        set1ActivationTime,
        set1ExpirationTime,
        set1KeyCount,
        set1Keys,
        set2KeyRevision,
        set2ActivationTime,
        set2ExpirationTime,
        set2KeyCount,
        set2Keys,
        apduLength);
  }

  public static class NLMUpdateKeyUpdateBuilderImpl implements NLM.NLMBuilder {
    private final NLMUpdateKeyUpdateControlFlags controlFlags;
    private final Byte set1KeyRevision;
    private final Long set1ActivationTime;
    private final Long set1ExpirationTime;
    private final Short set1KeyCount;
    private final List<NLMUpdateKeyUpdateKeyEntry> set1Keys;
    private final Byte set2KeyRevision;
    private final Long set2ActivationTime;
    private final Long set2ExpirationTime;
    private final Short set2KeyCount;
    private final List<NLMUpdateKeyUpdateKeyEntry> set2Keys;
    private final Integer apduLength;

    public NLMUpdateKeyUpdateBuilderImpl(
        NLMUpdateKeyUpdateControlFlags controlFlags,
        Byte set1KeyRevision,
        Long set1ActivationTime,
        Long set1ExpirationTime,
        Short set1KeyCount,
        List<NLMUpdateKeyUpdateKeyEntry> set1Keys,
        Byte set2KeyRevision,
        Long set2ActivationTime,
        Long set2ExpirationTime,
        Short set2KeyCount,
        List<NLMUpdateKeyUpdateKeyEntry> set2Keys,
        Integer apduLength) {
      this.controlFlags = controlFlags;
      this.set1KeyRevision = set1KeyRevision;
      this.set1ActivationTime = set1ActivationTime;
      this.set1ExpirationTime = set1ExpirationTime;
      this.set1KeyCount = set1KeyCount;
      this.set1Keys = set1Keys;
      this.set2KeyRevision = set2KeyRevision;
      this.set2ActivationTime = set2ActivationTime;
      this.set2ExpirationTime = set2ExpirationTime;
      this.set2KeyCount = set2KeyCount;
      this.set2Keys = set2Keys;
      this.apduLength = apduLength;
    }

    public NLMUpdateKeyUpdate build(Integer apduLength) {

      NLMUpdateKeyUpdate nLMUpdateKeyUpdate =
          new NLMUpdateKeyUpdate(
              controlFlags,
              set1KeyRevision,
              set1ActivationTime,
              set1ExpirationTime,
              set1KeyCount,
              set1Keys,
              set2KeyRevision,
              set2ActivationTime,
              set2ExpirationTime,
              set2KeyCount,
              set2Keys,
              apduLength);
      return nLMUpdateKeyUpdate;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof NLMUpdateKeyUpdate)) {
      return false;
    }
    NLMUpdateKeyUpdate that = (NLMUpdateKeyUpdate) o;
    return (getControlFlags() == that.getControlFlags())
        && (getSet1KeyRevision() == that.getSet1KeyRevision())
        && (getSet1ActivationTime() == that.getSet1ActivationTime())
        && (getSet1ExpirationTime() == that.getSet1ExpirationTime())
        && (getSet1KeyCount() == that.getSet1KeyCount())
        && (getSet1Keys() == that.getSet1Keys())
        && (getSet2KeyRevision() == that.getSet2KeyRevision())
        && (getSet2ActivationTime() == that.getSet2ActivationTime())
        && (getSet2ExpirationTime() == that.getSet2ExpirationTime())
        && (getSet2KeyCount() == that.getSet2KeyCount())
        && (getSet2Keys() == that.getSet2Keys())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getControlFlags(),
        getSet1KeyRevision(),
        getSet1ActivationTime(),
        getSet1ExpirationTime(),
        getSet1KeyCount(),
        getSet1Keys(),
        getSet2KeyRevision(),
        getSet2ActivationTime(),
        getSet2ExpirationTime(),
        getSet2KeyCount(),
        getSet2Keys());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
