/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import * as React from 'react';
import SvgIcon, { SvgIconProps } from '@material-ui/core/SvgIcon';

export default (props: SvgIconProps) => (
  <SvgIcon style={{ width: 24, height: 24, verticalAlign: 'middle', transform: 'scale(1.5)' }} viewBox="0 0 980.2 980.2" fill="none" {...props}>
    <g>
      <path d="M207.5,594.4c0,0,338.6,37.9,471.6,108.1s250.9,79.3,129.7-12.7C687.5,597.8,403.4,494.9,207.5,594.4z" />
      <path d="M730.8,269.1C572.7,203.8,381.1,220.6,290,244C198.8,267.3,9.8,345.1,0.5,443.8c-5.2,55.3,28.3,94.7,77.7,122.5
        c-1-3.1-1.8-6.1-2.8-9.1l-5.7-18.1l16-10.5c29.2-19.1,78.2-46.2,145.8-67.3c65.9-20.6,135.1-31.1,205.6-31.1c1.6,0,3.2,0,4.9,0.1
        l14.6-12.6l-77.7-6.9l3.5-21.5l134.4,15.6l-31.7,27c16.8,1.1,33.8,2.9,50.6,5.2c7.8-7,18.3-13.3,32.7-18.2
        c29.5-10.1,71,3.8,89.5,38.2c1.7,3.2,3.2,6.5,4.4,9.8c11.4,4,22.7,8.4,33.7,13.2c6.8-7.3,19.5-16.6,35.6-16.4
        c18,0.2,38,13.1,46.9,22.8c8.2,9.1,22.5,30.6,24.7,55.5c2.8,2.2,5.6,4.2,8.3,6.4c49.7,39.6,72.4,74.4,73.3,76l6.2,9.6l-3.1,10.9
        c-0.8,2.5-1.7,5.4-3.6,9c35.5-20.3,79.5-55.1,92.8-107.9C1000.2,453,889,334.2,730.8,269.1z"
      />
      <path d="M799.9,571.4c-5.6,16.5-18.2,28.4-40.6,29c-31.9,0.9-58-28.5-70.1-52.3c-7.7-15-8-31.8-4.6-45.5c-5.7-2.4-11.5-4.7-17.5-7
        c-0.8,23.3-13.2,44.3-37.5,50.9c-37.7,10.1-76.9-6.7-97.3-31.6c-9.9-12.1-18.2-33.7-11.8-54.4c-21.6-2.6-42.7-4.1-63.2-4.7
        l-48.1,40.8l85.8,9.3l-4.6,22l-143.9-14.5l66.2-57.5c-137.2,5-246.6,50.4-313.2,93.9c0,0,21.8,68.7,20.1,82.9c0,0,6-4.2,38.3-14.7
        l-5.7-23.4l44.1-22.4c56.7-28.8,123.4-43.5,198.1-43.5c167.3,0,340,73.1,429.6,141.2c3.5,2.6,6.7,5.2,9.9,7.8
        c12.9-13.2,26.6-29,29.8-39.7C863.4,637.8,844,607.3,799.9,571.4z"
      />
      <path d="M635.6,503.2c-7.6,16.9-28.9,29.1-56.5,17.4c-27.6-11.8-31.7-39.4-26.8-53c4.5-12.4,16.5-21.9,26.5-25.2
        c10-3.3,34.3-1.7,46.5,12S643.2,486.2,635.6,503.2z"
      />
      <path d="M768.8,569c-15,14.1-40.2,1.9-50.6-14.6c-10.5-16.5-9.8-36-5.4-47.6c0,0,10.7-21.3,31.3-17.4s31.1,24.2,33.9,35.7
        C780.8,536.8,783.8,555,768.8,569z"
      />
    </g>
  </SvgIcon>
);
