/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.evaluation;

import java.io.IOException;
import org.apache.pig.EvalFunc;
import org.apache.pig.PigWarning;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class IsLong
extends EvalFunc<Boolean> {
    public Boolean exec(Tuple input) throws IOException {
        if (input == null || input.size() == 0) {
            return false;
        }
        try {
            String str = (String)input.get(0);
            if (str == null || str.length() == 0) {
                return false;
            }
            Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        catch (ClassCastException e) {
            this.warn("Unable to cast input " + input.get(0) + " of class " + input.get(0).getClass() + " to String", (Enum)PigWarning.UDF_WARNING_1);
            return false;
        }
        return true;
    }

    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 5));
    }
}

