/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.avro;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.pig.Expression;
import org.apache.pig.FileInputLoadFunc;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFunc;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.StoreResources;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.builtin.FuncUtils;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.piggybank.storage.avro.AvroSchema2Pig;
import org.apache.pig.piggybank.storage.avro.AvroSchemaManager;
import org.apache.pig.piggybank.storage.avro.AvroStorageLog;
import org.apache.pig.piggybank.storage.avro.AvroStorageUtils;
import org.apache.pig.piggybank.storage.avro.PigAvroInputFormat;
import org.apache.pig.piggybank.storage.avro.PigAvroOutputFormat;
import org.apache.pig.piggybank.storage.avro.PigAvroRecordReader;
import org.apache.pig.piggybank.storage.avro.PigAvroRecordWriter;
import org.apache.pig.piggybank.storage.avro.PigSchema2Avro;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class AvroStorage
extends FileInputLoadFunc
implements StoreFuncInterface,
LoadMetadata,
StoreResources {
    private static final Log LOG = LogFactory.getLog(AvroStorage.class);
    private static final String NOTNULL = "NOTNULL";
    private static final String AVRO_OUTPUT_SCHEMA_PROPERTY = "avro_output_schema";
    private static final String AVRO_INPUT_SCHEMA_PROPERTY = "avro_input_schema";
    private static final String AVRO_INPUT_PIG_SCHEMA_PROPERTY = "avro_input_pig_schema";
    private static final String AVRO_MERGED_SCHEMA_PROPERTY = "avro_merged_schema_map";
    private static final String SCHEMA_DELIM = "#";
    private static final String SCHEMA_KEYVALUE_DELIM = "@";
    private static final String NO_SCHEMA_CHECK = "no_schema_check";
    private static final String IGNORE_BAD_FILES = "ignore_bad_files";
    private static final String MULTIPLE_SCHEMAS = "multiple_schemas";
    private int storeFuncIndex = 0;
    private PigAvroRecordWriter writer = null;
    private Schema outputAvroSchema = null;
    private boolean nullable = true;
    private PigAvroRecordReader reader = null;
    private Schema inputAvroSchema = null;
    private Schema userSpecifiedAvroSchema = null;
    private Map<Path, Map<Integer, Integer>> schemaToMergedSchemaMap = null;
    private boolean useMultipleSchemas = false;
    private boolean checkSchema = true;
    private boolean ignoreBadFiles = false;
    private String contextSignature = null;

    public AvroStorage() {
        AvroStorageLog.setDebugLevel(0);
        this.checkSchema = true;
    }

    public AvroStorage(String[] parts) throws IOException, ParseException {
        this.checkSchema = true;
        if (!(parts.length != 1 || parts[0].equalsIgnoreCase(NO_SCHEMA_CHECK) || parts[0].equalsIgnoreCase(IGNORE_BAD_FILES) || parts[0].equalsIgnoreCase(MULTIPLE_SCHEMAS))) {
            this.init(this.parseJsonString(parts[0]));
        } else {
            this.init(this.parseStringList(parts));
        }
    }

    public void setLocation(String location, Job job) throws IOException {
        if (this.inputAvroSchema != null) {
            return;
        }
        if (!UDFContext.getUDFContext().isFrontend()) {
            String schema;
            Properties udfProps = this.getUDFProperties();
            String mergedSchema = udfProps.getProperty(AVRO_MERGED_SCHEMA_PROPERTY);
            if (mergedSchema != null) {
                HashMap mergedSchemaMap = (HashMap)ObjectSerializer.deserialize((String)mergedSchema);
                this.schemaToMergedSchemaMap = new HashMap<Path, Map<Integer, Integer>>();
                for (Map.Entry entry : mergedSchemaMap.entrySet()) {
                    this.schemaToMergedSchemaMap.put(new Path((URI)entry.getKey()), (Map<Integer, Integer>)entry.getValue());
                }
            }
            if ((schema = udfProps.getProperty(AVRO_INPUT_SCHEMA_PROPERTY)) != null) {
                try {
                    this.inputAvroSchema = new Schema.Parser().parse(schema);
                    return;
                }
                catch (Exception e) {
                    LOG.warn((Object)("Exception while trying to deserialize schema in backend. Will construct again. schema= " + schema), (Throwable)e);
                }
            }
        }
        if (this.inputAvroSchema == null || UDFContext.getUDFContext().isFrontend()) {
            Configuration conf = job.getConfiguration();
            Set paths = AvroStorage.getGlobPaths((String)location, (Configuration)conf, (boolean)true);
            if (!paths.isEmpty()) {
                FileInputFormat.setInputPaths((Job)job, (Path[])paths.toArray(new Path[paths.size()]));
                if (this.inputAvroSchema == null) {
                    this.setInputAvroSchema(paths, conf);
                }
            } else {
                throw new IOException("Input path '" + location + "' is not found");
            }
        }
    }

    public void setUDFContextSignature(String signature) {
        this.contextSignature = signature;
        super.setUDFContextSignature(signature);
    }

    protected void setInputAvroSchema(Set<Path> paths, Configuration conf) throws IOException {
        this.inputAvroSchema = this.userSpecifiedAvroSchema != null ? this.userSpecifiedAvroSchema : (this.useMultipleSchemas ? this.getMergedSchema(paths, conf) : this.getAvroSchema(paths, conf));
    }

    protected Schema getAvroSchema(Set<Path> paths, Configuration conf) throws IOException {
        FileSystem fs;
        Path path;
        if (paths == null || paths.isEmpty()) {
            return null;
        }
        Iterator<Path> iterator = paths.iterator();
        Schema schema = null;
        while (iterator.hasNext() && (schema = this.getAvroSchema(path = iterator.next(), fs = FileSystem.get((URI)path.toUri(), (Configuration)conf))) == null) {
        }
        return schema;
    }

    protected Schema getAvroSchema(Path path, FileSystem fs) throws IOException {
        if (!fs.exists(path) || !Utils.VISIBLE_FILES.accept(path)) {
            return null;
        }
        if (!fs.isDirectory(path)) {
            return this.getSchema(path, fs);
        }
        FileStatus[] ss = fs.listStatus(path, Utils.VISIBLE_FILES);
        Schema schema = null;
        if (ss.length > 0) {
            if (AvroStorageUtils.noDir(ss)) {
                return this.getSchema(path, fs);
            }
            for (FileStatus s : ss) {
                Schema newSchema = this.getAvroSchema(s.getPath(), fs);
                if (schema == null) {
                    schema = newSchema;
                    if (this.checkSchema) continue;
                    System.out.println("Do not check schema; use schema of " + s.getPath());
                    return schema;
                }
                if (newSchema == null || schema.equals((Object)newSchema)) continue;
                throw new IOException("Input path is " + path + ". Sub-direcotry " + s.getPath() + " contains different schema " + newSchema + " than " + schema);
            }
        }
        if (schema == null) {
            System.err.println("Cannot get avro schema! Input path " + path + " might be empty.");
        }
        return schema;
    }

    protected Schema getMergedSchema(Set<Path> basePaths, Configuration conf) throws IOException {
        Schema result = null;
        HashMap<Path, Schema> mergedFiles = new HashMap<Path, Schema>();
        Set<Path> paths = AvroStorageUtils.getAllFilesRecursively(basePaths, conf);
        for (Path path : paths) {
            FileSystem fs;
            Schema schema = this.getSchema(path, fs = FileSystem.get((URI)path.toUri(), (Configuration)conf));
            if (schema == null) continue;
            result = AvroStorageUtils.mergeSchema(result, schema);
            mergedFiles.put(path, schema);
        }
        if ((this.schemaToMergedSchemaMap == null || this.schemaToMergedSchemaMap.isEmpty()) && mergedFiles.size() > 1 && result.getType().equals((Object)Schema.Type.RECORD)) {
            this.schemaToMergedSchemaMap = AvroStorageUtils.getSchemaToMergedSchemaMap(result, mergedFiles);
        }
        return result;
    }

    protected Schema getSchema(Path path, FileSystem fs) throws IOException {
        return AvroStorageUtils.getSchema(path, fs);
    }

    protected Schema getSchemaFromFile(Path path, FileSystem fs) throws IOException {
        Path lastFile = AvroStorageUtils.getLast(path, fs);
        if (lastFile == null) {
            return null;
        }
        GenericDatumReader avroReader = new GenericDatumReader();
        FSDataInputStream hdfsInputStream = fs.open(lastFile);
        Schema ret = Schema.parse((InputStream)hdfsInputStream);
        hdfsInputStream.close();
        return ret;
    }

    public InputFormat getInputFormat() throws IOException {
        AvroStorageLog.funcCall("getInputFormat");
        Object result = null;
        result = this.inputAvroSchema != null ? new PigAvroInputFormat(this.inputAvroSchema, this.ignoreBadFiles, this.schemaToMergedSchemaMap, this.useMultipleSchemas) : new TextInputFormat();
        return result;
    }

    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        AvroStorageLog.funcCall("prepareToRead");
        this.reader = (PigAvroRecordReader)reader;
    }

    public Tuple getNext() throws IOException {
        try {
            if (!this.reader.nextKeyValue()) {
                return null;
            }
            return (Tuple)this.reader.getCurrentValue();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public ResourceSchema getSchema(String location, Job job) throws IOException {
        Configuration conf;
        Set paths;
        AvroStorageLog.funcCall("getSchema");
        if (this.inputAvroSchema == null && !(paths = AvroStorage.getGlobPaths((String)location, (Configuration)(conf = job.getConfiguration()), (boolean)false)).isEmpty()) {
            this.setInputAvroSchema(paths, conf);
        }
        if (this.inputAvroSchema != null) {
            AvroStorageLog.details("avro input schema:" + this.inputAvroSchema);
            ResourceSchema pigSchema = AvroSchema2Pig.convert(this.inputAvroSchema);
            AvroStorageLog.details("pig input schema:" + pigSchema);
            if (pigSchema.getFields().length == 1) {
                pigSchema = pigSchema.getFields()[0].getSchema();
            }
            Properties udfProps = this.getUDFProperties();
            udfProps.put(AVRO_INPUT_SCHEMA_PROPERTY, this.inputAvroSchema.toString());
            udfProps.put(AVRO_INPUT_PIG_SCHEMA_PROPERTY, pigSchema);
            if (this.schemaToMergedSchemaMap != null) {
                HashMap<URI, Map<Integer, Integer>> mergedSchemaMap = new HashMap<URI, Map<Integer, Integer>>();
                for (Map.Entry<Path, Map<Integer, Integer>> entry : this.schemaToMergedSchemaMap.entrySet()) {
                    mergedSchemaMap.put(entry.getKey().toUri(), entry.getValue());
                }
                udfProps.put(AVRO_MERGED_SCHEMA_PROPERTY, ObjectSerializer.serialize(mergedSchemaMap));
            }
            return pigSchema;
        }
        return null;
    }

    public ResourceStatistics getStatistics(String location, Job job) throws IOException {
        return null;
    }

    public String[] getPartitionKeys(String location, Job job) throws IOException {
        return null;
    }

    public void setPartitionFilter(Expression partitionFilter) throws IOException {
    }

    protected Map<String, Object> parseJsonString(String jsonString) throws ParseException {
        JSONParser parser = new JSONParser();
        JSONObject obj = (JSONObject)parser.parse(jsonString);
        Set entries = obj.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key.equalsIgnoreCase("debug") || key.equalsIgnoreCase("index")) {
                int v = ((Long)value).intValue();
                obj.put((Object)key, (Object)v);
                continue;
            }
            if (!key.equalsIgnoreCase("schema") && !key.matches("field\\d+")) continue;
            obj.put((Object)key, (Object)value.toString().trim());
        }
        return obj;
    }

    protected Map<String, Object> parseStringList(String[] parts) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int i = 0;
        while (i < parts.length) {
            String name = parts[i].trim();
            if (name.equalsIgnoreCase(NO_SCHEMA_CHECK)) {
                this.checkSchema = false;
                ++i;
                continue;
            }
            if (name.equalsIgnoreCase(IGNORE_BAD_FILES)) {
                this.ignoreBadFiles = true;
                ++i;
                continue;
            }
            if (name.equalsIgnoreCase(MULTIPLE_SCHEMAS)) {
                this.useMultipleSchemas = true;
                ++i;
                continue;
            }
            String value = parts[i + 1].trim();
            if (name.equalsIgnoreCase("debug") || name.equalsIgnoreCase("index")) {
                map.put(name, Integer.parseInt(value));
            } else if (name.equalsIgnoreCase("data") || name.equalsIgnoreCase("same") || name.equalsIgnoreCase("schema") || name.equalsIgnoreCase("schema_file") || name.equalsIgnoreCase("schema_uri") || name.matches("field\\d+")) {
                map.put(name, value);
            } else if (name.equalsIgnoreCase("nullable")) {
                map.put(name, Boolean.getBoolean(value));
            } else {
                throw new IOException("Invalid parameter:" + name);
            }
            i += 2;
        }
        return map;
    }

    protected void init(Map<String, Object> inputs) throws IOException {
        Schema schema;
        FileSystem fs;
        Path path;
        ArrayList<Schema.Field> fields = null;
        if (inputs.containsKey("debug")) {
            AvroStorageLog.setDebugLevel((Integer)inputs.get("debug"));
        }
        AvroSchemaManager schemaManager = null;
        if (inputs.containsKey("data")) {
            path = new Path((String)inputs.get("data"));
            AvroStorageLog.details("data path=" + path.toUri().toString());
            fs = FileSystem.get((URI)path.toUri(), (Configuration)new Configuration());
            schema = this.getAvroSchema(path, fs);
            schemaManager = new AvroSchemaManager(schema);
        } else if (inputs.containsKey("schema_file")) {
            path = new Path((String)inputs.get("schema_file"));
            AvroStorageLog.details("schemaFile path=" + path.toUri().toString());
            fs = FileSystem.get((URI)path.toUri(), (Configuration)new Configuration());
            schema = this.getSchemaFromFile(path, fs);
            schemaManager = new AvroSchemaManager(schema);
        }
        for (Map.Entry<String, Object> entry : inputs.entrySet()) {
            FileSystem fs2;
            String name = entry.getKey().trim();
            Object value = entry.getValue();
            if (name.equalsIgnoreCase("index")) {
                this.storeFuncIndex = (Integer)value;
                continue;
            }
            if (name.equalsIgnoreCase("same")) {
                Path path2 = new Path(((String)value).trim());
                AvroStorageLog.details("data path=" + path2.toUri().toString());
                fs2 = FileSystem.get((URI)path2.toUri(), (Configuration)new Configuration());
                this.outputAvroSchema = this.getAvroSchema(path2, fs2);
                continue;
            }
            if (name.equalsIgnoreCase("nullable")) {
                this.nullable = (Boolean)value;
                continue;
            }
            if (name.equalsIgnoreCase("schema")) {
                this.userSpecifiedAvroSchema = this.outputAvroSchema = Schema.parse((String)((String)value));
                continue;
            }
            if (name.equalsIgnoreCase("schema_uri")) {
                Path path3 = new Path(((String)value).trim());
                AvroStorageLog.details("schema_uri path=" + path3.toUri().toString());
                fs2 = FileSystem.get((URI)path3.toUri(), (Configuration)new Configuration());
                this.userSpecifiedAvroSchema = this.outputAvroSchema = this.getSchemaFromFile(path3, fs2);
                continue;
            }
            if (name.matches("field\\d+")) {
                if (fields == null) {
                    fields = new ArrayList<Schema.Field>();
                }
                int index = Integer.parseInt(name.substring("field".length()));
                String content = ((String)value).trim();
                Schema.Field field = null;
                if (content.equalsIgnoreCase(NOTNULL)) {
                    field = AvroStorageUtils.createUDField(index, null);
                } else if (content.startsWith("def:")) {
                    if (schemaManager == null) {
                        throw new IOException("Please specify data parameter (using \"data\") before this one.");
                    }
                    String alias = content.substring("def:".length());
                    Schema s = schemaManager.getSchema(alias);
                    if (s == null) {
                        throw new IOException("Cannot find matching schema for alias:" + alias);
                    }
                    field = AvroStorageUtils.createUDField(index, s);
                    AvroStorageLog.details("Use pre-defined schema(" + alias + "): " + s + " for field " + index);
                } else {
                    Schema schema2 = null;
                    try {
                        schema2 = Schema.parse((String)content);
                    }
                    catch (RuntimeException e) {
                        schema2 = Schema.parse((String)("\"" + content + "\""));
                    }
                    field = AvroStorageUtils.createUDField(index, schema2);
                }
                fields.add(field);
                continue;
            }
            if (name.equalsIgnoreCase("data") || name.equalsIgnoreCase("schema_file") || name.equalsIgnoreCase("debug")) continue;
            throw new IOException("Invalid parameter:" + name);
        }
        if (fields != null && this.outputAvroSchema == null) {
            this.outputAvroSchema = AvroStorageUtils.createUDPartialRecordSchema();
            this.outputAvroSchema.setFields(fields);
        }
        if (this.outputAvroSchema != null && !this.nullable) {
            AvroStorageLog.warn("Invalid parameter--nullable cannot be false while output schema is not null. Will ignore nullable.\n\n");
            this.nullable = true;
        }
    }

    public String relToAbsPathForStoreLocation(String location, Path curDir) throws IOException {
        return LoadFunc.getAbsolutePath((String)location, (Path)curDir);
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        AvroStorageLog.details("output location=" + location);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(location));
    }

    public void checkSchema(ResourceSchema s) throws IOException {
        Map<String, String> schemaMap;
        AvroStorageLog.funcCall("Check schema");
        Properties property = this.getUDFProperties();
        String prevSchemaStr = property.getProperty(AVRO_OUTPUT_SCHEMA_PROPERTY);
        AvroStorageLog.details("Previously defined schemas=" + prevSchemaStr);
        String key = this.getSchemaKey();
        Map<String, String> map = schemaMap = prevSchemaStr != null ? this.parseSchemaMap(prevSchemaStr) : null;
        if (schemaMap != null && schemaMap.containsKey(key)) {
            AvroStorageLog.warn("Duplicate value for key-" + key + ". Will ignore the new schema.");
            return;
        }
        Schema schema = this.outputAvroSchema != null ? (this.checkSchema ? PigSchema2Avro.validateAndConvert(this.outputAvroSchema, s) : this.outputAvroSchema) : PigSchema2Avro.convert(s, this.nullable);
        AvroStorageLog.info("key=" + key + " outputSchema=" + schema);
        String schemaStr = schema.toString();
        String append = key + SCHEMA_KEYVALUE_DELIM + schemaStr;
        String newSchemaStr = schemaMap != null ? prevSchemaStr + SCHEMA_DELIM + append : append;
        property.setProperty(AVRO_OUTPUT_SCHEMA_PROPERTY, newSchemaStr);
        AvroStorageLog.details("New schemas=" + newSchemaStr);
    }

    private Properties getUDFProperties() {
        return UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.contextSignature});
    }

    private String getSchemaKey() {
        return Integer.toString(this.storeFuncIndex);
    }

    private Map<String, String> parseSchemaMap(String input) throws IOException {
        AvroStorageLog.details("Parse schema map from " + input);
        String[] entries = input.split(SCHEMA_DELIM);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String entry : entries) {
            AvroStorageLog.details("Entry = " + entry);
            if (entry.length() == 0) continue;
            String[] parts = entry.split(SCHEMA_KEYVALUE_DELIM);
            if (parts.length != 2) {
                throw new IOException("Expect 2 fields in " + entry);
            }
            map.put(parts[0], parts[1]);
        }
        return map;
    }

    public OutputFormat getOutputFormat() throws IOException {
        Schema schema;
        AvroStorageLog.funcCall("getOutputFormat");
        Properties property = this.getUDFProperties();
        String allSchemaStr = property.getProperty(AVRO_OUTPUT_SCHEMA_PROPERTY);
        Map<String, String> map = allSchemaStr != null ? this.parseSchemaMap(allSchemaStr) : null;
        String key = this.getSchemaKey();
        Schema schema2 = schema = map == null || !map.containsKey(key) ? this.outputAvroSchema : Schema.parse((String)map.get(key));
        if (schema == null) {
            throw new IOException("Output schema is null!");
        }
        AvroStorageLog.details("Output schema=" + schema);
        return new PigAvroOutputFormat(schema);
    }

    public void prepareToWrite(RecordWriter writer) throws IOException {
        this.writer = (PigAvroRecordWriter)writer;
    }

    public void setStoreFuncUDFContextSignature(String signature) {
        this.contextSignature = signature;
        super.setUDFContextSignature(signature);
    }

    public void cleanupOnFailure(String location, Job job) throws IOException {
        StoreFunc.cleanupOnFailureImpl((String)location, (Job)job);
    }

    public void cleanupOnSuccess(String location, Job job) throws IOException {
    }

    public void putNext(Tuple t) throws IOException {
        try {
            this.writer.write(NullWritable.get(), t.getAll().size() == 1 ? t.get(0) : t);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public List<String> getShipFiles() {
        ArrayList<Class<JSONParser>> classList = new ArrayList<Class<JSONParser>>();
        classList.add(JSONParser.class);
        return FuncUtils.getShipFiles(classList);
    }

    public Boolean supportsParallelWriteToStoreLocation() {
        return true;
    }
}

