/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.piggybank.storage.hiverc.HiveRCOutputFormat;

public class HiveColumnarStorage
extends PigStorage {
    private static final String UTF8 = "UTF-8";
    private static final char LIST_DELIMITER = '\u0002';
    private static final char MAP_DELIMITER = '\u0003';
    private int numColumns = -1;
    private ByteStream.Output byteStream;
    private BytesRefArrayWritable rowWritable;
    private BytesRefWritable[] colValRefs;

    public OutputFormat getOutputFormat() {
        return new HiveRCOutputFormat();
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        super.setStoreLocation(location, job);
        Properties p = this.getUDFProperties();
        if (p != null) {
            this.numColumns = Integer.parseInt(p.getProperty("numColumns", "-1"));
        }
        if (this.numColumns > 0) {
            RCFileOutputFormat.setColumnNumber((Configuration)job.getConfiguration(), (int)this.numColumns);
        }
    }

    public void checkSchema(ResourceSchema s) throws IOException {
        super.checkSchema(s);
        this.getUDFProperties().setProperty("numColumns", Integer.toString(s.getFields().length));
    }

    public void putNext(Tuple t) throws IOException {
        if (this.rowWritable == null) {
            if (this.numColumns < 1) {
                throw new IOException("number of columns is not set");
            }
            this.byteStream = new ByteStream.Output();
            this.rowWritable = new BytesRefArrayWritable();
            this.colValRefs = new BytesRefWritable[this.numColumns];
            for (int i = 0; i < this.numColumns; ++i) {
                this.colValRefs[i] = new BytesRefWritable();
                this.rowWritable.set(i, this.colValRefs[i]);
            }
        }
        this.byteStream.reset();
        int sz = t.size();
        int startPos = 0;
        for (int i = 0; i < sz && i < this.numColumns; ++i) {
            this.putField((OutputStream)this.byteStream, t.get(i));
            this.colValRefs[i].set(this.byteStream.getData(), startPos, this.byteStream.getLength() - startPos);
            startPos = this.byteStream.getLength();
        }
        try {
            this.writer.write(null, (Object)this.rowWritable);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private Properties getUDFProperties() {
        return UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.signature});
    }

    public void putField(OutputStream out, Object field) throws IOException {
        switch (DataType.findType((Object)field)) {
            case 1: {
                break;
            }
            case 5: {
                out.write(((Boolean)field).toString().getBytes());
                break;
            }
            case 10: {
                out.write(((Integer)field).toString().getBytes());
                break;
            }
            case 15: {
                out.write(((Long)field).toString().getBytes());
                break;
            }
            case 20: {
                out.write(((Float)field).toString().getBytes());
                break;
            }
            case 25: {
                out.write(((Double)field).toString().getBytes());
                break;
            }
            case 50: {
                byte[] b = ((DataByteArray)field).get();
                out.write(b, 0, b.length);
                break;
            }
            case 55: {
                out.write(((String)field).getBytes(UTF8));
                break;
            }
            case 100: {
                boolean mapHasNext = false;
                Map m = (Map)field;
                for (Map.Entry e : m.entrySet()) {
                    if (mapHasNext) {
                        out.write(2);
                    } else {
                        mapHasNext = true;
                    }
                    this.putField(out, e.getKey());
                    out.write(3);
                    this.putField(out, e.getValue());
                }
                break;
            }
            case 127: {
                boolean internalMapHasNext = false;
                Map im = (Map)field;
                for (Map.Entry e : im.entrySet()) {
                    if (internalMapHasNext) {
                        out.write(2);
                    } else {
                        internalMapHasNext = true;
                    }
                    this.putField(out, e.getKey());
                    out.write(3);
                    this.putField(out, e.getValue());
                }
                break;
            }
            case 110: {
                boolean tupleHasNext = false;
                Tuple t = (Tuple)field;
                for (int i = 0; i < t.size(); ++i) {
                    if (tupleHasNext) {
                        out.write(2);
                    } else {
                        tupleHasNext = true;
                    }
                    this.putField(out, t.get(i));
                    continue;
                }
                break;
            }
            case 120: {
                boolean bagHasNext = false;
                Iterator tupleIter = ((DataBag)field).iterator();
                while (tupleIter.hasNext()) {
                    if (bagHasNext) {
                        out.write(2);
                    } else {
                        bagHasNext = true;
                    }
                    this.putField(out, tupleIter.next());
                }
                break;
            }
            default: {
                int errCode = 2108;
                String msg = "Could not determine data type of field: " + field;
                throw new ExecException(msg, errCode, 4);
            }
        }
    }
}

