/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.odata2.api.edm.FullQualifiedName;
import org.apache.olingo.odata2.api.edm.provider.EntitySet;
import org.apache.olingo.odata2.api.edm.provider.EntityType;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAEdmBuilder;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmBaseView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmEntitySetView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmEntityTypeView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmSchemaView;
import org.apache.olingo.odata2.jpa.processor.core.access.model.JPAEdmNameBuilder;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmBaseViewImpl;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmEntityType;

public class JPAEdmEntitySet
extends JPAEdmBaseViewImpl
implements JPAEdmEntitySetView {
    private EntitySet currentEntitySet = null;
    private List<EntitySet> consistentEntitySetList = null;
    private JPAEdmEntityTypeView entityTypeView = null;
    private JPAEdmSchemaView schemaView;

    public JPAEdmEntitySet(JPAEdmSchemaView view) {
        super((JPAEdmBaseView)view);
        this.schemaView = view;
    }

    public JPAEdmBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new JPAEdmEntitySetBuilder();
        }
        return this.builder;
    }

    public EntitySet getEdmEntitySet() {
        return this.currentEntitySet;
    }

    public List<EntitySet> getConsistentEdmEntitySetList() {
        return this.consistentEntitySetList;
    }

    public JPAEdmEntityTypeView getJPAEdmEntityTypeView() {
        return this.entityTypeView;
    }

    @Override
    public void clean() {
        this.currentEntitySet = null;
        this.consistentEntitySetList = null;
        this.entityTypeView = null;
        this.isConsistent = false;
    }

    private class JPAEdmEntitySetBuilder
    implements JPAEdmBuilder {
        private JPAEdmEntitySetBuilder() {
        }

        public void build() throws ODataJPAModelException, ODataJPARuntimeException {
            if (JPAEdmEntitySet.this.consistentEntitySetList == null) {
                JPAEdmEntitySet.this.consistentEntitySetList = new ArrayList<EntitySet>();
            }
            JPAEdmEntitySet.this.entityTypeView = new JPAEdmEntityType(JPAEdmEntitySet.this.schemaView);
            JPAEdmEntitySet.this.entityTypeView.getBuilder().build();
            if (JPAEdmEntitySet.this.entityTypeView.isConsistent() && JPAEdmEntitySet.this.entityTypeView.getConsistentEdmEntityTypes() != null) {
                String nameSpace = JPAEdmEntitySet.this.schemaView.getEdmSchema().getNamespace();
                for (EntityType entityType : JPAEdmEntitySet.this.entityTypeView.getConsistentEdmEntityTypes()) {
                    JPAEdmEntitySet.this.currentEntitySet = new EntitySet();
                    JPAEdmEntitySet.this.currentEntitySet.setEntityType(new FullQualifiedName(nameSpace, entityType.getName()));
                    JPAEdmNameBuilder.build(JPAEdmEntitySet.this, JPAEdmEntitySet.this.entityTypeView);
                    JPAEdmEntitySet.this.consistentEntitySetList.add(JPAEdmEntitySet.this.currentEntitySet);
                }
            } else {
                JPAEdmEntitySet.this.isConsistent = false;
                return;
            }
            JPAEdmEntitySet.this.isConsistent = true;
        }
    }
}

