/****************************************************************************
 * arch/arm/src/imx9/hardware/imx95/imx95_pinmux.h
 *
 * SPDX-License-Identifier: Apache-2.0
 * SPDX-FileCopyrightText: 2024 NXP
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

#define IOMUXC_REGISTER_NOT_AVAILABLE 0x0000

#define IOMUXC_PAD_DAP_TDI_JTAG_MUX_TDI                  IOMUX_PADCFG(IOMUXC_MUX_CTL_DAP_TDI_OFFSET, 0x0, IOMUXC_JTAG_MUX_TDI_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_DAP_TDI_OFFSET)
#define IOMUXC_PAD_DAP_TDI_MQS2_LEFT                     IOMUX_PADCFG(IOMUXC_MUX_CTL_DAP_TDI_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_DAP_TDI_OFFSET)
#define IOMUXC_PAD_DAP_TDI_NETC_TMR_1588_ALARM1          IOMUX_PADCFG(IOMUXC_MUX_CTL_DAP_TDI_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_DAP_TDI_OFFSET)
#define IOMUXC_PAD_DAP_TDI_CAN2_TX                       IOMUX_PADCFG(IOMUXC_MUX_CTL_DAP_TDI_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_DAP_TDI_OFFSET)
#define IOMUXC_PAD_DAP_TDI_FLEXIO2_FLEXIO30              IOMUX_PADCFG(IOMUXC_MUX_CTL_DAP_TDI_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_DAP_TDI_OFFSET)
#define IOMUXC_PAD_DAP_TDI_GPIO3_IO28                    IOMUX_PADCFG(IOMUXC_MUX_CTL_DAP_TDI_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_DAP_TDI_OFFSET)
#define IOMUXC_PAD_DAP_TDI_LPUART5_RX                    IOMUX_PADCFG(IOMUXC_MUX_CTL_DAP_TDI_OFFSET, 0x6, IOMUXC_LPUART5_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_DAP_TDI_OFFSET)
#define IOMUXC_PAD_DAP_TMS_SWDIO_JTAG_MUX_TMS            IOMUX_PADCFG(IOMUXC_MUX_CTL_DAP_TMS_SWDIO_OFFSET, 0x0, IOMUXC_JTAG_MUX_TMS_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_DAP_TMS_SWDIO_OFFSET)
#define IOMUXC_PAD_DAP_TMS_SWDIO_CAN4_TX                 IOMUX_PADCFG(IOMUXC_MUX_CTL_DAP_TMS_SWDIO_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_DAP_TMS_SWDIO_OFFSET)
#define IOMUXC_PAD_DAP_TMS_SWDIO_FLEXIO2_FLEXIO31        IOMUX_PADCFG(IOMUXC_MUX_CTL_DAP_TMS_SWDIO_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_DAP_TMS_SWDIO_OFFSET)
#define IOMUXC_PAD_DAP_TMS_SWDIO_GPIO3_IO29              IOMUX_PADCFG(IOMUXC_MUX_CTL_DAP_TMS_SWDIO_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_DAP_TMS_SWDIO_OFFSET)
#define IOMUXC_PAD_DAP_TMS_SWDIO_LPUART5_RTS_B           IOMUX_PADCFG(IOMUXC_MUX_CTL_DAP_TMS_SWDIO_OFFSET, 0x6, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_DAP_TMS_SWDIO_OFFSET)
#define IOMUXC_PAD_DAP_TCLK_SWCLK_JTAG_MUX_TCK           IOMUX_PADCFG(IOMUXC_MUX_CTL_DAP_TCLK_SWCLK_OFFSET, 0x0, IOMUXC_JTAG_MUX_TCK_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_DAP_TCLK_SWCLK_OFFSET)
#define IOMUXC_PAD_DAP_TCLK_SWCLK_CAN4_RX                IOMUX_PADCFG(IOMUXC_MUX_CTL_DAP_TCLK_SWCLK_OFFSET, 0x2, IOMUXC_CAN4_IPP_IND_CANRX_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_DAP_TCLK_SWCLK_OFFSET)
#define IOMUXC_PAD_DAP_TCLK_SWCLK_FLEXIO1_FLEXIO30       IOMUX_PADCFG(IOMUXC_MUX_CTL_DAP_TCLK_SWCLK_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_30_OFFSET, 0x0, IOMUXC_PAD_CTL_DAP_TCLK_SWCLK_OFFSET)
#define IOMUXC_PAD_DAP_TCLK_SWCLK_GPIO3_IO30             IOMUX_PADCFG(IOMUXC_MUX_CTL_DAP_TCLK_SWCLK_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_DAP_TCLK_SWCLK_OFFSET)
#define IOMUXC_PAD_DAP_TCLK_SWCLK_LPUART5_CTS_B          IOMUX_PADCFG(IOMUXC_MUX_CTL_DAP_TCLK_SWCLK_OFFSET, 0x6, IOMUXC_LPUART5_IPP_IND_LPUART_CTS_N_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_DAP_TCLK_SWCLK_OFFSET)
#define IOMUXC_PAD_DAP_TDO_TRACESWO_JTAG_MUX_TDO         IOMUX_PADCFG(IOMUXC_MUX_CTL_DAP_TDO_TRACESWO_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_DAP_TDO_TRACESWO_OFFSET)
#define IOMUXC_PAD_DAP_TDO_TRACESWO_MQS2_RIGHT           IOMUX_PADCFG(IOMUXC_MUX_CTL_DAP_TDO_TRACESWO_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_DAP_TDO_TRACESWO_OFFSET)
#define IOMUXC_PAD_DAP_TDO_TRACESWO_NETC_TMR_1588_ALARM2 IOMUX_PADCFG(IOMUXC_MUX_CTL_DAP_TDO_TRACESWO_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_DAP_TDO_TRACESWO_OFFSET)
#define IOMUXC_PAD_DAP_TDO_TRACESWO_CAN2_RX              IOMUX_PADCFG(IOMUXC_MUX_CTL_DAP_TDO_TRACESWO_OFFSET, 0x3, IOMUXC_CAN2_IPP_IND_CANRX_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_DAP_TDO_TRACESWO_OFFSET)
#define IOMUXC_PAD_DAP_TDO_TRACESWO_FLEXIO1_FLEXIO31     IOMUX_PADCFG(IOMUXC_MUX_CTL_DAP_TDO_TRACESWO_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_31_OFFSET, 0x0, IOMUXC_PAD_CTL_DAP_TDO_TRACESWO_OFFSET)
#define IOMUXC_PAD_DAP_TDO_TRACESWO_GPIO3_IO31           IOMUX_PADCFG(IOMUXC_MUX_CTL_DAP_TDO_TRACESWO_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_DAP_TDO_TRACESWO_OFFSET)
#define IOMUXC_PAD_DAP_TDO_TRACESWO_LPUART5_TX           IOMUX_PADCFG(IOMUXC_MUX_CTL_DAP_TDO_TRACESWO_OFFSET, 0x6, IOMUXC_LPUART5_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_DAP_TDO_TRACESWO_OFFSET)
#define IOMUXC_PAD_GPIO_IO00_GPIO2_IO00                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO00_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO00_OFFSET)
#define IOMUXC_PAD_GPIO_IO00_LPI2C3_SDA                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO00_OFFSET, 0x1, IOMUXC_LPI2C3_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO00_OFFSET)
#define IOMUXC_PAD_GPIO_IO00_LPSPI6_PCS0                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO00_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO00_OFFSET)
#define IOMUXC_PAD_GPIO_IO00_LPUART5_TX                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO00_OFFSET, 0x5, IOMUXC_LPUART5_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO00_OFFSET)
#define IOMUXC_PAD_GPIO_IO00_LPI2C5_SDA                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO00_OFFSET, 0x6, IOMUXC_LPI2C5_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO00_OFFSET)
#define IOMUXC_PAD_GPIO_IO00_FLEXIO1_FLEXIO00            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO00_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_0_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO00_OFFSET)
#define IOMUXC_PAD_GPIO_IO01_GPIO2_IO01                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO01_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO01_OFFSET)
#define IOMUXC_PAD_GPIO_IO01_LPI2C3_SCL                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO01_OFFSET, 0x1, IOMUXC_LPI2C3_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO01_OFFSET)
#define IOMUXC_PAD_GPIO_IO01_LPSPI6_SIN                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO01_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO01_OFFSET)
#define IOMUXC_PAD_GPIO_IO01_LPUART5_RX                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO01_OFFSET, 0x5, IOMUXC_LPUART5_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO01_OFFSET)
#define IOMUXC_PAD_GPIO_IO01_LPI2C5_SCL                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO01_OFFSET, 0x6, IOMUXC_LPI2C5_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO01_OFFSET)
#define IOMUXC_PAD_GPIO_IO01_FLEXIO1_FLEXIO01            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO01_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_1_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO01_OFFSET)
#define IOMUXC_PAD_GPIO_IO02_GPIO2_IO02                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO02_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO02_OFFSET)
#define IOMUXC_PAD_GPIO_IO02_LPI2C4_SDA                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO02_OFFSET, 0x1, IOMUXC_LPI2C4_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO02_OFFSET)
#define IOMUXC_PAD_GPIO_IO02_LPSPI6_SOUT                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO02_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO02_OFFSET)
#define IOMUXC_PAD_GPIO_IO02_LPUART5_CTS_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO02_OFFSET, 0x5, IOMUXC_LPUART5_IPP_IND_LPUART_CTS_N_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO02_OFFSET)
#define IOMUXC_PAD_GPIO_IO02_LPI2C6_SDA                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO02_OFFSET, 0x6, IOMUXC_LPI2C6_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO02_OFFSET)
#define IOMUXC_PAD_GPIO_IO02_FLEXIO1_FLEXIO02            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO02_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_2_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO02_OFFSET)
#define IOMUXC_PAD_GPIO_IO03_GPIO2_IO03                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO03_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO03_OFFSET)
#define IOMUXC_PAD_GPIO_IO03_LPI2C4_SCL                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO03_OFFSET, 0x1, IOMUXC_LPI2C4_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO03_OFFSET)
#define IOMUXC_PAD_GPIO_IO03_LPSPI6_SCK                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO03_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO03_OFFSET)
#define IOMUXC_PAD_GPIO_IO03_LPUART5_RTS_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO03_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO03_OFFSET)
#define IOMUXC_PAD_GPIO_IO03_LPI2C6_SCL                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO03_OFFSET, 0x6, IOMUXC_LPI2C6_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO03_OFFSET)
#define IOMUXC_PAD_GPIO_IO03_FLEXIO1_FLEXIO03            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO03_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_3_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO03_OFFSET)
#define IOMUXC_PAD_GPIO_IO04_GPIO2_IO04                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO04_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO04_OFFSET)
#define IOMUXC_PAD_GPIO_IO04_TPM3_CH0                    IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO04_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO04_OFFSET)
#define IOMUXC_PAD_GPIO_IO04_PDM_CLK                     IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO04_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO04_OFFSET)
#define IOMUXC_PAD_GPIO_IO04_CAN4_TX                     IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO04_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO04_OFFSET)
#define IOMUXC_PAD_GPIO_IO04_LPSPI7_PCS0                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO04_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO04_OFFSET)
#define IOMUXC_PAD_GPIO_IO04_LPUART6_TX                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO04_OFFSET, 0x5, IOMUXC_LPUART6_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO04_OFFSET)
#define IOMUXC_PAD_GPIO_IO04_LPI2C6_SDA                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO04_OFFSET, 0x6, IOMUXC_LPI2C6_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO04_OFFSET)
#define IOMUXC_PAD_GPIO_IO04_FLEXIO1_FLEXIO04            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO04_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_4_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO04_OFFSET)
#define IOMUXC_PAD_GPIO_IO05_GPIO2_IO05                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO05_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO05_OFFSET)
#define IOMUXC_PAD_GPIO_IO05_TPM4_CH0                    IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO05_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO05_OFFSET)
#define IOMUXC_PAD_GPIO_IO05_PDM_BIT_STREAM00            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO05_OFFSET, 0x2, IOMUXC_PDM_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_0_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO05_OFFSET)
#define IOMUXC_PAD_GPIO_IO05_CAN4_RX                     IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO05_OFFSET, 0x3, IOMUXC_CAN4_IPP_IND_CANRX_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO05_OFFSET)
#define IOMUXC_PAD_GPIO_IO05_LPSPI7_SIN                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO05_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO05_OFFSET)
#define IOMUXC_PAD_GPIO_IO05_LPUART6_RX                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO05_OFFSET, 0x5, IOMUXC_LPUART6_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO05_OFFSET)
#define IOMUXC_PAD_GPIO_IO05_LPI2C6_SCL                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO05_OFFSET, 0x6, IOMUXC_LPI2C6_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO05_OFFSET)
#define IOMUXC_PAD_GPIO_IO05_FLEXIO1_FLEXIO05            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO05_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_5_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO05_OFFSET)
#define IOMUXC_PAD_GPIO_IO06_GPIO2_IO06                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO06_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO06_OFFSET)
#define IOMUXC_PAD_GPIO_IO06_TPM5_CH0                    IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO06_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO06_OFFSET)
#define IOMUXC_PAD_GPIO_IO06_PDM_BIT_STREAM01            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO06_OFFSET, 0x2, IOMUXC_PDM_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_1_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO06_OFFSET)
#define IOMUXC_PAD_GPIO_IO06_LPSPI7_SOUT                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO06_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO06_OFFSET)
#define IOMUXC_PAD_GPIO_IO06_LPUART6_CTS_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO06_OFFSET, 0x5, IOMUXC_LPUART6_IPP_IND_LPUART_CTS_N_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO06_OFFSET)
#define IOMUXC_PAD_GPIO_IO06_LPI2C7_SDA                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO06_OFFSET, 0x6, IOMUXC_LPI2C7_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO06_OFFSET)
#define IOMUXC_PAD_GPIO_IO06_FLEXIO1_FLEXIO06            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO06_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_6_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO06_OFFSET)
#define IOMUXC_PAD_GPIO_IO07_GPIO2_IO07                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO07_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO07_OFFSET)
#define IOMUXC_PAD_GPIO_IO07_LPSPI3_PCS1                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO07_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO07_OFFSET)
#define IOMUXC_PAD_GPIO_IO07_LPSPI7_SCK                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO07_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO07_OFFSET)
#define IOMUXC_PAD_GPIO_IO07_LPUART6_RTS_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO07_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO07_OFFSET)
#define IOMUXC_PAD_GPIO_IO07_LPI2C7_SCL                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO07_OFFSET, 0x6, IOMUXC_LPI2C7_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO07_OFFSET)
#define IOMUXC_PAD_GPIO_IO07_FLEXIO1_FLEXIO07            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO07_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_7_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO07_OFFSET)
#define IOMUXC_PAD_GPIO_IO08_GPIO2_IO08                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO08_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO08_OFFSET)
#define IOMUXC_PAD_GPIO_IO08_LPSPI3_PCS0                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO08_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO08_OFFSET)
#define IOMUXC_PAD_GPIO_IO08_TPM6_CH0                    IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO08_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO08_OFFSET)
#define IOMUXC_PAD_GPIO_IO08_LPUART7_TX                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO08_OFFSET, 0x5, IOMUXC_LPUART7_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO08_OFFSET)
#define IOMUXC_PAD_GPIO_IO08_LPI2C7_SDA                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO08_OFFSET, 0x6, IOMUXC_LPI2C7_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO08_OFFSET)
#define IOMUXC_PAD_GPIO_IO08_FLEXIO1_FLEXIO08            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO08_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_8_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO08_OFFSET)
#define IOMUXC_PAD_GPIO_IO09_GPIO2_IO09                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO09_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO09_OFFSET)
#define IOMUXC_PAD_GPIO_IO09_LPSPI3_SIN                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO09_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO09_OFFSET)
#define IOMUXC_PAD_GPIO_IO09_TPM3_EXTCLK                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO09_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO09_OFFSET)
#define IOMUXC_PAD_GPIO_IO09_LPUART7_RX                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO09_OFFSET, 0x5, IOMUXC_LPUART7_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO09_OFFSET)
#define IOMUXC_PAD_GPIO_IO09_LPI2C7_SCL                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO09_OFFSET, 0x6, IOMUXC_LPI2C7_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO09_OFFSET)
#define IOMUXC_PAD_GPIO_IO09_FLEXIO1_FLEXIO09            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO09_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_9_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO09_OFFSET)
#define IOMUXC_PAD_GPIO_IO10_GPIO2_IO10                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO10_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO10_OFFSET)
#define IOMUXC_PAD_GPIO_IO10_LPSPI3_SOUT                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO10_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO10_OFFSET)
#define IOMUXC_PAD_GPIO_IO10_TPM4_EXTCLK                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO10_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO10_OFFSET)
#define IOMUXC_PAD_GPIO_IO10_LPUART7_CTS_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO10_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO10_OFFSET)
#define IOMUXC_PAD_GPIO_IO10_LPI2C8_SDA                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO10_OFFSET, 0x6, IOMUXC_LPI2C8_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO10_OFFSET)
#define IOMUXC_PAD_GPIO_IO10_FLEXIO1_FLEXIO10            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO10_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_10_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO10_OFFSET)
#define IOMUXC_PAD_GPIO_IO11_GPIO2_IO11                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO11_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO11_OFFSET)
#define IOMUXC_PAD_GPIO_IO11_LPSPI3_SCK                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO11_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO11_OFFSET)
#define IOMUXC_PAD_GPIO_IO11_TPM5_EXTCLK                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO11_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO11_OFFSET)
#define IOMUXC_PAD_GPIO_IO11_LPUART7_RTS_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO11_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO11_OFFSET)
#define IOMUXC_PAD_GPIO_IO11_LPI2C8_SCL                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO11_OFFSET, 0x6, IOMUXC_LPI2C8_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO11_OFFSET)
#define IOMUXC_PAD_GPIO_IO11_FLEXIO1_FLEXIO11            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO11_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_11_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO11_OFFSET)
#define IOMUXC_PAD_GPIO_IO12_GPIO2_IO12                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO12_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO12_OFFSET)
#define IOMUXC_PAD_GPIO_IO12_TPM3_CH2                    IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO12_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO12_OFFSET)
#define IOMUXC_PAD_GPIO_IO12_PDM_BIT_STREAM02            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO12_OFFSET, 0x2, IOMUXC_PDM_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_2_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO12_OFFSET)
#define IOMUXC_PAD_GPIO_IO12_FLEXIO1_FLEXIO12            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO12_OFFSET, 0x3, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_12_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO12_OFFSET)
#define IOMUXC_PAD_GPIO_IO12_LPSPI8_PCS0                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO12_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO12_OFFSET)
#define IOMUXC_PAD_GPIO_IO12_LPUART8_TX                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO12_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO12_OFFSET)
#define IOMUXC_PAD_GPIO_IO12_LPI2C8_SDA                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO12_OFFSET, 0x6, IOMUXC_LPI2C8_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO12_OFFSET)
#define IOMUXC_PAD_GPIO_IO12_SAI3_RX_SYNC                IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO12_OFFSET, 0x7, IOMUXC_SAI3_IPP_IND_SAI_RXSYNC_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO12_OFFSET)
#define IOMUXC_PAD_GPIO_IO13_GPIO2_IO13                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO13_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO13_OFFSET)
#define IOMUXC_PAD_GPIO_IO13_TPM4_CH2                    IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO13_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO13_OFFSET)
#define IOMUXC_PAD_GPIO_IO13_PDM_BIT_STREAM03            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO13_OFFSET, 0x2, IOMUXC_PDM_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_3_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO13_OFFSET)
#define IOMUXC_PAD_GPIO_IO13_LPSPI8_SIN                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO13_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO13_OFFSET)
#define IOMUXC_PAD_GPIO_IO13_LPUART8_RX                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO13_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO13_OFFSET)
#define IOMUXC_PAD_GPIO_IO13_LPI2C8_SCL                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO13_OFFSET, 0x6, IOMUXC_LPI2C8_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO13_OFFSET)
#define IOMUXC_PAD_GPIO_IO13_FLEXIO1_FLEXIO13            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO13_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_13_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO13_OFFSET)
#define IOMUXC_PAD_GPIO_IO14_GPIO2_IO14                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO14_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO14_OFFSET)
#define IOMUXC_PAD_GPIO_IO14_LPUART3_TX                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO14_OFFSET, 0x1, IOMUXC_LPUART3_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO14_OFFSET)
#define IOMUXC_PAD_GPIO_IO14_LPSPI8_SOUT                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO14_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO14_OFFSET)
#define IOMUXC_PAD_GPIO_IO14_LPUART8_CTS_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO14_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO14_OFFSET)
#define IOMUXC_PAD_GPIO_IO14_LPUART4_TX                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO14_OFFSET, 0x6, IOMUXC_LPUART4_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO14_OFFSET)
#define IOMUXC_PAD_GPIO_IO14_FLEXIO1_FLEXIO14            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO14_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_14_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO14_OFFSET)
#define IOMUXC_PAD_GPIO_IO15_GPIO2_IO15                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO15_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO15_OFFSET)
#define IOMUXC_PAD_GPIO_IO15_LPUART3_RX                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO15_OFFSET, 0x1, IOMUXC_LPUART3_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO15_OFFSET)
#define IOMUXC_PAD_GPIO_IO15_LPSPI8_SCK                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO15_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO15_OFFSET)
#define IOMUXC_PAD_GPIO_IO15_LPUART8_RTS_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO15_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO15_OFFSET)
#define IOMUXC_PAD_GPIO_IO15_LPUART4_RX                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO15_OFFSET, 0x6, IOMUXC_LPUART4_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO15_OFFSET)
#define IOMUXC_PAD_GPIO_IO15_FLEXIO1_FLEXIO15            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO15_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_15_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO15_OFFSET)
#define IOMUXC_PAD_GPIO_IO16_GPIO2_IO16                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO16_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO16_OFFSET)
#define IOMUXC_PAD_GPIO_IO16_SAI3_TX_BCLK                IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO16_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO16_OFFSET)
#define IOMUXC_PAD_GPIO_IO16_PDM_BIT_STREAM02            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO16_OFFSET, 0x2, IOMUXC_PDM_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_2_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO16_OFFSET)
#define IOMUXC_PAD_GPIO_IO16_LPUART3_CTS_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO16_OFFSET, 0x4, IOMUXC_LPUART3_IPP_IND_LPUART_CTS_N_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO16_OFFSET)
#define IOMUXC_PAD_GPIO_IO16_LPSPI4_PCS2                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO16_OFFSET, 0x5, IOMUXC_LPSPI4_IPP_IND_LPSPI_PCS_SELECT_INPUT_2_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO16_OFFSET)
#define IOMUXC_PAD_GPIO_IO16_LPUART4_CTS_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO16_OFFSET, 0x6, IOMUXC_LPUART4_IPP_IND_LPUART_CTS_N_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO16_OFFSET)
#define IOMUXC_PAD_GPIO_IO16_FLEXIO1_FLEXIO16            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO16_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_16_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO16_OFFSET)
#define IOMUXC_PAD_GPIO_IO17_GPIO2_IO17                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO17_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO17_OFFSET)
#define IOMUXC_PAD_GPIO_IO17_SAI3_MCLK                   IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO17_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO17_OFFSET)
#define IOMUXC_PAD_GPIO_IO17_LPUART3_RTS_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO17_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO17_OFFSET)
#define IOMUXC_PAD_GPIO_IO17_LPSPI4_PCS1                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO17_OFFSET, 0x5, IOMUXC_LPSPI4_IPP_IND_LPSPI_PCS_SELECT_INPUT_1_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO17_OFFSET)
#define IOMUXC_PAD_GPIO_IO17_LPUART4_RTS_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO17_OFFSET, 0x6, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO17_OFFSET)
#define IOMUXC_PAD_GPIO_IO17_FLEXIO1_FLEXIO17            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO17_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_17_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO17_OFFSET)
#define IOMUXC_PAD_GPIO_IO18_GPIO2_IO18                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO18_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO18_OFFSET)
#define IOMUXC_PAD_GPIO_IO18_SAI3_RX_BCLK                IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO18_OFFSET, 0x1, IOMUXC_SAI3_IPP_IND_SAI_RXBCLK_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO18_OFFSET)
#define IOMUXC_PAD_GPIO_IO18_LPSPI5_PCS0                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO18_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO18_OFFSET)
#define IOMUXC_PAD_GPIO_IO18_LPSPI4_PCS0                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO18_OFFSET, 0x5, IOMUXC_LPSPI4_IPP_IND_LPSPI_PCS_SELECT_INPUT_0_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO18_OFFSET)
#define IOMUXC_PAD_GPIO_IO18_TPM5_CH2                    IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO18_OFFSET, 0x6, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO18_OFFSET)
#define IOMUXC_PAD_GPIO_IO18_FLEXIO1_FLEXIO18            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO18_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_18_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO18_OFFSET)
#define IOMUXC_PAD_GPIO_IO19_GPIO2_IO19                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO19_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO19_OFFSET)
#define IOMUXC_PAD_GPIO_IO19_SAI3_RX_SYNC                IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO19_OFFSET, 0x1, IOMUXC_SAI3_IPP_IND_SAI_RXSYNC_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO19_OFFSET)
#define IOMUXC_PAD_GPIO_IO19_PDM_BIT_STREAM03            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO19_OFFSET, 0x2, IOMUXC_PDM_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_3_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO19_OFFSET)
#define IOMUXC_PAD_GPIO_IO19_FLEXIO1_FLEXIO19            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO19_OFFSET, 0x3, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_19_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO19_OFFSET)
#define IOMUXC_PAD_GPIO_IO19_LPSPI5_SIN                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO19_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO19_OFFSET)
#define IOMUXC_PAD_GPIO_IO19_LPSPI4_SIN                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO19_OFFSET, 0x5, IOMUXC_LPSPI4_IPP_IND_LPSPI_SDI_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO19_OFFSET)
#define IOMUXC_PAD_GPIO_IO19_TPM6_CH2                    IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO19_OFFSET, 0x6, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO19_OFFSET)
#define IOMUXC_PAD_GPIO_IO19_SAI3_TX_DATA00              IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO19_OFFSET, 0x7, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO19_OFFSET)
#define IOMUXC_PAD_GPIO_IO20_GPIO2_IO20                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO20_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO20_OFFSET)
#define IOMUXC_PAD_GPIO_IO20_SAI3_RX_DATA00              IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO20_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO20_OFFSET)
#define IOMUXC_PAD_GPIO_IO20_PDM_BIT_STREAM00            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO20_OFFSET, 0x2, IOMUXC_PDM_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_0_OFFSET, 0x2, IOMUXC_PAD_CTL_GPIO_IO20_OFFSET)
#define IOMUXC_PAD_GPIO_IO20_LPSPI5_SOUT                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO20_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO20_OFFSET)
#define IOMUXC_PAD_GPIO_IO20_LPSPI4_SOUT                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO20_OFFSET, 0x5, IOMUXC_LPSPI4_IPP_IND_LPSPI_SDO_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO20_OFFSET)
#define IOMUXC_PAD_GPIO_IO20_TPM3_CH1                    IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO20_OFFSET, 0x6, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO20_OFFSET)
#define IOMUXC_PAD_GPIO_IO20_FLEXIO1_FLEXIO20            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO20_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_20_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO20_OFFSET)
#define IOMUXC_PAD_GPIO_IO21_GPIO2_IO21                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO21_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO21_OFFSET)
#define IOMUXC_PAD_GPIO_IO21_SAI3_TX_DATA00              IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO21_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO21_OFFSET)
#define IOMUXC_PAD_GPIO_IO21_PDM_CLK                     IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO21_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO21_OFFSET)
#define IOMUXC_PAD_GPIO_IO21_FLEXIO1_FLEXIO21            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO21_OFFSET, 0x3, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_21_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO21_OFFSET)
#define IOMUXC_PAD_GPIO_IO21_LPSPI5_SCK                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO21_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO21_OFFSET)
#define IOMUXC_PAD_GPIO_IO21_LPSPI4_SCK                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO21_OFFSET, 0x5, IOMUXC_LPSPI4_IPP_IND_LPSPI_SCK_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO21_OFFSET)
#define IOMUXC_PAD_GPIO_IO21_TPM4_CH1                    IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO21_OFFSET, 0x6, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO21_OFFSET)
#define IOMUXC_PAD_GPIO_IO21_SAI3_RX_BCLK                IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO21_OFFSET, 0x7, IOMUXC_SAI3_IPP_IND_SAI_RXBCLK_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO21_OFFSET)
#define IOMUXC_PAD_GPIO_IO22_GPIO2_IO22                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO22_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO22_OFFSET)
#define IOMUXC_PAD_GPIO_IO22_USDHC3_CLK                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO22_OFFSET, 0x1, IOMUXC_USDHC3_IPP_CARD_CLK_IN_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO22_OFFSET)
#define IOMUXC_PAD_GPIO_IO22_SPDIF_IN                    IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO22_OFFSET, 0x2, IOMUXC_EARC_PHY_SPDIF_IN_SELECT_INPUT_OFFSET, 0x2, IOMUXC_PAD_CTL_GPIO_IO22_OFFSET)
#define IOMUXC_PAD_GPIO_IO22_CAN5_TX                     IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO22_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO22_OFFSET)
#define IOMUXC_PAD_GPIO_IO22_TPM5_CH1                    IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO22_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO22_OFFSET)
#define IOMUXC_PAD_GPIO_IO22_TPM6_EXTCLK                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO22_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO22_OFFSET)
#define IOMUXC_PAD_GPIO_IO22_LPI2C5_SDA                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO22_OFFSET, 0x6, IOMUXC_LPI2C5_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO22_OFFSET)
#define IOMUXC_PAD_GPIO_IO22_FLEXIO1_FLEXIO22            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO22_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_22_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO22_OFFSET)
#define IOMUXC_PAD_GPIO_IO23_GPIO2_IO23                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO23_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO23_OFFSET)
#define IOMUXC_PAD_GPIO_IO23_USDHC3_CMD                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO23_OFFSET, 0x1, IOMUXC_USDHC3_IPP_CMD_IN_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO23_OFFSET)
#define IOMUXC_PAD_GPIO_IO23_SPDIF_OUT                   IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO23_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO23_OFFSET)
#define IOMUXC_PAD_GPIO_IO23_CAN5_RX                     IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO23_OFFSET, 0x3, IOMUXC_CAN5_IPP_IND_CANRX_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO23_OFFSET)
#define IOMUXC_PAD_GPIO_IO23_TPM6_CH1                    IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO23_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO23_OFFSET)
#define IOMUXC_PAD_GPIO_IO23_LPI2C5_SCL                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO23_OFFSET, 0x6, IOMUXC_LPI2C5_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO23_OFFSET)
#define IOMUXC_PAD_GPIO_IO23_FLEXIO1_FLEXIO23            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO23_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_23_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO23_OFFSET)
#define IOMUXC_PAD_GPIO_IO24_GPIO2_IO24                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO24_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO24_OFFSET)
#define IOMUXC_PAD_GPIO_IO24_USDHC3_DATA0                IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO24_OFFSET, 0x1, IOMUXC_USDHC3_IPP_DAT0_IN_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO24_OFFSET)
#define IOMUXC_PAD_GPIO_IO24_TPM3_CH3                    IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO24_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO24_OFFSET)
#define IOMUXC_PAD_GPIO_IO24_JTAG_MUX_TDO                IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO24_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO24_OFFSET)
#define IOMUXC_PAD_GPIO_IO24_LPSPI6_PCS1                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO24_OFFSET, 0x6, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO24_OFFSET)
#define IOMUXC_PAD_GPIO_IO24_FLEXIO1_FLEXIO24            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO24_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_24_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO24_OFFSET)
#define IOMUXC_PAD_GPIO_IO25_GPIO2_IO25                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO25_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO25_OFFSET)
#define IOMUXC_PAD_GPIO_IO25_USDHC3_DATA1                IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO25_OFFSET, 0x1, IOMUXC_USDHC3_IPP_DAT1_IN_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO25_OFFSET)
#define IOMUXC_PAD_GPIO_IO25_CAN2_TX                     IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO25_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO25_OFFSET)
#define IOMUXC_PAD_GPIO_IO25_TPM4_CH3                    IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO25_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO25_OFFSET)
#define IOMUXC_PAD_GPIO_IO25_JTAG_MUX_TCK                IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO25_OFFSET, 0x5, IOMUXC_JTAG_MUX_TCK_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO25_OFFSET)
#define IOMUXC_PAD_GPIO_IO25_LPSPI7_PCS1                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO25_OFFSET, 0x6, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO25_OFFSET)
#define IOMUXC_PAD_GPIO_IO25_FLEXIO1_FLEXIO25            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO25_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_25_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO25_OFFSET)
#define IOMUXC_PAD_GPIO_IO26_GPIO2_IO26                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO26_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO26_OFFSET)
#define IOMUXC_PAD_GPIO_IO26_USDHC3_DATA2                IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO26_OFFSET, 0x1, IOMUXC_USDHC3_IPP_DAT2_IN_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO26_OFFSET)
#define IOMUXC_PAD_GPIO_IO26_PDM_BIT_STREAM01            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO26_OFFSET, 0x2, IOMUXC_PDM_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_1_OFFSET, 0x2, IOMUXC_PAD_CTL_GPIO_IO26_OFFSET)
#define IOMUXC_PAD_GPIO_IO26_FLEXIO1_FLEXIO26            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO26_OFFSET, 0x3, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_26_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO26_OFFSET)
#define IOMUXC_PAD_GPIO_IO26_TPM5_CH3                    IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO26_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO26_OFFSET)
#define IOMUXC_PAD_GPIO_IO26_JTAG_MUX_TDI                IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO26_OFFSET, 0x5, IOMUXC_JTAG_MUX_TDI_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO26_OFFSET)
#define IOMUXC_PAD_GPIO_IO26_LPSPI8_PCS1                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO26_OFFSET, 0x6, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO26_OFFSET)
#define IOMUXC_PAD_GPIO_IO26_SAI3_TX_SYNC                IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO26_OFFSET, 0x7, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO26_OFFSET)
#define IOMUXC_PAD_GPIO_IO27_GPIO2_IO27                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO27_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO27_OFFSET)
#define IOMUXC_PAD_GPIO_IO27_USDHC3_DATA3                IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO27_OFFSET, 0x1, IOMUXC_USDHC3_IPP_DAT3_IN_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO27_OFFSET)
#define IOMUXC_PAD_GPIO_IO27_CAN2_RX                     IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO27_OFFSET, 0x2, IOMUXC_CAN2_IPP_IND_CANRX_SELECT_INPUT_OFFSET, 0x2, IOMUXC_PAD_CTL_GPIO_IO27_OFFSET)
#define IOMUXC_PAD_GPIO_IO27_TPM6_CH3                    IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO27_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO27_OFFSET)
#define IOMUXC_PAD_GPIO_IO27_JTAG_MUX_TMS                IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO27_OFFSET, 0x5, IOMUXC_JTAG_MUX_TMS_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO27_OFFSET)
#define IOMUXC_PAD_GPIO_IO27_LPSPI5_PCS1                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO27_OFFSET, 0x6, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO27_OFFSET)
#define IOMUXC_PAD_GPIO_IO27_FLEXIO1_FLEXIO27            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO27_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_27_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO27_OFFSET)
#define IOMUXC_PAD_GPIO_IO28_GPIO2_IO28                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO28_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO28_OFFSET)
#define IOMUXC_PAD_GPIO_IO28_LPI2C3_SDA                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO28_OFFSET, 0x1, IOMUXC_LPI2C3_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO28_OFFSET)
#define IOMUXC_PAD_GPIO_IO28_CAN3_TX                     IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO28_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO28_OFFSET)
#define IOMUXC_PAD_GPIO_IO28_FLEXIO1_FLEXIO28            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO28_OFFSET, 0x7, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO28_OFFSET)
#define IOMUXC_PAD_GPIO_IO29_GPIO2_IO29                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO29_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO29_OFFSET)
#define IOMUXC_PAD_GPIO_IO29_LPI2C3_SCL                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO29_OFFSET, 0x1, IOMUXC_LPI2C3_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO29_OFFSET)
#define IOMUXC_PAD_GPIO_IO29_CAN3_RX                     IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO29_OFFSET, 0x2, IOMUXC_CAN3_IPP_IND_CANRX_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO29_OFFSET)
#define IOMUXC_PAD_GPIO_IO29_FLEXIO1_FLEXIO29            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO29_OFFSET, 0x7, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO29_OFFSET)
#define IOMUXC_PAD_GPIO_IO30_GPIO2_IO30                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO30_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO30_OFFSET)
#define IOMUXC_PAD_GPIO_IO30_LPI2C4_SDA                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO30_OFFSET, 0x1, IOMUXC_LPI2C4_IPP_IND_LPI2C_SDA_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO30_OFFSET)
#define IOMUXC_PAD_GPIO_IO30_CAN5_TX                     IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO30_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO30_OFFSET)
#define IOMUXC_PAD_GPIO_IO30_FLEXIO1_FLEXIO30            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO30_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_30_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO30_OFFSET)
#define IOMUXC_PAD_GPIO_IO31_GPIO2_IO31                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO31_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO31_OFFSET)
#define IOMUXC_PAD_GPIO_IO31_LPI2C4_SCL                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO31_OFFSET, 0x1, IOMUXC_LPI2C4_IPP_IND_LPI2C_SCL_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO31_OFFSET)
#define IOMUXC_PAD_GPIO_IO31_CAN5_RX                     IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO31_OFFSET, 0x2, IOMUXC_CAN5_IPP_IND_CANRX_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO31_OFFSET)
#define IOMUXC_PAD_GPIO_IO31_FLEXIO1_FLEXIO31            IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO31_OFFSET, 0x7, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_31_OFFSET, 0x1, IOMUXC_PAD_CTL_GPIO_IO31_OFFSET)
#define IOMUXC_PAD_GPIO_IO32_GPIO5_IO12                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO32_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO32_OFFSET)
#define IOMUXC_PAD_GPIO_IO32_PCIE1_CLKREQ_B              IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO32_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO32_OFFSET)
#define IOMUXC_PAD_GPIO_IO32_LPUART6_TX                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO32_OFFSET, 0x2, IOMUXC_LPUART6_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO32_OFFSET)
#define IOMUXC_PAD_GPIO_IO32_LPSPI4_PCS2                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO32_OFFSET, 0x4, IOMUXC_LPSPI4_IPP_IND_LPSPI_PCS_SELECT_INPUT_2_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO32_OFFSET)
#define IOMUXC_PAD_GPIO_IO33_GPIO5_IO13                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO33_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO33_OFFSET)
#define IOMUXC_PAD_GPIO_IO33_LPUART6_RX                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO33_OFFSET, 0x2, IOMUXC_LPUART6_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO33_OFFSET)
#define IOMUXC_PAD_GPIO_IO33_LPSPI4_PCS1                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO33_OFFSET, 0x4, IOMUXC_LPSPI4_IPP_IND_LPSPI_PCS_SELECT_INPUT_1_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO33_OFFSET)
#define IOMUXC_PAD_GPIO_IO34_GPIO5_IO14                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO34_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO34_OFFSET)
#define IOMUXC_PAD_GPIO_IO34_LPUART6_CTS_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO34_OFFSET, 0x2, IOMUXC_LPUART6_IPP_IND_LPUART_CTS_N_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO34_OFFSET)
#define IOMUXC_PAD_GPIO_IO34_LPSPI4_PCS0                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO34_OFFSET, 0x4, IOMUXC_LPSPI4_IPP_IND_LPSPI_PCS_SELECT_INPUT_0_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO34_OFFSET)
#define IOMUXC_PAD_GPIO_IO35_GPIO5_IO15                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO35_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO35_OFFSET)
#define IOMUXC_PAD_GPIO_IO35_PCIE2_CLKREQ_B              IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO35_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO35_OFFSET)
#define IOMUXC_PAD_GPIO_IO35_LPUART6_RTS_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO35_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO35_OFFSET)
#define IOMUXC_PAD_GPIO_IO35_LPSPI4_SIN                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO35_OFFSET, 0x4, IOMUXC_LPSPI4_IPP_IND_LPSPI_SDI_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO35_OFFSET)
#define IOMUXC_PAD_GPIO_IO36_GPIO5_IO16                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO36_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO36_OFFSET)
#define IOMUXC_PAD_GPIO_IO36_LPUART7_TX                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO36_OFFSET, 0x2, IOMUXC_LPUART7_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO36_OFFSET)
#define IOMUXC_PAD_GPIO_IO36_LPSPI4_SOUT                 IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO36_OFFSET, 0x4, IOMUXC_LPSPI4_IPP_IND_LPSPI_SDO_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO36_OFFSET)
#define IOMUXC_PAD_GPIO_IO37_GPIO5_IO17                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO37_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_GPIO_IO37_OFFSET)
#define IOMUXC_PAD_GPIO_IO37_LPUART7_RX                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO37_OFFSET, 0x2, IOMUXC_LPUART7_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO37_OFFSET)
#define IOMUXC_PAD_GPIO_IO37_LPSPI4_SCK                  IOMUX_PADCFG(IOMUXC_MUX_CTL_GPIO_IO37_OFFSET, 0x4, IOMUXC_LPSPI4_IPP_IND_LPSPI_SCK_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_GPIO_IO37_OFFSET)
#define IOMUXC_PAD_CCM_CLKO1_CLKO_1                      IOMUX_PADCFG(IOMUXC_MUX_CTL_CCM_CLKO1_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_CCM_CLKO1_OFFSET)
#define IOMUXC_PAD_CCM_CLKO1_NETC_TMR_1588_TRIG1         IOMUX_PADCFG(IOMUXC_MUX_CTL_CCM_CLKO1_OFFSET, 0x1, IOMUXC_NETC_CMPLX_TMR_1588_TRIG1_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_CCM_CLKO1_OFFSET)
#define IOMUXC_PAD_CCM_CLKO1_FLEXIO1_FLEXIO26            IOMUX_PADCFG(IOMUXC_MUX_CTL_CCM_CLKO1_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_26_OFFSET, 0x0, IOMUXC_PAD_CTL_CCM_CLKO1_OFFSET)
#define IOMUXC_PAD_CCM_CLKO1_GPIO3_IO26                  IOMUX_PADCFG(IOMUXC_MUX_CTL_CCM_CLKO1_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_CCM_CLKO1_OFFSET)
#define IOMUXC_PAD_CCM_CLKO2_CLKO_2                      IOMUX_PADCFG(IOMUXC_MUX_CTL_CCM_CLKO2_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_CCM_CLKO2_OFFSET)
#define IOMUXC_PAD_CCM_CLKO2_NETC_TMR_1588_PP1           IOMUX_PADCFG(IOMUXC_MUX_CTL_CCM_CLKO2_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_CCM_CLKO2_OFFSET)
#define IOMUXC_PAD_CCM_CLKO2_FLEXIO1_FLEXIO27            IOMUX_PADCFG(IOMUXC_MUX_CTL_CCM_CLKO2_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_27_OFFSET, 0x0, IOMUXC_PAD_CTL_CCM_CLKO2_OFFSET)
#define IOMUXC_PAD_CCM_CLKO2_GPIO3_IO27                  IOMUX_PADCFG(IOMUXC_MUX_CTL_CCM_CLKO2_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_CCM_CLKO2_OFFSET)
#define IOMUXC_PAD_CCM_CLKO3_CLKO_3                      IOMUX_PADCFG(IOMUXC_MUX_CTL_CCM_CLKO3_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_CCM_CLKO3_OFFSET)
#define IOMUXC_PAD_CCM_CLKO3_NETC_TMR_1588_TRIG2         IOMUX_PADCFG(IOMUXC_MUX_CTL_CCM_CLKO3_OFFSET, 0x1, IOMUXC_NETC_CMPLX_TMR_1588_TRIG2_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_CCM_CLKO3_OFFSET)
#define IOMUXC_PAD_CCM_CLKO3_CAN3_TX                     IOMUX_PADCFG(IOMUXC_MUX_CTL_CCM_CLKO3_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_CCM_CLKO3_OFFSET)
#define IOMUXC_PAD_CCM_CLKO3_FLEXIO2_FLEXIO28            IOMUX_PADCFG(IOMUXC_MUX_CTL_CCM_CLKO3_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_CCM_CLKO3_OFFSET)
#define IOMUXC_PAD_CCM_CLKO3_GPIO4_IO28                  IOMUX_PADCFG(IOMUXC_MUX_CTL_CCM_CLKO3_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_CCM_CLKO3_OFFSET)
#define IOMUXC_PAD_CCM_CLKO4_CLKO_4                      IOMUX_PADCFG(IOMUXC_MUX_CTL_CCM_CLKO4_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_CCM_CLKO4_OFFSET)
#define IOMUXC_PAD_CCM_CLKO4_NETC_TMR_1588_PP2           IOMUX_PADCFG(IOMUXC_MUX_CTL_CCM_CLKO4_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_CCM_CLKO4_OFFSET)
#define IOMUXC_PAD_CCM_CLKO4_CAN3_RX                     IOMUX_PADCFG(IOMUXC_MUX_CTL_CCM_CLKO4_OFFSET, 0x2, IOMUXC_CAN3_IPP_IND_CANRX_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_CCM_CLKO4_OFFSET)
#define IOMUXC_PAD_CCM_CLKO4_FLEXIO2_FLEXIO29            IOMUX_PADCFG(IOMUXC_MUX_CTL_CCM_CLKO4_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_CCM_CLKO4_OFFSET)
#define IOMUXC_PAD_CCM_CLKO4_GPIO4_IO29                  IOMUX_PADCFG(IOMUXC_MUX_CTL_CCM_CLKO4_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_CCM_CLKO4_OFFSET)
#define IOMUXC_PAD_ENET1_MDC_NETC_MDC                    IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_MDC_OFFSET, 0x0, IOMUXC_NETC_CMPLX_EMDC_IN_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_ENET1_MDC_OFFSET)
#define IOMUXC_PAD_ENET1_MDC_LPUART3_DCD_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_MDC_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_MDC_OFFSET)
#define IOMUXC_PAD_ENET1_MDC_I3C2_SCL                    IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_MDC_OFFSET, 0x2, IOMUXC_I3C2_PIN_SCL_IN_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_ENET1_MDC_OFFSET)
#define IOMUXC_PAD_ENET1_MDC_USB1_OTG_ID                 IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_MDC_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_MDC_OFFSET)
#define IOMUXC_PAD_ENET1_MDC_FLEXIO2_FLEXIO00            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_MDC_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_MDC_OFFSET)
#define IOMUXC_PAD_ENET1_MDC_GPIO4_IO00                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_MDC_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_MDC_OFFSET)
#define IOMUXC_PAD_ENET1_MDIO_NETC_MDIO                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_MDIO_OFFSET, 0x0, IOMUXC_NETC_CMPLX_EMDIO_IN_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_ENET1_MDIO_OFFSET)
#define IOMUXC_PAD_ENET1_MDIO_LPUART3_RIN_B              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_MDIO_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_MDIO_OFFSET)
#define IOMUXC_PAD_ENET1_MDIO_I3C2_SDA                   IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_MDIO_OFFSET, 0x2, IOMUXC_I3C2_PIN_SDA_IN_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_ENET1_MDIO_OFFSET)
#define IOMUXC_PAD_ENET1_MDIO_USB1_OTG_PWR               IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_MDIO_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_MDIO_OFFSET)
#define IOMUXC_PAD_ENET1_MDIO_FLEXIO2_FLEXIO01           IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_MDIO_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_MDIO_OFFSET)
#define IOMUXC_PAD_ENET1_MDIO_GPIO4_IO01                 IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_MDIO_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_MDIO_OFFSET)
#define IOMUXC_PAD_ENET1_TD3_ETH0_RGMII_TD3              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TD3_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TD3_OFFSET)
#define IOMUXC_PAD_ENET1_TD3_CAN2_TX                     IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TD3_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TD3_OFFSET)
#define IOMUXC_PAD_ENET1_TD3_USB2_OTG_ID                 IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TD3_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TD3_OFFSET)
#define IOMUXC_PAD_ENET1_TD3_FLEXIO2_FLEXIO02            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TD3_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TD3_OFFSET)
#define IOMUXC_PAD_ENET1_TD3_GPIO4_IO02                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TD3_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TD3_OFFSET)
#define IOMUXC_PAD_ENET1_TD2_ETH0_RGMII_TD2              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TD2_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TD2_OFFSET)
#define IOMUXC_PAD_ENET1_TD2_ETH0_RMII_REF50_CLK         IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TD2_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TD2_OFFSET)
#define IOMUXC_PAD_ENET1_TD2_CAN2_RX                     IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TD2_OFFSET, 0x2, IOMUXC_CAN2_IPP_IND_CANRX_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_ENET1_TD2_OFFSET)
#define IOMUXC_PAD_ENET1_TD2_USB2_OTG_OC                 IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TD2_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TD2_OFFSET)
#define IOMUXC_PAD_ENET1_TD2_FLEXIO2_FLEXIO03            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TD2_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TD2_OFFSET)
#define IOMUXC_PAD_ENET1_TD2_GPIO4_IO03                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TD2_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TD2_OFFSET)
#define IOMUXC_PAD_ENET1_TD1_ETH0_RGMII_TD1              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TD1_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TD1_OFFSET)
#define IOMUXC_PAD_ENET1_TD1_LPUART3_RTS_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TD1_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TD1_OFFSET)
#define IOMUXC_PAD_ENET1_TD1_I3C2_PUR                    IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TD1_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TD1_OFFSET)
#define IOMUXC_PAD_ENET1_TD1_USB1_OTG_OC                 IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TD1_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TD1_OFFSET)
#define IOMUXC_PAD_ENET1_TD1_FLEXIO2_FLEXIO04            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TD1_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TD1_OFFSET)
#define IOMUXC_PAD_ENET1_TD1_GPIO4_IO04                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TD1_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TD1_OFFSET)
#define IOMUXC_PAD_ENET1_TD1_I3C2_PUR_B                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TD1_OFFSET, 0x6, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TD1_OFFSET)
#define IOMUXC_PAD_ENET1_TD1_ETH0_RMII_TXD1              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TD1_OFFSET, 0x7, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TD1_OFFSET)
#define IOMUXC_PAD_ENET1_TD0_ETH0_RGMII_TD0              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TD0_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TD0_OFFSET)
#define IOMUXC_PAD_ENET1_TD0_LPUART3_TX                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TD0_OFFSET, 0x1, IOMUXC_LPUART3_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_ENET1_TD0_OFFSET)
#define IOMUXC_PAD_ENET1_TD0_ETH0_RMII_TXD0              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TD0_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TD0_OFFSET)
#define IOMUXC_PAD_ENET1_TD0_FLEXIO2_FLEXIO05            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TD0_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TD0_OFFSET)
#define IOMUXC_PAD_ENET1_TD0_GPIO4_IO05                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TD0_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TD0_OFFSET)
#define IOMUXC_PAD_ENET1_TX_CTL_ETH0_RGMII_TX_CTL        IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TX_CTL_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TX_CTL_OFFSET)
#define IOMUXC_PAD_ENET1_TX_CTL_LPUART3_DTR_B            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TX_CTL_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TX_CTL_OFFSET)
#define IOMUXC_PAD_ENET1_TX_CTL_ETH0_RMII_TX_EN          IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TX_CTL_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TX_CTL_OFFSET)
#define IOMUXC_PAD_ENET1_TX_CTL_FLEXIO2_FLEXIO06         IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TX_CTL_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TX_CTL_OFFSET)
#define IOMUXC_PAD_ENET1_TX_CTL_GPIO4_IO06               IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TX_CTL_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TX_CTL_OFFSET)
#define IOMUXC_PAD_ENET1_TXC_ETH0_RGMII_TX_CLK           IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TXC_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TXC_OFFSET)
#define IOMUXC_PAD_ENET1_TXC_ENET_CLK_ROOT               IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TXC_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TXC_OFFSET)
#define IOMUXC_PAD_ENET1_TXC_FLEXIO2_FLEXIO07            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TXC_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TXC_OFFSET)
#define IOMUXC_PAD_ENET1_TXC_GPIO4_IO07                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_TXC_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_TXC_OFFSET)
#define IOMUXC_PAD_ENET1_RX_CTL_ETH0_RGMII_RX_CTL        IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RX_CTL_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_RX_CTL_OFFSET)
#define IOMUXC_PAD_ENET1_RX_CTL_LPUART3_DSR_B            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RX_CTL_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_RX_CTL_OFFSET)
#define IOMUXC_PAD_ENET1_RX_CTL_ETH0_RMII_CRS_DV         IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RX_CTL_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_RX_CTL_OFFSET)
#define IOMUXC_PAD_ENET1_RX_CTL_USB2_OTG_PWR             IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RX_CTL_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_RX_CTL_OFFSET)
#define IOMUXC_PAD_ENET1_RX_CTL_FLEXIO2_FLEXIO08         IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RX_CTL_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_RX_CTL_OFFSET)
#define IOMUXC_PAD_ENET1_RX_CTL_GPIO4_IO08               IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RX_CTL_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_RX_CTL_OFFSET)
#define IOMUXC_PAD_ENET1_RXC_ETH0_RGMII_RX_CLK           IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RXC_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_RXC_OFFSET)
#define IOMUXC_PAD_ENET1_RXC_ETH0_RMII_RX_ER             IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RXC_OFFSET, 0x1, IOMUXC_NETC_CMPLX_ETH0_RMII_RX_ER_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_ENET1_RXC_OFFSET)
#define IOMUXC_PAD_ENET1_RXC_FLEXIO2_FLEXIO09            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RXC_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_RXC_OFFSET)
#define IOMUXC_PAD_ENET1_RXC_GPIO4_IO09                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RXC_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_RXC_OFFSET)
#define IOMUXC_PAD_ENET1_RD0_ETH0_RGMII_RD0              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RD0_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_RD0_OFFSET)
#define IOMUXC_PAD_ENET1_RD0_LPUART3_RX                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RD0_OFFSET, 0x1, IOMUXC_LPUART3_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_ENET1_RD0_OFFSET)
#define IOMUXC_PAD_ENET1_RD0_ETH0_RMII_RXD0              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RD0_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_RD0_OFFSET)
#define IOMUXC_PAD_ENET1_RD0_FLEXIO2_FLEXIO10            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RD0_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_RD0_OFFSET)
#define IOMUXC_PAD_ENET1_RD0_GPIO4_IO10                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RD0_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_RD0_OFFSET)
#define IOMUXC_PAD_ENET1_RD1_ETH0_RGMII_RD1              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RD1_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_RD1_OFFSET)
#define IOMUXC_PAD_ENET1_RD1_LPUART3_CTS_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RD1_OFFSET, 0x1, IOMUXC_LPUART3_IPP_IND_LPUART_CTS_N_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_ENET1_RD1_OFFSET)
#define IOMUXC_PAD_ENET1_RD1_ETH0_RMII_RXD1              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RD1_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_RD1_OFFSET)
#define IOMUXC_PAD_ENET1_RD1_LPTMR2_ALT1                 IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RD1_OFFSET, 0x3, IOMUXC_LPTMR2_IPP_IND_LPTIMER_SELECT_INPUT_0_OFFSET, 0x0, IOMUXC_PAD_CTL_ENET1_RD1_OFFSET)
#define IOMUXC_PAD_ENET1_RD1_FLEXIO2_FLEXIO11            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RD1_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_RD1_OFFSET)
#define IOMUXC_PAD_ENET1_RD1_GPIO4_IO11                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RD1_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_RD1_OFFSET)
#define IOMUXC_PAD_ENET1_RD2_ETH0_RGMII_RD2              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RD2_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_RD2_OFFSET)
#define IOMUXC_PAD_ENET1_RD2_ETH0_RMII_RX_ER             IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RD2_OFFSET, 0x2, IOMUXC_NETC_CMPLX_ETH0_RMII_RX_ER_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_ENET1_RD2_OFFSET)
#define IOMUXC_PAD_ENET1_RD2_LPTMR2_ALT2                 IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RD2_OFFSET, 0x3, IOMUXC_LPTMR2_IPP_IND_LPTIMER_SELECT_INPUT_1_OFFSET, 0x0, IOMUXC_PAD_CTL_ENET1_RD2_OFFSET)
#define IOMUXC_PAD_ENET1_RD2_FLEXIO2_FLEXIO12            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RD2_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_RD2_OFFSET)
#define IOMUXC_PAD_ENET1_RD2_GPIO4_IO12                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RD2_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_RD2_OFFSET)
#define IOMUXC_PAD_ENET1_RD3_ETH0_RGMII_RD3              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RD3_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_RD3_OFFSET)
#define IOMUXC_PAD_ENET1_RD3_LPTMR2_ALT3                 IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RD3_OFFSET, 0x3, IOMUXC_LPTMR2_IPP_IND_LPTIMER_SELECT_INPUT_2_OFFSET, 0x0, IOMUXC_PAD_CTL_ENET1_RD3_OFFSET)
#define IOMUXC_PAD_ENET1_RD3_FLEXIO2_FLEXIO13            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RD3_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_RD3_OFFSET)
#define IOMUXC_PAD_ENET1_RD3_GPIO4_IO13                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET1_RD3_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET1_RD3_OFFSET)
#define IOMUXC_PAD_ENET2_MDC_NETC_MDC                    IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_MDC_OFFSET, 0x0, IOMUXC_NETC_CMPLX_EMDC_IN_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_ENET2_MDC_OFFSET)
#define IOMUXC_PAD_ENET2_MDC_LPUART4_DCD_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_MDC_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_MDC_OFFSET)
#define IOMUXC_PAD_ENET2_MDC_SAI2_RX_SYNC                IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_MDC_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_MDC_OFFSET)
#define IOMUXC_PAD_ENET2_MDC_FLEXIO2_FLEXIO14            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_MDC_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_MDC_OFFSET)
#define IOMUXC_PAD_ENET2_MDC_GPIO4_IO14                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_MDC_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_MDC_OFFSET)
#define IOMUXC_PAD_ENET2_MDIO_NETC_MDIO                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_MDIO_OFFSET, 0x0, IOMUXC_NETC_CMPLX_EMDIO_IN_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_ENET2_MDIO_OFFSET)
#define IOMUXC_PAD_ENET2_MDIO_LPUART4_RIN_B              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_MDIO_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_MDIO_OFFSET)
#define IOMUXC_PAD_ENET2_MDIO_SAI2_RX_BCLK               IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_MDIO_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_MDIO_OFFSET)
#define IOMUXC_PAD_ENET2_MDIO_FLEXIO2_FLEXIO15           IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_MDIO_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_MDIO_OFFSET)
#define IOMUXC_PAD_ENET2_MDIO_GPIO4_IO15                 IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_MDIO_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_MDIO_OFFSET)
#define IOMUXC_PAD_ENET2_TD3_ETH1_RGMII_TD3              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TD3_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TD3_OFFSET)
#define IOMUXC_PAD_ENET2_TD3_SAI2_RX_DATA00              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TD3_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TD3_OFFSET)
#define IOMUXC_PAD_ENET2_TD3_FLEXIO2_FLEXIO16            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TD3_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TD3_OFFSET)
#define IOMUXC_PAD_ENET2_TD3_GPIO4_IO16                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TD3_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TD3_OFFSET)
#define IOMUXC_PAD_ENET2_TD2_ETH1_RGMII_TD2              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TD2_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TD2_OFFSET)
#define IOMUXC_PAD_ENET2_TD2_ETH1_RMII_REF50_CLK         IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TD2_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TD2_OFFSET)
#define IOMUXC_PAD_ENET2_TD2_SAI2_RX_DATA01              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TD2_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TD2_OFFSET)
#define IOMUXC_PAD_ENET2_TD2_SAI4_TX_SYNC                IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TD2_OFFSET, 0x3, IOMUXC_SAI4_IPP_IND_SAI_TXSYNC_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_ENET2_TD2_OFFSET)
#define IOMUXC_PAD_ENET2_TD2_FLEXIO2_FLEXIO17            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TD2_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TD2_OFFSET)
#define IOMUXC_PAD_ENET2_TD2_GPIO4_IO17                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TD2_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TD2_OFFSET)
#define IOMUXC_PAD_ENET2_TD1_ETH1_RGMII_TD1              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TD1_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TD1_OFFSET)
#define IOMUXC_PAD_ENET2_TD1_LPUART4_RTS_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TD1_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TD1_OFFSET)
#define IOMUXC_PAD_ENET2_TD1_SAI2_RX_DATA02              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TD1_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TD1_OFFSET)
#define IOMUXC_PAD_ENET2_TD1_SAI4_TX_BCLK                IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TD1_OFFSET, 0x3, IOMUXC_SAI4_IPP_IND_SAI_TXBCLK_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_ENET2_TD1_OFFSET)
#define IOMUXC_PAD_ENET2_TD1_FLEXIO2_FLEXIO18            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TD1_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TD1_OFFSET)
#define IOMUXC_PAD_ENET2_TD1_GPIO4_IO18                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TD1_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TD1_OFFSET)
#define IOMUXC_PAD_ENET2_TD1_ETH1_RMII_TXD1              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TD1_OFFSET, 0x6, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TD1_OFFSET)
#define IOMUXC_PAD_ENET2_TD0_ETH1_RGMII_TD0              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TD0_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TD0_OFFSET)
#define IOMUXC_PAD_ENET2_TD0_LPUART4_TX                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TD0_OFFSET, 0x1, IOMUXC_LPUART4_IPP_IND_LPUART_TXD_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_ENET2_TD0_OFFSET)
#define IOMUXC_PAD_ENET2_TD0_SAI2_RX_DATA03              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TD0_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TD0_OFFSET)
#define IOMUXC_PAD_ENET2_TD0_SAI4_TX_DATA00              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TD0_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TD0_OFFSET)
#define IOMUXC_PAD_ENET2_TD0_FLEXIO2_FLEXIO19            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TD0_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TD0_OFFSET)
#define IOMUXC_PAD_ENET2_TD0_GPIO4_IO19                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TD0_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TD0_OFFSET)
#define IOMUXC_PAD_ENET2_TD0_ETH1_RMII_TXD0              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TD0_OFFSET, 0x6, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TD0_OFFSET)
#define IOMUXC_PAD_ENET2_TX_CTL_ETH1_RGMII_TX_CTL        IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TX_CTL_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TX_CTL_OFFSET)
#define IOMUXC_PAD_ENET2_TX_CTL_LPUART4_DTR_B            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TX_CTL_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TX_CTL_OFFSET)
#define IOMUXC_PAD_ENET2_TX_CTL_SAI2_TX_SYNC             IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TX_CTL_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TX_CTL_OFFSET)
#define IOMUXC_PAD_ENET2_TX_CTL_ETH1_RMII_TX_EN          IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TX_CTL_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TX_CTL_OFFSET)
#define IOMUXC_PAD_ENET2_TX_CTL_FLEXIO2_FLEXIO20         IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TX_CTL_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TX_CTL_OFFSET)
#define IOMUXC_PAD_ENET2_TX_CTL_GPIO4_IO20               IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TX_CTL_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TX_CTL_OFFSET)
#define IOMUXC_PAD_ENET2_TXC_ETH1_RGMII_TX_CLK           IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TXC_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TXC_OFFSET)
#define IOMUXC_PAD_ENET2_TXC_ENET_CLK_ROOT               IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TXC_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TXC_OFFSET)
#define IOMUXC_PAD_ENET2_TXC_SAI2_TX_BCLK                IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TXC_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TXC_OFFSET)
#define IOMUXC_PAD_ENET2_TXC_FLEXIO2_FLEXIO21            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TXC_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TXC_OFFSET)
#define IOMUXC_PAD_ENET2_TXC_GPIO4_IO21                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_TXC_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_TXC_OFFSET)
#define IOMUXC_PAD_ENET2_RX_CTL_ETH1_RGMII_RX_CTL        IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RX_CTL_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RX_CTL_OFFSET)
#define IOMUXC_PAD_ENET2_RX_CTL_LPUART4_DSR_B            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RX_CTL_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RX_CTL_OFFSET)
#define IOMUXC_PAD_ENET2_RX_CTL_SAI2_TX_DATA00           IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RX_CTL_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RX_CTL_OFFSET)
#define IOMUXC_PAD_ENET2_RX_CTL_FLEXIO2_FLEXIO22         IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RX_CTL_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RX_CTL_OFFSET)
#define IOMUXC_PAD_ENET2_RX_CTL_GPIO4_IO22               IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RX_CTL_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RX_CTL_OFFSET)
#define IOMUXC_PAD_ENET2_RX_CTL_ETH1_RMII_CRS_DV         IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RX_CTL_OFFSET, 0x6, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RX_CTL_OFFSET)
#define IOMUXC_PAD_ENET2_RXC_ETH1_RGMII_RX_CLK           IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RXC_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RXC_OFFSET)
#define IOMUXC_PAD_ENET2_RXC_ETH1_RMII_RX_ER             IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RXC_OFFSET, 0x1, IOMUXC_NETC_CMPLX_ETH1_RMII_RX_ER_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_ENET2_RXC_OFFSET)
#define IOMUXC_PAD_ENET2_RXC_SAI2_TX_DATA01              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RXC_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RXC_OFFSET)
#define IOMUXC_PAD_ENET2_RXC_SAI4_RX_SYNC                IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RXC_OFFSET, 0x3, IOMUXC_SAI4_IPP_IND_SAI_RXSYNC_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_ENET2_RXC_OFFSET)
#define IOMUXC_PAD_ENET2_RXC_FLEXIO2_FLEXIO23            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RXC_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RXC_OFFSET)
#define IOMUXC_PAD_ENET2_RXC_GPIO4_IO23                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RXC_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RXC_OFFSET)
#define IOMUXC_PAD_ENET2_RD0_ETH1_RGMII_RD0              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD0_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RD0_OFFSET)
#define IOMUXC_PAD_ENET2_RD0_LPUART4_RX                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD0_OFFSET, 0x1, IOMUXC_LPUART4_IPP_IND_LPUART_RXD_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_ENET2_RD0_OFFSET)
#define IOMUXC_PAD_ENET2_RD0_SAI2_TX_DATA02              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD0_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RD0_OFFSET)
#define IOMUXC_PAD_ENET2_RD0_SAI4_RX_BCLK                IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD0_OFFSET, 0x3, IOMUXC_SAI4_IPP_IND_SAI_RXBCLK_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_ENET2_RD0_OFFSET)
#define IOMUXC_PAD_ENET2_RD0_FLEXIO2_FLEXIO24            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD0_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RD0_OFFSET)
#define IOMUXC_PAD_ENET2_RD0_GPIO4_IO24                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD0_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RD0_OFFSET)
#define IOMUXC_PAD_ENET2_RD0_ETH1_RMII_RXD0              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD0_OFFSET, 0x6, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RD0_OFFSET)
#define IOMUXC_PAD_ENET2_RD1_ETH1_RGMII_RD1              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD1_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RD1_OFFSET)
#define IOMUXC_PAD_ENET2_RD1_SPDIF_IN                    IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD1_OFFSET, 0x1, IOMUXC_EARC_PHY_SPDIF_IN_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_ENET2_RD1_OFFSET)
#define IOMUXC_PAD_ENET2_RD1_SAI2_TX_DATA03              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD1_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RD1_OFFSET)
#define IOMUXC_PAD_ENET2_RD1_SAI4_RX_DATA00              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD1_OFFSET, 0x3, IOMUXC_SAI4_IPP_IND_SAI_RXDATA_SELECT_INPUT_0_OFFSET, 0x0, IOMUXC_PAD_CTL_ENET2_RD1_OFFSET)
#define IOMUXC_PAD_ENET2_RD1_FLEXIO2_FLEXIO25            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD1_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RD1_OFFSET)
#define IOMUXC_PAD_ENET2_RD1_GPIO4_IO25                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD1_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RD1_OFFSET)
#define IOMUXC_PAD_ENET2_RD1_ETH1_RMII_RXD1              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD1_OFFSET, 0x6, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RD1_OFFSET)
#define IOMUXC_PAD_ENET2_RD2_ETH1_RGMII_RD2              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD2_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RD2_OFFSET)
#define IOMUXC_PAD_ENET2_RD2_LPUART4_CTS_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD2_OFFSET, 0x1, IOMUXC_LPUART4_IPP_IND_LPUART_CTS_N_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_ENET2_RD2_OFFSET)
#define IOMUXC_PAD_ENET2_RD2_SAI2_MCLK                   IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD2_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RD2_OFFSET)
#define IOMUXC_PAD_ENET2_RD2_MQS2_RIGHT                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD2_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RD2_OFFSET)
#define IOMUXC_PAD_ENET2_RD2_FLEXIO2_FLEXIO26            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD2_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RD2_OFFSET)
#define IOMUXC_PAD_ENET2_RD2_GPIO4_IO26                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD2_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RD2_OFFSET)
#define IOMUXC_PAD_ENET2_RD2_ETH1_RMII_RX_ER             IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD2_OFFSET, 0x6, IOMUXC_NETC_CMPLX_ETH1_RMII_RX_ER_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_ENET2_RD2_OFFSET)
#define IOMUXC_PAD_ENET2_RD3_ETH1_RGMII_RD3              IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD3_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RD3_OFFSET)
#define IOMUXC_PAD_ENET2_RD3_SPDIF_OUT                   IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD3_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RD3_OFFSET)
#define IOMUXC_PAD_ENET2_RD3_SPDIF_IN                    IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD3_OFFSET, 0x2, IOMUXC_EARC_PHY_SPDIF_IN_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_ENET2_RD3_OFFSET)
#define IOMUXC_PAD_ENET2_RD3_MQS2_LEFT                   IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD3_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RD3_OFFSET)
#define IOMUXC_PAD_ENET2_RD3_FLEXIO2_FLEXIO27            IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD3_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RD3_OFFSET)
#define IOMUXC_PAD_ENET2_RD3_GPIO4_IO27                  IOMUX_PADCFG(IOMUXC_MUX_CTL_ENET2_RD3_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_ENET2_RD3_OFFSET)
#define IOMUXC_PAD_SD1_CLK_USDHC1_CLK                    IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_CLK_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_CLK_OFFSET)
#define IOMUXC_PAD_SD1_CLK_FLEXIO1_FLEXIO08              IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_CLK_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_8_OFFSET, 0x1, IOMUXC_PAD_CTL_SD1_CLK_OFFSET)
#define IOMUXC_PAD_SD1_CLK_GPIO3_IO08                    IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_CLK_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_CLK_OFFSET)
#define IOMUXC_PAD_SD1_CMD_USDHC1_CMD                    IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_CMD_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_CMD_OFFSET)
#define IOMUXC_PAD_SD1_CMD_FLEXIO1_FLEXIO09              IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_CMD_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_9_OFFSET, 0x1, IOMUXC_PAD_CTL_SD1_CMD_OFFSET)
#define IOMUXC_PAD_SD1_CMD_GPIO3_IO09                    IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_CMD_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_CMD_OFFSET)
#define IOMUXC_PAD_SD1_DATA0_USDHC1_DATA0                IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA0_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_DATA0_OFFSET)
#define IOMUXC_PAD_SD1_DATA0_FLEXIO1_FLEXIO10            IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA0_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_10_OFFSET, 0x1, IOMUXC_PAD_CTL_SD1_DATA0_OFFSET)
#define IOMUXC_PAD_SD1_DATA0_GPIO3_IO10                  IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA0_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_DATA0_OFFSET)
#define IOMUXC_PAD_SD1_DATA1_USDHC1_DATA1                IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA1_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_DATA1_OFFSET)
#define IOMUXC_PAD_SD1_DATA1_FLEXIO1_FLEXIO11            IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA1_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_11_OFFSET, 0x1, IOMUXC_PAD_CTL_SD1_DATA1_OFFSET)
#define IOMUXC_PAD_SD1_DATA1_GPIO3_IO11                  IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA1_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_DATA1_OFFSET)
#define IOMUXC_PAD_SD1_DATA2_USDHC1_DATA2                IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA2_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_DATA2_OFFSET)
#define IOMUXC_PAD_SD1_DATA2_FLEXIO1_FLEXIO12            IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA2_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_12_OFFSET, 0x1, IOMUXC_PAD_CTL_SD1_DATA2_OFFSET)
#define IOMUXC_PAD_SD1_DATA2_GPIO3_IO12                  IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA2_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_DATA2_OFFSET)
#define IOMUXC_PAD_SD1_DATA3_USDHC1_DATA3                IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA3_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_DATA3_OFFSET)
#define IOMUXC_PAD_SD1_DATA3_FLEXSPI1_A_SS1_B            IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA3_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_DATA3_OFFSET)
#define IOMUXC_PAD_SD1_DATA3_FLEXIO1_FLEXIO13            IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA3_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_13_OFFSET, 0x1, IOMUXC_PAD_CTL_SD1_DATA3_OFFSET)
#define IOMUXC_PAD_SD1_DATA3_GPIO3_IO13                  IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA3_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_DATA3_OFFSET)
#define IOMUXC_PAD_SD1_DATA4_USDHC1_DATA4                IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA4_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_DATA4_OFFSET)
#define IOMUXC_PAD_SD1_DATA4_FLEXSPI1_A_DATA04           IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA4_OFFSET, 0x1, IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_4_OFFSET, 0x0, IOMUXC_PAD_CTL_SD1_DATA4_OFFSET)
#define IOMUXC_PAD_SD1_DATA4_FLEXIO1_FLEXIO14            IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA4_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_14_OFFSET, 0x1, IOMUXC_PAD_CTL_SD1_DATA4_OFFSET)
#define IOMUXC_PAD_SD1_DATA4_GPIO3_IO14                  IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA4_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_DATA4_OFFSET)
#define IOMUXC_PAD_SD1_DATA4_XSPI_DATA04                 IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA4_OFFSET, 0x6, IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_4_OFFSET, 0x0, IOMUXC_PAD_CTL_SD1_DATA4_OFFSET)
#define IOMUXC_PAD_SD1_DATA5_USDHC1_DATA5                IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA5_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_DATA5_OFFSET)
#define IOMUXC_PAD_SD1_DATA5_FLEXSPI1_A_DATA05           IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA5_OFFSET, 0x1, IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_5_OFFSET, 0x0, IOMUXC_PAD_CTL_SD1_DATA5_OFFSET)
#define IOMUXC_PAD_SD1_DATA5_USDHC1_RESET_B              IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA5_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_DATA5_OFFSET)
#define IOMUXC_PAD_SD1_DATA5_FLEXIO1_FLEXIO15            IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA5_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_15_OFFSET, 0x1, IOMUXC_PAD_CTL_SD1_DATA5_OFFSET)
#define IOMUXC_PAD_SD1_DATA5_GPIO3_IO15                  IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA5_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_DATA5_OFFSET)
#define IOMUXC_PAD_SD1_DATA5_XSPI_DATA05                 IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA5_OFFSET, 0x6, IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_5_OFFSET, 0x0, IOMUXC_PAD_CTL_SD1_DATA5_OFFSET)
#define IOMUXC_PAD_SD1_DATA6_USDHC1_DATA6                IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA6_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_DATA6_OFFSET)
#define IOMUXC_PAD_SD1_DATA6_FLEXSPI1_A_DATA06           IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA6_OFFSET, 0x1, IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_6_OFFSET, 0x0, IOMUXC_PAD_CTL_SD1_DATA6_OFFSET)
#define IOMUXC_PAD_SD1_DATA6_USDHC1_CD_B                 IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA6_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_DATA6_OFFSET)
#define IOMUXC_PAD_SD1_DATA6_FLEXIO1_FLEXIO16            IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA6_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_16_OFFSET, 0x1, IOMUXC_PAD_CTL_SD1_DATA6_OFFSET)
#define IOMUXC_PAD_SD1_DATA6_GPIO3_IO16                  IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA6_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_DATA6_OFFSET)
#define IOMUXC_PAD_SD1_DATA6_XSPI_DATA06                 IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA6_OFFSET, 0x6, IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_6_OFFSET, 0x0, IOMUXC_PAD_CTL_SD1_DATA6_OFFSET)
#define IOMUXC_PAD_SD1_DATA7_USDHC1_DATA7                IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA7_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_DATA7_OFFSET)
#define IOMUXC_PAD_SD1_DATA7_FLEXSPI1_A_DATA07           IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA7_OFFSET, 0x1, IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_7_OFFSET, 0x0, IOMUXC_PAD_CTL_SD1_DATA7_OFFSET)
#define IOMUXC_PAD_SD1_DATA7_USDHC1_WP                   IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA7_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_DATA7_OFFSET)
#define IOMUXC_PAD_SD1_DATA7_FLEXIO1_FLEXIO17            IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA7_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_17_OFFSET, 0x1, IOMUXC_PAD_CTL_SD1_DATA7_OFFSET)
#define IOMUXC_PAD_SD1_DATA7_GPIO3_IO17                  IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA7_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_DATA7_OFFSET)
#define IOMUXC_PAD_SD1_DATA7_XSPI_DATA07                 IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_DATA7_OFFSET, 0x6, IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_7_OFFSET, 0x0, IOMUXC_PAD_CTL_SD1_DATA7_OFFSET)
#define IOMUXC_PAD_SD1_STROBE_USDHC1_STROBE              IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_STROBE_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_STROBE_OFFSET)
#define IOMUXC_PAD_SD1_STROBE_FLEXSPI1_A_DQS             IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_STROBE_OFFSET, 0x1, IOMUXC_FLEXSPI1_I_IPP_IND_DQS_FA_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_SD1_STROBE_OFFSET)
#define IOMUXC_PAD_SD1_STROBE_FLEXIO1_FLEXIO18           IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_STROBE_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_18_OFFSET, 0x1, IOMUXC_PAD_CTL_SD1_STROBE_OFFSET)
#define IOMUXC_PAD_SD1_STROBE_GPIO3_IO18                 IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_STROBE_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD1_STROBE_OFFSET)
#define IOMUXC_PAD_SD1_STROBE_XSPI_DQS                   IOMUX_PADCFG(IOMUXC_MUX_CTL_SD1_STROBE_OFFSET, 0x6, IOMUXC_XSPI_IPP_IND_DQS_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_SD1_STROBE_OFFSET)
#define IOMUXC_PAD_SD2_VSELECT_USDHC2_VSELECT            IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_VSELECT_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_VSELECT_OFFSET)
#define IOMUXC_PAD_SD2_VSELECT_USDHC2_WP                 IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_VSELECT_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_VSELECT_OFFSET)
#define IOMUXC_PAD_SD2_VSELECT_LPTMR2_ALT3               IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_VSELECT_OFFSET, 0x2, IOMUXC_LPTMR2_IPP_IND_LPTIMER_SELECT_INPUT_2_OFFSET, 0x1, IOMUXC_PAD_CTL_SD2_VSELECT_OFFSET)
#define IOMUXC_PAD_SD2_VSELECT_FLEXIO1_FLEXIO19          IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_VSELECT_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_19_OFFSET, 0x1, IOMUXC_PAD_CTL_SD2_VSELECT_OFFSET)
#define IOMUXC_PAD_SD2_VSELECT_GPIO3_IO19                IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_VSELECT_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_VSELECT_OFFSET)
#define IOMUXC_PAD_SD3_CLK_USDHC3_CLK                    IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_CLK_OFFSET, 0x0, IOMUXC_USDHC3_IPP_CARD_CLK_IN_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_SD3_CLK_OFFSET)
#define IOMUXC_PAD_SD3_CLK_FLEXSPI1_A_SCLK               IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_CLK_OFFSET, 0x1, IOMUXC_FLEXSPI1_I_IPP_IND_SCK_FA_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_SD3_CLK_OFFSET)
#define IOMUXC_PAD_SD3_CLK_SAI5_TX_DATA01                IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_CLK_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD3_CLK_OFFSET)
#define IOMUXC_PAD_SD3_CLK_SAI5_RX_DATA00                IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_CLK_OFFSET, 0x3, IOMUXC_SAI5_IPP_IND_SAI_RXDATA_SELECT_INPUT_0_OFFSET, 0x0, IOMUXC_PAD_CTL_SD3_CLK_OFFSET)
#define IOMUXC_PAD_SD3_CLK_FLEXIO1_FLEXIO20              IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_CLK_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_20_OFFSET, 0x1, IOMUXC_PAD_CTL_SD3_CLK_OFFSET)
#define IOMUXC_PAD_SD3_CLK_GPIO3_IO20                    IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_CLK_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD3_CLK_OFFSET)
#define IOMUXC_PAD_SD3_CLK_XSPI_CLK                      IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_CLK_OFFSET, 0x6, IOMUXC_XSPI_IPP_IND_SCK_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_SD3_CLK_OFFSET)
#define IOMUXC_PAD_SD3_CMD_USDHC3_CMD                    IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_CMD_OFFSET, 0x0, IOMUXC_USDHC3_IPP_CMD_IN_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_SD3_CMD_OFFSET)
#define IOMUXC_PAD_SD3_CMD_FLEXSPI1_A_SS0_B              IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_CMD_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD3_CMD_OFFSET)
#define IOMUXC_PAD_SD3_CMD_SAI5_TX_DATA02                IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_CMD_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD3_CMD_OFFSET)
#define IOMUXC_PAD_SD3_CMD_SAI5_RX_SYNC                  IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_CMD_OFFSET, 0x3, IOMUXC_SAI5_IPP_IND_SAI_RXSYNC_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_SD3_CMD_OFFSET)
#define IOMUXC_PAD_SD3_CMD_FLEXIO1_FLEXIO21              IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_CMD_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_21_OFFSET, 0x1, IOMUXC_PAD_CTL_SD3_CMD_OFFSET)
#define IOMUXC_PAD_SD3_CMD_GPIO3_IO21                    IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_CMD_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD3_CMD_OFFSET)
#define IOMUXC_PAD_SD3_CMD_XSPI_CS                       IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_CMD_OFFSET, 0x6, IOMUXC_XSPI_IPP_IND_CS_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_SD3_CMD_OFFSET)
#define IOMUXC_PAD_SD3_DATA0_USDHC3_DATA0                IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA0_OFFSET, 0x0, IOMUXC_USDHC3_IPP_DAT0_IN_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_SD3_DATA0_OFFSET)
#define IOMUXC_PAD_SD3_DATA0_FLEXSPI1_A_DATA00           IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA0_OFFSET, 0x1, IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_0_OFFSET, 0x0, IOMUXC_PAD_CTL_SD3_DATA0_OFFSET)
#define IOMUXC_PAD_SD3_DATA0_SAI5_TX_DATA03              IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA0_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD3_DATA0_OFFSET)
#define IOMUXC_PAD_SD3_DATA0_SAI5_RX_BCLK                IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA0_OFFSET, 0x3, IOMUXC_SAI5_IPP_IND_SAI_RXBCLK_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_SD3_DATA0_OFFSET)
#define IOMUXC_PAD_SD3_DATA0_FLEXIO1_FLEXIO22            IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA0_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_22_OFFSET, 0x1, IOMUXC_PAD_CTL_SD3_DATA0_OFFSET)
#define IOMUXC_PAD_SD3_DATA0_GPIO3_IO22                  IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA0_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD3_DATA0_OFFSET)
#define IOMUXC_PAD_SD3_DATA0_XSPI_DATA00                 IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA0_OFFSET, 0x6, IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_0_OFFSET, 0x0, IOMUXC_PAD_CTL_SD3_DATA0_OFFSET)
#define IOMUXC_PAD_SD3_DATA1_USDHC3_DATA1                IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA1_OFFSET, 0x0, IOMUXC_USDHC3_IPP_DAT1_IN_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_SD3_DATA1_OFFSET)
#define IOMUXC_PAD_SD3_DATA1_FLEXSPI1_A_DATA01           IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA1_OFFSET, 0x1, IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_1_OFFSET, 0x0, IOMUXC_PAD_CTL_SD3_DATA1_OFFSET)
#define IOMUXC_PAD_SD3_DATA1_SAI5_RX_DATA01              IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA1_OFFSET, 0x2, IOMUXC_SAI5_IPP_IND_SAI_RXDATA_SELECT_INPUT_1_OFFSET, 0x0, IOMUXC_PAD_CTL_SD3_DATA1_OFFSET)
#define IOMUXC_PAD_SD3_DATA1_SAI5_TX_DATA00              IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA1_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD3_DATA1_OFFSET)
#define IOMUXC_PAD_SD3_DATA1_FLEXIO1_FLEXIO23            IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA1_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_23_OFFSET, 0x1, IOMUXC_PAD_CTL_SD3_DATA1_OFFSET)
#define IOMUXC_PAD_SD3_DATA1_GPIO3_IO23                  IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA1_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD3_DATA1_OFFSET)
#define IOMUXC_PAD_SD3_DATA1_XSPI_DATA01                 IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA1_OFFSET, 0x6, IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_1_OFFSET, 0x0, IOMUXC_PAD_CTL_SD3_DATA1_OFFSET)
#define IOMUXC_PAD_SD3_DATA2_USDHC3_DATA2                IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA2_OFFSET, 0x0, IOMUXC_USDHC3_IPP_DAT2_IN_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_SD3_DATA2_OFFSET)
#define IOMUXC_PAD_SD3_DATA2_FLEXSPI1_A_DATA02           IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA2_OFFSET, 0x1, IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_2_OFFSET, 0x0, IOMUXC_PAD_CTL_SD3_DATA2_OFFSET)
#define IOMUXC_PAD_SD3_DATA2_SAI5_RX_DATA02              IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA2_OFFSET, 0x2, IOMUXC_SAI5_IPP_IND_SAI_RXDATA_SELECT_INPUT_2_OFFSET, 0x0, IOMUXC_PAD_CTL_SD3_DATA2_OFFSET)
#define IOMUXC_PAD_SD3_DATA2_SAI5_TX_SYNC                IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA2_OFFSET, 0x3, IOMUXC_SAI5_IPP_IND_SAI_TXSYNC_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_SD3_DATA2_OFFSET)
#define IOMUXC_PAD_SD3_DATA2_FLEXIO1_FLEXIO24            IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA2_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_24_OFFSET, 0x1, IOMUXC_PAD_CTL_SD3_DATA2_OFFSET)
#define IOMUXC_PAD_SD3_DATA2_GPIO3_IO24                  IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA2_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD3_DATA2_OFFSET)
#define IOMUXC_PAD_SD3_DATA2_XSPI_DATA02                 IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA2_OFFSET, 0x6, IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_2_OFFSET, 0x0, IOMUXC_PAD_CTL_SD3_DATA2_OFFSET)
#define IOMUXC_PAD_SD3_DATA3_USDHC3_DATA3                IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA3_OFFSET, 0x0, IOMUXC_USDHC3_IPP_DAT3_IN_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_SD3_DATA3_OFFSET)
#define IOMUXC_PAD_SD3_DATA3_FLEXSPI1_A_DATA03           IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA3_OFFSET, 0x1, IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_3_OFFSET, 0x0, IOMUXC_PAD_CTL_SD3_DATA3_OFFSET)
#define IOMUXC_PAD_SD3_DATA3_SAI5_RX_DATA03              IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA3_OFFSET, 0x2, IOMUXC_SAI5_IPP_IND_SAI_RXDATA_SELECT_INPUT_3_OFFSET, 0x0, IOMUXC_PAD_CTL_SD3_DATA3_OFFSET)
#define IOMUXC_PAD_SD3_DATA3_SAI5_TX_BCLK                IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA3_OFFSET, 0x3, IOMUXC_SAI5_IPP_IND_SAI_TXBCLK_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_SD3_DATA3_OFFSET)
#define IOMUXC_PAD_SD3_DATA3_FLEXIO1_FLEXIO25            IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA3_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_25_OFFSET, 0x1, IOMUXC_PAD_CTL_SD3_DATA3_OFFSET)
#define IOMUXC_PAD_SD3_DATA3_GPIO3_IO25                  IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA3_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD3_DATA3_OFFSET)
#define IOMUXC_PAD_SD3_DATA3_XSPI_DATA03                 IOMUX_PADCFG(IOMUXC_MUX_CTL_SD3_DATA3_OFFSET, 0x6, IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_3_OFFSET, 0x0, IOMUXC_PAD_CTL_SD3_DATA3_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA0_FLEXSPI1_A_DATA00         IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA0_OFFSET, 0x0, IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_0_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA0_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA0_SAI2_TX_DATA04            IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA0_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_DATA0_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA0_SAI4_TX_BCLK              IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA0_OFFSET, 0x2, IOMUXC_SAI4_IPP_IND_SAI_TXBCLK_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA0_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA0_SAI4_RX_DATA01            IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA0_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_DATA0_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA0_XSPI_DATA00               IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA0_OFFSET, 0x4, IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_0_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA0_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA0_GPIO5_IO00                IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA0_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_DATA0_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA1_FLEXSPI1_A_DATA01         IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA1_OFFSET, 0x0, IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_1_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA1_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA1_SAI2_TX_DATA05            IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA1_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_DATA1_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA1_SAI4_TX_SYNC              IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA1_OFFSET, 0x2, IOMUXC_SAI4_IPP_IND_SAI_TXSYNC_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA1_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA1_SAI4_TX_DATA01            IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA1_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_DATA1_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA1_XSPI_DATA01               IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA1_OFFSET, 0x4, IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_1_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA1_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA1_GPIO5_IO01                IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA1_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_DATA1_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA2_FLEXSPI1_A_DATA02         IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA2_OFFSET, 0x0, IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_2_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA2_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA2_SAI2_TX_DATA06            IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA2_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_DATA2_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA2_SAI4_TX_DATA00            IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA2_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_DATA2_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA2_XSPI_DATA02               IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA2_OFFSET, 0x4, IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_2_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA2_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA2_GPIO5_IO02                IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA2_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_DATA2_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA3_FLEXSPI1_A_DATA03         IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA3_OFFSET, 0x0, IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_3_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA3_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA3_SAI2_TX_DATA07            IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA3_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_DATA3_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA3_SAI4_RX_DATA00            IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA3_OFFSET, 0x2, IOMUXC_SAI4_IPP_IND_SAI_RXDATA_SELECT_INPUT_0_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA3_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA3_XSPI_DATA03               IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA3_OFFSET, 0x4, IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_3_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA3_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA3_GPIO5_IO03                IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA3_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_DATA3_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA4_FLEXSPI1_A_DATA04         IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA4_OFFSET, 0x0, IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_4_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA4_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA4_SAI5_TX_DATA00            IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA4_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_DATA4_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA4_SAI5_RX_DATA01            IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA4_OFFSET, 0x2, IOMUXC_SAI5_IPP_IND_SAI_RXDATA_SELECT_INPUT_1_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA4_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA4_XSPI_DATA04               IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA4_OFFSET, 0x4, IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_4_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA4_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA4_GPIO5_IO04                IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA4_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_DATA4_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA5_FLEXSPI1_A_DATA05         IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA5_OFFSET, 0x0, IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_5_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA5_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA5_SAI5_TX_SYNC              IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA5_OFFSET, 0x1, IOMUXC_SAI5_IPP_IND_SAI_TXSYNC_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA5_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA5_SAI5_RX_DATA02            IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA5_OFFSET, 0x2, IOMUXC_SAI5_IPP_IND_SAI_RXDATA_SELECT_INPUT_2_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA5_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA5_SAI2_RX_DATA06            IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA5_OFFSET, 0x3, IOMUXC_SAI2_IPP_IND_SAI_RXDATA_SELECT_INPUT_6_OFFSET, 0x0, IOMUXC_PAD_CTL_XSPI1_DATA5_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA5_XSPI_DATA05               IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA5_OFFSET, 0x4, IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_5_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA5_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA5_GPIO5_IO05                IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA5_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_DATA5_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA6_FLEXSPI1_A_DATA06         IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA6_OFFSET, 0x0, IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_6_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA6_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA6_SAI5_TX_BCLK              IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA6_OFFSET, 0x1, IOMUXC_SAI5_IPP_IND_SAI_TXBCLK_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA6_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA6_SAI5_RX_DATA03            IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA6_OFFSET, 0x2, IOMUXC_SAI5_IPP_IND_SAI_RXDATA_SELECT_INPUT_3_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA6_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA6_SAI2_RX_DATA07            IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA6_OFFSET, 0x3, IOMUXC_SAI2_IPP_IND_SAI_RXDATA_SELECT_INPUT_7_OFFSET, 0x0, IOMUXC_PAD_CTL_XSPI1_DATA6_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA6_XSPI_DATA06               IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA6_OFFSET, 0x4, IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_6_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA6_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA6_GPIO5_IO06                IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA6_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_DATA6_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA7_FLEXSPI1_A_DATA07         IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA7_OFFSET, 0x0, IOMUXC_FLEXSPI1_I_IPP_IND_IO_FA_SELECT_INPUT_7_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA7_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA7_SAI5_RX_DATA00            IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA7_OFFSET, 0x1, IOMUXC_SAI5_IPP_IND_SAI_RXDATA_SELECT_INPUT_0_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA7_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA7_SAI5_TX_DATA01            IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA7_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_DATA7_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA7_XSPI_DATA07               IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA7_OFFSET, 0x4, IOMUXC_XSPI_SLV_IPP_IND_IO_SELECT_INPUT_7_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DATA7_OFFSET)
#define IOMUXC_PAD_XSPI1_DATA7_GPIO5_IO07                IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DATA7_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_DATA7_OFFSET)
#define IOMUXC_PAD_XSPI1_DQS_FLEXSPI1_A_DQS              IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DQS_OFFSET, 0x0, IOMUXC_FLEXSPI1_I_IPP_IND_DQS_FA_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DQS_OFFSET)
#define IOMUXC_PAD_XSPI1_DQS_SAI5_RX_SYNC                IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DQS_OFFSET, 0x1, IOMUXC_SAI5_IPP_IND_SAI_RXSYNC_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DQS_OFFSET)
#define IOMUXC_PAD_XSPI1_DQS_SAI5_TX_DATA02              IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DQS_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_DQS_OFFSET)
#define IOMUXC_PAD_XSPI1_DQS_SAI2_RX_DATA06              IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DQS_OFFSET, 0x3, IOMUXC_SAI2_IPP_IND_SAI_RXDATA_SELECT_INPUT_6_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DQS_OFFSET)
#define IOMUXC_PAD_XSPI1_DQS_XSPI_DQS                    IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DQS_OFFSET, 0x4, IOMUXC_XSPI_IPP_IND_DQS_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_DQS_OFFSET)
#define IOMUXC_PAD_XSPI1_DQS_GPIO5_IO08                  IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_DQS_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_DQS_OFFSET)
#define IOMUXC_PAD_XSPI1_SCLK_FLEXSPI1_A_SCLK            IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_SCLK_OFFSET, 0x0, IOMUXC_FLEXSPI1_I_IPP_IND_SCK_FA_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_SCLK_OFFSET)
#define IOMUXC_PAD_XSPI1_SCLK_SAI2_RX_DATA04             IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_SCLK_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_SCLK_OFFSET)
#define IOMUXC_PAD_XSPI1_SCLK_SAI4_RX_SYNC               IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_SCLK_OFFSET, 0x2, IOMUXC_SAI4_IPP_IND_SAI_RXSYNC_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_SCLK_OFFSET)
#define IOMUXC_PAD_XSPI1_SCLK_EARC_DC_HPD_IN             IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_SCLK_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_SCLK_OFFSET)
#define IOMUXC_PAD_XSPI1_SCLK_XSPI_CLK                   IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_SCLK_OFFSET, 0x4, IOMUXC_XSPI_IPP_IND_SCK_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_SCLK_OFFSET)
#define IOMUXC_PAD_XSPI1_SCLK_GPIO5_IO09                 IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_SCLK_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_SCLK_OFFSET)
#define IOMUXC_PAD_XSPI1_SS0_B_FLEXSPI1_A_SS0_B          IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_SS0_B_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_SS0_B_OFFSET)
#define IOMUXC_PAD_XSPI1_SS0_B_SAI2_RX_DATA05            IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_SS0_B_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_SS0_B_OFFSET)
#define IOMUXC_PAD_XSPI1_SS0_B_SAI4_RX_BCLK              IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_SS0_B_OFFSET, 0x2, IOMUXC_SAI4_IPP_IND_SAI_RXBCLK_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_SS0_B_OFFSET)
#define IOMUXC_PAD_XSPI1_SS0_B_EARC_CEC_OUT              IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_SS0_B_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_SS0_B_OFFSET)
#define IOMUXC_PAD_XSPI1_SS0_B_XSPI_CS                   IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_SS0_B_OFFSET, 0x4, IOMUXC_XSPI_IPP_IND_CS_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_SS0_B_OFFSET)
#define IOMUXC_PAD_XSPI1_SS0_B_GPIO5_IO10                IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_SS0_B_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_SS0_B_OFFSET)
#define IOMUXC_PAD_XSPI1_SS1_B_FLEXSPI1_A_SS1_B          IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_SS1_B_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_SS1_B_OFFSET)
#define IOMUXC_PAD_XSPI1_SS1_B_SAI5_RX_BCLK              IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_SS1_B_OFFSET, 0x1, IOMUXC_SAI5_IPP_IND_SAI_RXBCLK_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_SS1_B_OFFSET)
#define IOMUXC_PAD_XSPI1_SS1_B_SAI5_TX_DATA03            IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_SS1_B_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_SS1_B_OFFSET)
#define IOMUXC_PAD_XSPI1_SS1_B_SAI2_RX_DATA07            IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_SS1_B_OFFSET, 0x3, IOMUXC_SAI2_IPP_IND_SAI_RXDATA_SELECT_INPUT_7_OFFSET, 0x1, IOMUXC_PAD_CTL_XSPI1_SS1_B_OFFSET)
#define IOMUXC_PAD_XSPI1_SS1_B_GPIO5_IO11                IOMUX_PADCFG(IOMUXC_MUX_CTL_XSPI1_SS1_B_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_XSPI1_SS1_B_OFFSET)
#define IOMUXC_PAD_SD2_CD_B_USDHC2_CD_B                  IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_CD_B_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_CD_B_OFFSET)
#define IOMUXC_PAD_SD2_CD_B_NETC_TMR_1588_TRIG1          IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_CD_B_OFFSET, 0x1, IOMUXC_NETC_CMPLX_TMR_1588_TRIG1_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_SD2_CD_B_OFFSET)
#define IOMUXC_PAD_SD2_CD_B_I3C2_SCL                     IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_CD_B_OFFSET, 0x2, IOMUXC_I3C2_PIN_SCL_IN_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_SD2_CD_B_OFFSET)
#define IOMUXC_PAD_SD2_CD_B_FLEXIO1_FLEXIO00             IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_CD_B_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_0_OFFSET, 0x1, IOMUXC_PAD_CTL_SD2_CD_B_OFFSET)
#define IOMUXC_PAD_SD2_CD_B_GPIO3_IO00                   IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_CD_B_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_CD_B_OFFSET)
#define IOMUXC_PAD_SD2_CLK_USDHC2_CLK                    IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_CLK_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_CLK_OFFSET)
#define IOMUXC_PAD_SD2_CLK_NETC_TMR_1588_PP1             IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_CLK_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_CLK_OFFSET)
#define IOMUXC_PAD_SD2_CLK_I3C2_SDA                      IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_CLK_OFFSET, 0x2, IOMUXC_I3C2_PIN_SDA_IN_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_SD2_CLK_OFFSET)
#define IOMUXC_PAD_SD2_CLK_FLEXIO1_FLEXIO01              IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_CLK_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_1_OFFSET, 0x1, IOMUXC_PAD_CTL_SD2_CLK_OFFSET)
#define IOMUXC_PAD_SD2_CLK_GPIO3_IO01                    IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_CLK_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_CLK_OFFSET)
#define IOMUXC_PAD_SD2_CMD_USDHC2_CMD                    IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_CMD_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_CMD_OFFSET)
#define IOMUXC_PAD_SD2_CMD_NETC_TMR_1588_TRIG2           IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_CMD_OFFSET, 0x1, IOMUXC_NETC_CMPLX_TMR_1588_TRIG2_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_SD2_CMD_OFFSET)
#define IOMUXC_PAD_SD2_CMD_I3C2_PUR                      IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_CMD_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_CMD_OFFSET)
#define IOMUXC_PAD_SD2_CMD_I3C2_PUR_B                    IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_CMD_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_CMD_OFFSET)
#define IOMUXC_PAD_SD2_CMD_FLEXIO1_FLEXIO02              IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_CMD_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_2_OFFSET, 0x1, IOMUXC_PAD_CTL_SD2_CMD_OFFSET)
#define IOMUXC_PAD_SD2_CMD_GPIO3_IO02                    IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_CMD_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_CMD_OFFSET)
#define IOMUXC_PAD_SD2_DATA0_USDHC2_DATA0                IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_DATA0_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_DATA0_OFFSET)
#define IOMUXC_PAD_SD2_DATA0_NETC_TMR_1588_PP2           IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_DATA0_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_DATA0_OFFSET)
#define IOMUXC_PAD_SD2_DATA0_CAN2_TX                     IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_DATA0_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_DATA0_OFFSET)
#define IOMUXC_PAD_SD2_DATA0_FLEXIO1_FLEXIO03            IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_DATA0_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_3_OFFSET, 0x1, IOMUXC_PAD_CTL_SD2_DATA0_OFFSET)
#define IOMUXC_PAD_SD2_DATA0_GPIO3_IO03                  IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_DATA0_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_DATA0_OFFSET)
#define IOMUXC_PAD_SD2_DATA1_USDHC2_DATA1                IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_DATA1_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_DATA1_OFFSET)
#define IOMUXC_PAD_SD2_DATA1_NETC_TMR_1588_CLK           IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_DATA1_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_DATA1_OFFSET)
#define IOMUXC_PAD_SD2_DATA1_CAN2_RX                     IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_DATA1_OFFSET, 0x2, IOMUXC_CAN2_IPP_IND_CANRX_SELECT_INPUT_OFFSET, 0x3, IOMUXC_PAD_CTL_SD2_DATA1_OFFSET)
#define IOMUXC_PAD_SD2_DATA1_FLEXIO1_FLEXIO04            IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_DATA1_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_4_OFFSET, 0x1, IOMUXC_PAD_CTL_SD2_DATA1_OFFSET)
#define IOMUXC_PAD_SD2_DATA1_GPIO3_IO04                  IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_DATA1_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_DATA1_OFFSET)
#define IOMUXC_PAD_SD2_DATA2_USDHC2_DATA2                IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_DATA2_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_DATA2_OFFSET)
#define IOMUXC_PAD_SD2_DATA2_NETC_TMR_1588_PP3           IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_DATA2_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_DATA2_OFFSET)
#define IOMUXC_PAD_SD2_DATA2_MQS2_RIGHT                  IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_DATA2_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_DATA2_OFFSET)
#define IOMUXC_PAD_SD2_DATA2_FLEXIO1_FLEXIO05            IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_DATA2_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_5_OFFSET, 0x1, IOMUXC_PAD_CTL_SD2_DATA2_OFFSET)
#define IOMUXC_PAD_SD2_DATA2_GPIO3_IO05                  IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_DATA2_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_DATA2_OFFSET)
#define IOMUXC_PAD_SD2_DATA3_USDHC2_DATA3                IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_DATA3_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_DATA3_OFFSET)
#define IOMUXC_PAD_SD2_DATA3_LPTMR2_ALT1                 IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_DATA3_OFFSET, 0x1, IOMUXC_LPTMR2_IPP_IND_LPTIMER_SELECT_INPUT_0_OFFSET, 0x1, IOMUXC_PAD_CTL_SD2_DATA3_OFFSET)
#define IOMUXC_PAD_SD2_DATA3_MQS2_LEFT                   IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_DATA3_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_DATA3_OFFSET)
#define IOMUXC_PAD_SD2_DATA3_NETC_TMR_1588_ALARM1        IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_DATA3_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_DATA3_OFFSET)
#define IOMUXC_PAD_SD2_DATA3_FLEXIO1_FLEXIO06            IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_DATA3_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_6_OFFSET, 0x1, IOMUXC_PAD_CTL_SD2_DATA3_OFFSET)
#define IOMUXC_PAD_SD2_DATA3_GPIO3_IO06                  IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_DATA3_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_DATA3_OFFSET)
#define IOMUXC_PAD_SD2_RESET_B_USDHC2_RESET_B            IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_RESET_B_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_RESET_B_OFFSET)
#define IOMUXC_PAD_SD2_RESET_B_LPTMR2_ALT2               IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_RESET_B_OFFSET, 0x1, IOMUXC_LPTMR2_IPP_IND_LPTIMER_SELECT_INPUT_1_OFFSET, 0x1, IOMUXC_PAD_CTL_SD2_RESET_B_OFFSET)
#define IOMUXC_PAD_SD2_RESET_B_NETC_TMR_1588_GCLK        IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_RESET_B_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_RESET_B_OFFSET)
#define IOMUXC_PAD_SD2_RESET_B_FLEXIO1_FLEXIO07          IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_RESET_B_OFFSET, 0x4, IOMUXC_FLEXIO1_IPP_IND_FLEXIO_SELECT_INPUT_7_OFFSET, 0x1, IOMUXC_PAD_CTL_SD2_RESET_B_OFFSET)
#define IOMUXC_PAD_SD2_RESET_B_GPIO3_IO07                IOMUX_PADCFG(IOMUXC_MUX_CTL_SD2_RESET_B_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SD2_RESET_B_OFFSET)
#define IOMUXC_PAD_I2C1_SCL_LPI2C1_SCL                   IOMUX_PADCFG(IOMUXC_MUX_CTL_I2C1_SCL_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_I2C1_SCL_OFFSET)
#define IOMUXC_PAD_I2C1_SCL_I3C1_SCL                     IOMUX_PADCFG(IOMUXC_MUX_CTL_I2C1_SCL_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_I2C1_SCL_OFFSET)
#define IOMUXC_PAD_I2C1_SCL_LPUART1_DCD_B                IOMUX_PADCFG(IOMUXC_MUX_CTL_I2C1_SCL_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_I2C1_SCL_OFFSET)
#define IOMUXC_PAD_I2C1_SCL_TPM2_CH0                     IOMUX_PADCFG(IOMUXC_MUX_CTL_I2C1_SCL_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_I2C1_SCL_OFFSET)
#define IOMUXC_PAD_I2C1_SCL_UART_RX                      IOMUX_PADCFG(IOMUXC_MUX_CTL_I2C1_SCL_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_I2C1_SCL_OFFSET)
#define IOMUXC_PAD_I2C1_SCL_GPIO1_IO00                   IOMUX_PADCFG(IOMUXC_MUX_CTL_I2C1_SCL_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_I2C1_SCL_OFFSET)
#define IOMUXC_PAD_I2C1_SDA_LPI2C1_SDA                   IOMUX_PADCFG(IOMUXC_MUX_CTL_I2C1_SDA_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_I2C1_SDA_OFFSET)
#define IOMUXC_PAD_I2C1_SDA_I3C1_SDA                     IOMUX_PADCFG(IOMUXC_MUX_CTL_I2C1_SDA_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_I2C1_SDA_OFFSET)
#define IOMUXC_PAD_I2C1_SDA_LPUART1_RIN_B                IOMUX_PADCFG(IOMUXC_MUX_CTL_I2C1_SDA_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_I2C1_SDA_OFFSET)
#define IOMUXC_PAD_I2C1_SDA_TPM2_CH1                     IOMUX_PADCFG(IOMUXC_MUX_CTL_I2C1_SDA_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_I2C1_SDA_OFFSET)
#define IOMUXC_PAD_I2C1_SDA_UART_TX                      IOMUX_PADCFG(IOMUXC_MUX_CTL_I2C1_SDA_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_I2C1_SDA_OFFSET)
#define IOMUXC_PAD_I2C1_SDA_GPIO1_IO01                   IOMUX_PADCFG(IOMUXC_MUX_CTL_I2C1_SDA_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_I2C1_SDA_OFFSET)
#define IOMUXC_PAD_I2C2_SCL_LPI2C2_SCL                   IOMUX_PADCFG(IOMUXC_MUX_CTL_I2C2_SCL_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_I2C2_SCL_OFFSET)
#define IOMUXC_PAD_I2C2_SCL_I3C1_PUR                     IOMUX_PADCFG(IOMUXC_MUX_CTL_I2C2_SCL_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_I2C2_SCL_OFFSET)
#define IOMUXC_PAD_I2C2_SCL_LPUART2_DCD_B                IOMUX_PADCFG(IOMUXC_MUX_CTL_I2C2_SCL_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_I2C2_SCL_OFFSET)
#define IOMUXC_PAD_I2C2_SCL_TPM2_CH2                     IOMUX_PADCFG(IOMUXC_MUX_CTL_I2C2_SCL_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_I2C2_SCL_OFFSET)
#define IOMUXC_PAD_I2C2_SCL_SAI1_RX_SYNC                 IOMUX_PADCFG(IOMUXC_MUX_CTL_I2C2_SCL_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_I2C2_SCL_OFFSET)
#define IOMUXC_PAD_I2C2_SCL_GPIO1_IO02                   IOMUX_PADCFG(IOMUXC_MUX_CTL_I2C2_SCL_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_I2C2_SCL_OFFSET)
#define IOMUXC_PAD_I2C2_SCL_I3C1_PUR_B                   IOMUX_PADCFG(IOMUXC_MUX_CTL_I2C2_SCL_OFFSET, 0x6, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_I2C2_SCL_OFFSET)
#define IOMUXC_PAD_I2C2_SDA_LPI2C2_SDA                   IOMUX_PADCFG(IOMUXC_MUX_CTL_I2C2_SDA_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_I2C2_SDA_OFFSET)
#define IOMUXC_PAD_I2C2_SDA_LPUART2_RIN_B                IOMUX_PADCFG(IOMUXC_MUX_CTL_I2C2_SDA_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_I2C2_SDA_OFFSET)
#define IOMUXC_PAD_I2C2_SDA_TPM2_CH3                     IOMUX_PADCFG(IOMUXC_MUX_CTL_I2C2_SDA_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_I2C2_SDA_OFFSET)
#define IOMUXC_PAD_I2C2_SDA_SAI1_RX_BCLK                 IOMUX_PADCFG(IOMUXC_MUX_CTL_I2C2_SDA_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_I2C2_SDA_OFFSET)
#define IOMUXC_PAD_I2C2_SDA_GPIO1_IO03                   IOMUX_PADCFG(IOMUXC_MUX_CTL_I2C2_SDA_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_I2C2_SDA_OFFSET)
#define IOMUXC_PAD_UART1_RXD_LPUART1_RX                  IOMUX_PADCFG(IOMUXC_MUX_CTL_UART1_RXD_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_UART1_RXD_OFFSET)
#define IOMUXC_PAD_UART1_RXD_ELE_UART_RX                 IOMUX_PADCFG(IOMUXC_MUX_CTL_UART1_RXD_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_UART1_RXD_OFFSET)
#define IOMUXC_PAD_UART1_RXD_LPSPI2_SIN                  IOMUX_PADCFG(IOMUXC_MUX_CTL_UART1_RXD_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_UART1_RXD_OFFSET)
#define IOMUXC_PAD_UART1_RXD_TPM1_CH0                    IOMUX_PADCFG(IOMUXC_MUX_CTL_UART1_RXD_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_UART1_RXD_OFFSET)
#define IOMUXC_PAD_UART1_RXD_GPIO1_IO04                  IOMUX_PADCFG(IOMUXC_MUX_CTL_UART1_RXD_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_UART1_RXD_OFFSET)
#define IOMUXC_PAD_UART1_TXD_LPUART1_TX                  IOMUX_PADCFG(IOMUXC_MUX_CTL_UART1_TXD_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_UART1_TXD_OFFSET)
#define IOMUXC_PAD_UART1_TXD_ELE_UART_TX                 IOMUX_PADCFG(IOMUXC_MUX_CTL_UART1_TXD_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_UART1_TXD_OFFSET)
#define IOMUXC_PAD_UART1_TXD_LPSPI2_PCS0                 IOMUX_PADCFG(IOMUXC_MUX_CTL_UART1_TXD_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_UART1_TXD_OFFSET)
#define IOMUXC_PAD_UART1_TXD_TPM1_CH1                    IOMUX_PADCFG(IOMUXC_MUX_CTL_UART1_TXD_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_UART1_TXD_OFFSET)
#define IOMUXC_PAD_UART1_TXD_GPIO1_IO05                  IOMUX_PADCFG(IOMUXC_MUX_CTL_UART1_TXD_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_UART1_TXD_OFFSET)
#define IOMUXC_PAD_UART2_RXD_LPUART2_RX                  IOMUX_PADCFG(IOMUXC_MUX_CTL_UART2_RXD_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_UART2_RXD_OFFSET)
#define IOMUXC_PAD_UART2_RXD_LPUART1_CTS_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_UART2_RXD_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_UART2_RXD_OFFSET)
#define IOMUXC_PAD_UART2_RXD_LPSPI2_SOUT                 IOMUX_PADCFG(IOMUXC_MUX_CTL_UART2_RXD_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_UART2_RXD_OFFSET)
#define IOMUXC_PAD_UART2_RXD_TPM1_CH2                    IOMUX_PADCFG(IOMUXC_MUX_CTL_UART2_RXD_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_UART2_RXD_OFFSET)
#define IOMUXC_PAD_UART2_RXD_SAI1_MCLK                   IOMUX_PADCFG(IOMUXC_MUX_CTL_UART2_RXD_OFFSET, 0x4, IOMUXC_SAI1_IPP_IND_SAI_MCLK_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_UART2_RXD_OFFSET)
#define IOMUXC_PAD_UART2_RXD_GPIO1_IO06                  IOMUX_PADCFG(IOMUXC_MUX_CTL_UART2_RXD_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_UART2_RXD_OFFSET)
#define IOMUXC_PAD_UART2_TXD_LPUART2_TX                  IOMUX_PADCFG(IOMUXC_MUX_CTL_UART2_TXD_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_UART2_TXD_OFFSET)
#define IOMUXC_PAD_UART2_TXD_LPUART1_RTS_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_UART2_TXD_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_UART2_TXD_OFFSET)
#define IOMUXC_PAD_UART2_TXD_LPSPI2_SCK                  IOMUX_PADCFG(IOMUXC_MUX_CTL_UART2_TXD_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_UART2_TXD_OFFSET)
#define IOMUXC_PAD_UART2_TXD_TPM1_CH3                    IOMUX_PADCFG(IOMUXC_MUX_CTL_UART2_TXD_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_UART2_TXD_OFFSET)
#define IOMUXC_PAD_UART2_TXD_GPIO1_IO07                  IOMUX_PADCFG(IOMUXC_MUX_CTL_UART2_TXD_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_UART2_TXD_OFFSET)
#define IOMUXC_PAD_PDM_CLK_PDM_CLK                       IOMUX_PADCFG(IOMUXC_MUX_CTL_PDM_CLK_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_PDM_CLK_OFFSET)
#define IOMUXC_PAD_PDM_CLK_MQS1_LEFT                     IOMUX_PADCFG(IOMUXC_MUX_CTL_PDM_CLK_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_PDM_CLK_OFFSET)
#define IOMUXC_PAD_PDM_CLK_LPTMR1_ALT1                   IOMUX_PADCFG(IOMUXC_MUX_CTL_PDM_CLK_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_PDM_CLK_OFFSET)
#define IOMUXC_PAD_PDM_CLK_GPIO1_IO08                    IOMUX_PADCFG(IOMUXC_MUX_CTL_PDM_CLK_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_PDM_CLK_OFFSET)
#define IOMUXC_PAD_PDM_CLK_CAN1_TX                       IOMUX_PADCFG(IOMUXC_MUX_CTL_PDM_CLK_OFFSET, 0x6, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_PDM_CLK_OFFSET)
#define IOMUXC_PAD_PDM_BIT_STREAM0_PDM_BIT_STREAM00      IOMUX_PADCFG(IOMUXC_MUX_CTL_PDM_BIT_STREAM0_OFFSET, 0x0, IOMUXC_PDM_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_0_OFFSET, 0x0, IOMUXC_PAD_CTL_PDM_BIT_STREAM0_OFFSET)
#define IOMUXC_PAD_PDM_BIT_STREAM0_MQS1_RIGHT            IOMUX_PADCFG(IOMUXC_MUX_CTL_PDM_BIT_STREAM0_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_PDM_BIT_STREAM0_OFFSET)
#define IOMUXC_PAD_PDM_BIT_STREAM0_LPSPI1_PCS1           IOMUX_PADCFG(IOMUXC_MUX_CTL_PDM_BIT_STREAM0_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_PDM_BIT_STREAM0_OFFSET)
#define IOMUXC_PAD_PDM_BIT_STREAM0_TPM1_EXTCLK           IOMUX_PADCFG(IOMUXC_MUX_CTL_PDM_BIT_STREAM0_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_PDM_BIT_STREAM0_OFFSET)
#define IOMUXC_PAD_PDM_BIT_STREAM0_LPTMR1_ALT2           IOMUX_PADCFG(IOMUXC_MUX_CTL_PDM_BIT_STREAM0_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_PDM_BIT_STREAM0_OFFSET)
#define IOMUXC_PAD_PDM_BIT_STREAM0_GPIO1_IO09            IOMUX_PADCFG(IOMUXC_MUX_CTL_PDM_BIT_STREAM0_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_PDM_BIT_STREAM0_OFFSET)
#define IOMUXC_PAD_PDM_BIT_STREAM0_CAN1_RX               IOMUX_PADCFG(IOMUXC_MUX_CTL_PDM_BIT_STREAM0_OFFSET, 0x6, IOMUXC_CAN1_IPP_IND_CANRX_SELECT_INPUT_OFFSET, 0x0, IOMUXC_PAD_CTL_PDM_BIT_STREAM0_OFFSET)
#define IOMUXC_PAD_PDM_BIT_STREAM1_PDM_BIT_STREAM01      IOMUX_PADCFG(IOMUXC_MUX_CTL_PDM_BIT_STREAM1_OFFSET, 0x0, IOMUXC_PDM_IPP_IND_MIC_PDM_BITSTREAM_SELECT_INPUT_1_OFFSET, 0x0, IOMUXC_PAD_CTL_PDM_BIT_STREAM1_OFFSET)
#define IOMUXC_PAD_PDM_BIT_STREAM1_NMI_GLUE_NMI          IOMUX_PADCFG(IOMUXC_MUX_CTL_PDM_BIT_STREAM1_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_PDM_BIT_STREAM1_OFFSET)
#define IOMUXC_PAD_PDM_BIT_STREAM1_LPSPI2_PCS1           IOMUX_PADCFG(IOMUXC_MUX_CTL_PDM_BIT_STREAM1_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_PDM_BIT_STREAM1_OFFSET)
#define IOMUXC_PAD_PDM_BIT_STREAM1_TPM2_EXTCLK           IOMUX_PADCFG(IOMUXC_MUX_CTL_PDM_BIT_STREAM1_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_PDM_BIT_STREAM1_OFFSET)
#define IOMUXC_PAD_PDM_BIT_STREAM1_LPTMR1_ALT3           IOMUX_PADCFG(IOMUXC_MUX_CTL_PDM_BIT_STREAM1_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_PDM_BIT_STREAM1_OFFSET)
#define IOMUXC_PAD_PDM_BIT_STREAM1_GPIO1_IO10            IOMUX_PADCFG(IOMUXC_MUX_CTL_PDM_BIT_STREAM1_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_PDM_BIT_STREAM1_OFFSET)
#define IOMUXC_PAD_SAI1_TXFS_SAI1_TX_SYNC                IOMUX_PADCFG(IOMUXC_MUX_CTL_SAI1_TXFS_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SAI1_TXFS_OFFSET)
#define IOMUXC_PAD_SAI1_TXFS_SAI1_TX_DATA01              IOMUX_PADCFG(IOMUXC_MUX_CTL_SAI1_TXFS_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SAI1_TXFS_OFFSET)
#define IOMUXC_PAD_SAI1_TXFS_LPSPI1_PCS0                 IOMUX_PADCFG(IOMUXC_MUX_CTL_SAI1_TXFS_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SAI1_TXFS_OFFSET)
#define IOMUXC_PAD_SAI1_TXFS_LPUART2_DTR_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_SAI1_TXFS_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SAI1_TXFS_OFFSET)
#define IOMUXC_PAD_SAI1_TXFS_MQS1_LEFT                   IOMUX_PADCFG(IOMUXC_MUX_CTL_SAI1_TXFS_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SAI1_TXFS_OFFSET)
#define IOMUXC_PAD_SAI1_TXFS_GPIO1_IO11                  IOMUX_PADCFG(IOMUXC_MUX_CTL_SAI1_TXFS_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SAI1_TXFS_OFFSET)
#define IOMUXC_PAD_SAI1_TXC_SAI1_TX_BCLK                 IOMUX_PADCFG(IOMUXC_MUX_CTL_SAI1_TXC_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SAI1_TXC_OFFSET)
#define IOMUXC_PAD_SAI1_TXC_LPUART2_CTS_B                IOMUX_PADCFG(IOMUXC_MUX_CTL_SAI1_TXC_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SAI1_TXC_OFFSET)
#define IOMUXC_PAD_SAI1_TXC_LPSPI1_SIN                   IOMUX_PADCFG(IOMUXC_MUX_CTL_SAI1_TXC_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SAI1_TXC_OFFSET)
#define IOMUXC_PAD_SAI1_TXC_LPUART1_DSR_B                IOMUX_PADCFG(IOMUXC_MUX_CTL_SAI1_TXC_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SAI1_TXC_OFFSET)
#define IOMUXC_PAD_SAI1_TXC_CAN1_RX                      IOMUX_PADCFG(IOMUXC_MUX_CTL_SAI1_TXC_OFFSET, 0x4, IOMUXC_CAN1_IPP_IND_CANRX_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_SAI1_TXC_OFFSET)
#define IOMUXC_PAD_SAI1_TXC_GPIO1_IO12                   IOMUX_PADCFG(IOMUXC_MUX_CTL_SAI1_TXC_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SAI1_TXC_OFFSET)
#define IOMUXC_PAD_SAI1_TXD0_SAI1_TX_DATA00              IOMUX_PADCFG(IOMUXC_MUX_CTL_SAI1_TXD0_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SAI1_TXD0_OFFSET)
#define IOMUXC_PAD_SAI1_TXD0_LPUART2_RTS_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_SAI1_TXD0_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SAI1_TXD0_OFFSET)
#define IOMUXC_PAD_SAI1_TXD0_LPSPI1_SCK                  IOMUX_PADCFG(IOMUXC_MUX_CTL_SAI1_TXD0_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SAI1_TXD0_OFFSET)
#define IOMUXC_PAD_SAI1_TXD0_LPUART1_DTR_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_SAI1_TXD0_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SAI1_TXD0_OFFSET)
#define IOMUXC_PAD_SAI1_TXD0_CAN1_TX                     IOMUX_PADCFG(IOMUXC_MUX_CTL_SAI1_TXD0_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SAI1_TXD0_OFFSET)
#define IOMUXC_PAD_SAI1_TXD0_GPIO1_IO13                  IOMUX_PADCFG(IOMUXC_MUX_CTL_SAI1_TXD0_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SAI1_TXD0_OFFSET)
#define IOMUXC_PAD_SAI1_RXD0_SAI1_RX_DATA00              IOMUX_PADCFG(IOMUXC_MUX_CTL_SAI1_RXD0_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SAI1_RXD0_OFFSET)
#define IOMUXC_PAD_SAI1_RXD0_SAI1_MCLK                   IOMUX_PADCFG(IOMUXC_MUX_CTL_SAI1_RXD0_OFFSET, 0x1, IOMUXC_SAI1_IPP_IND_SAI_MCLK_SELECT_INPUT_OFFSET, 0x1, IOMUXC_PAD_CTL_SAI1_RXD0_OFFSET)
#define IOMUXC_PAD_SAI1_RXD0_LPSPI1_SOUT                 IOMUX_PADCFG(IOMUXC_MUX_CTL_SAI1_RXD0_OFFSET, 0x2, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SAI1_RXD0_OFFSET)
#define IOMUXC_PAD_SAI1_RXD0_LPUART2_DSR_B               IOMUX_PADCFG(IOMUXC_MUX_CTL_SAI1_RXD0_OFFSET, 0x3, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SAI1_RXD0_OFFSET)
#define IOMUXC_PAD_SAI1_RXD0_MQS1_RIGHT                  IOMUX_PADCFG(IOMUXC_MUX_CTL_SAI1_RXD0_OFFSET, 0x4, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SAI1_RXD0_OFFSET)
#define IOMUXC_PAD_SAI1_RXD0_GPIO1_IO14                  IOMUX_PADCFG(IOMUXC_MUX_CTL_SAI1_RXD0_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_SAI1_RXD0_OFFSET)
#define IOMUXC_PAD_WDOG_ANY_WDOG_ANY                     IOMUX_PADCFG(IOMUXC_MUX_CTL_WDOG_ANY_OFFSET, 0x0, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_WDOG_ANY_OFFSET)
#define IOMUXC_PAD_WDOG_ANY_FCCU_EOUT1                   IOMUX_PADCFG(IOMUXC_MUX_CTL_WDOG_ANY_OFFSET, 0x1, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_WDOG_ANY_OFFSET)
#define IOMUXC_PAD_WDOG_ANY_GPIO1_IO15                   IOMUX_PADCFG(IOMUXC_MUX_CTL_WDOG_ANY_OFFSET, 0x5, IOMUXC_REGISTER_NOT_AVAILABLE, 0x0, IOMUXC_PAD_CTL_WDOG_ANY_OFFSET)
