/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.ArtifactCoordinates;
import org.apache.maven.api.DownloadedArtifact;
import org.apache.maven.api.Repository;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.cache.BatchRequestException;
import org.apache.maven.api.cache.MavenExecutionException;
import org.apache.maven.api.cache.RequestResult;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.ArtifactResolver;
import org.apache.maven.api.services.ArtifactResolverException;
import org.apache.maven.api.services.ArtifactResolverRequest;
import org.apache.maven.api.services.ArtifactResolverResult;
import org.apache.maven.api.services.Request;
import org.apache.maven.api.services.RequestTrace;
import org.apache.maven.api.services.Result;
import org.apache.maven.impl.InternalSession;
import org.apache.maven.impl.RequestTraceHelper;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.transfer.ArtifactNotFoundException;

@Named
@Singleton
public class DefaultArtifactResolver
implements ArtifactResolver {
    public ArtifactResolverResult resolve(ArtifactResolverRequest request) throws ArtifactResolverException, IllegalArgumentException {
        Objects.requireNonNull(request, "request");
        InternalSession session = InternalSession.from((Session)request.getSession());
        return session.request(request, this::doResolve);
    }

    protected ArtifactResolverResult doResolve(ArtifactResolverRequest request) {
        InternalSession session = InternalSession.from((Session)request.getSession());
        RequestTraceHelper.ResolverTrace trace = RequestTraceHelper.enter(session, request);
        try {
            List<RemoteRepository> repositories = session.toRepositories(request.getRepositories() != null ? request.getRepositories() : session.getRemoteRepositories());
            ArrayList<ResolverRequest> requests = new ArrayList<ResolverRequest>();
            for (ArtifactCoordinates coords : request.getCoordinates()) {
                ArtifactRequest req = new ArtifactRequest();
                req.setRepositories(repositories);
                req.setArtifact(session.toArtifact(coords));
                req.setRequestContext(trace.context());
                req.setTrace(trace.trace());
                requests.add(new ResolverRequest(session, trace.mvnTrace(), req));
            }
            List results = session.requests(requests, list -> {
                try {
                    List<ArtifactRequest> resolverRequests = list.stream().map(ResolverRequest::request).toList();
                    List resolverResults = session.getRepositorySystem().resolveArtifacts(session.getSession(), resolverRequests);
                    ArrayList<ResolverResult> res = new ArrayList<ResolverResult>(resolverResults.size());
                    for (int i = 0; i < resolverResults.size(); ++i) {
                        res.add(new ResolverResult((ResolverRequest)list.get(i), (ArtifactResult)resolverResults.get(i)));
                    }
                    return res;
                }
                catch (ArtifactResolutionException e) {
                    throw new MavenExecutionException((Throwable)e);
                }
            });
            ArtifactResolverResult artifactResolverResult = this.toResult(request, results.stream());
            return artifactResolverResult;
        }
        catch (BatchRequestException e) {
            Object message = e.getResults().size() == 1 ? ((RequestResult)e.getResults().iterator().next()).error().getMessage() : "Unable to resolve artifacts: " + e.getMessage();
            throw new ArtifactResolverException((String)message, (Exception)((Object)e), this.toResult(request, e));
        }
        finally {
            RequestTraceHelper.exit(trace);
        }
    }

    ArtifactResolverResult toResult(ArtifactResolverRequest request, BatchRequestException exception) {
        return this.toResult(request, exception.getResults().stream().map(rr -> {
            if (rr.result() != null) {
                return rr.result();
            }
            if (rr.error() != null) {
                return new ResolverResult(null, ((ArtifactResolutionException)rr.error()).getResult());
            }
            throw new IllegalStateException("Unexpected result: " + String.valueOf(rr));
        }).map(ResolverResult.class::cast));
    }

    ArtifactResolverResult toResult(ArtifactResolverRequest request, Stream<ResolverResult> results) {
        InternalSession session = InternalSession.from((Session)request.getSession());
        Map<ArtifactCoordinates, ArtifactResolverResult.ResultItem> items = results.map(resolverResult -> {
            ArtifactResult result = resolverResult.result();
            DownloadedArtifact artifact = result.getArtifact() != null ? session.getArtifact(DownloadedArtifact.class, result.getArtifact()) : null;
            ArtifactCoordinates coordinates = session.getArtifact(result.getRequest().getArtifact()).toCoordinates();
            Repository repository = result.getRepository() != null ? session.getRepository(result.getRepository()) : null;
            Map<Repository, List<Exception>> mappedExceptions = result.getMappedExceptions().entrySet().stream().collect(Collectors.toMap(entry -> session.getRepository((ArtifactRepository)entry.getKey()), Map.Entry::getValue));
            return new DefaultArtifactResolverResultItem(coordinates, artifact, mappedExceptions, repository, result.getArtifact() != null ? result.getArtifact().getPath() : null);
        }).collect(Collectors.toMap(DefaultArtifactResolverResultItem::coordinates, Function.identity()));
        return new DefaultArtifactResolverResult(request, items);
    }

    record ResolverRequest(Session session, RequestTrace trace, ArtifactRequest request) implements Request<Session>
    {
        @Nonnull
        public Session getSession() {
            return this.session;
        }

        @Nullable
        public RequestTrace getTrace() {
            return this.trace;
        }
    }

    record ResolverResult(ResolverRequest request, ArtifactResult result) implements Result<ResolverRequest>
    {
        @Nonnull
        public ResolverRequest getRequest() {
            return this.request;
        }
    }

    record DefaultArtifactResolverResult(ArtifactResolverRequest request, Map<ArtifactCoordinates, ArtifactResolverResult.ResultItem> results) implements ArtifactResolverResult
    {
        DefaultArtifactResolverResult(ArtifactResolverRequest request, Map<ArtifactCoordinates, ArtifactResolverResult.ResultItem> results) {
            this.request = request;
            this.results = Map.copyOf(results);
        }

        @Nonnull
        public ArtifactResolverRequest getRequest() {
            return this.request;
        }

        @Nonnull
        public Collection<DownloadedArtifact> getArtifacts() {
            return this.results.values().stream().map(ArtifactResolverResult.ResultItem::getArtifact).collect(Collectors.toList());
        }

        public Path getPath(@Nonnull Artifact artifact) {
            ArtifactResolverResult.ResultItem resultItem = this.results.get(artifact.toCoordinates());
            return resultItem != null ? resultItem.getPath() : null;
        }

        @Nonnull
        public Map<? extends ArtifactCoordinates, ArtifactResolverResult.ResultItem> getResults() {
            return this.results;
        }

        public ArtifactResolverResult.ResultItem getResult(ArtifactCoordinates coordinates) {
            return this.results.get(coordinates);
        }
    }

    record DefaultArtifactResolverResultItem(@Nonnull ArtifactCoordinates coordinates, @Nullable DownloadedArtifact artifact, @Nonnull Map<Repository, List<Exception>> exceptions, @Nullable Repository repository, Path path) implements ArtifactResolverResult.ResultItem
    {
        public ArtifactCoordinates getCoordinates() {
            return this.coordinates;
        }

        public DownloadedArtifact getArtifact() {
            return this.artifact;
        }

        public Map<Repository, List<Exception>> getExceptions() {
            return this.exceptions;
        }

        public Repository getRepository() {
            return this.repository;
        }

        public Path getPath() {
            return this.path;
        }

        public boolean isResolved() {
            return this.getPath() != null;
        }

        public boolean isMissing() {
            return this.exceptions.values().stream().flatMap(Collection::stream).allMatch(e -> e instanceof ArtifactNotFoundException) && !this.isResolved();
        }
    }
}

