/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.transformation.impl;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.services.ModelBuilderException;
import org.apache.maven.internal.transformation.PomArtifactTransformer;
import org.apache.maven.model.v4.MavenStaxReader;
import org.apache.maven.model.v4.MavenStaxWriter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.installation.InstallRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class TransformerSupport
implements PomArtifactTransformer {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String NAMESPACE_FORMAT = "http://maven.apache.org/POM/%s";
    protected static final String SCHEMA_LOCATION_FORMAT = "https://maven.apache.org/xsd/maven-%s.xsd";

    TransformerSupport() {
    }

    @Override
    public InstallRequest remapInstallArtifacts(RepositorySystemSession session, InstallRequest request) {
        return request;
    }

    @Override
    public DeployRequest remapDeployArtifacts(RepositorySystemSession session, DeployRequest request) {
        return request;
    }

    @Override
    public void injectTransformedArtifacts(RepositorySystemSession session, MavenProject project) throws IOException {
    }

    @Override
    public void transform(MavenProject project, RepositorySystemSession session, Path src, Path tgt) throws ModelBuilderException, XMLStreamException, IOException {
        throw new IllegalStateException("This transformer does not use this call.");
    }

    protected Model read(Path src) throws IOException, XMLStreamException {
        try (InputStream is = Files.newInputStream(src, new OpenOption[0]);){
            Model model = new MavenStaxReader().read(is, false, null);
            return model;
        }
    }

    protected void write(Model model, Path dest) throws IOException, XMLStreamException {
        String version = model.getModelVersion();
        Files.createDirectories(dest.getParent(), new FileAttribute[0]);
        try (BufferedWriter w = Files.newBufferedWriter(dest, new OpenOption[0]);){
            MavenStaxWriter writer = new MavenStaxWriter();
            writer.setNamespace(String.format(NAMESPACE_FORMAT, version));
            writer.setSchemaLocation(String.format(SCHEMA_LOCATION_FORMAT, version));
            writer.setAddLocationInformation(false);
            writer.write((Writer)w, model);
        }
    }
}

