/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;

public final class ExHyperlinkAtom
extends RecordAtom {
    private static final int MAX_RECORD_LENGTH = 100000;
    private byte[] _header = new byte[8];
    private byte[] _data;

    protected ExHyperlinkAtom() {
        this._data = new byte[4];
        LittleEndian.putShort((byte[])this._header, (int)2, (short)((short)this.getRecordType()));
        LittleEndian.putInt((byte[])this._header, (int)4, (int)this._data.length);
    }

    protected ExHyperlinkAtom(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._data = IOUtils.safelyAllocate((long)(len - 8), (int)100000);
        System.arraycopy(source, start + 8, this._data, 0, len - 8);
        if (this._data.length < 4) {
            throw new IllegalArgumentException("The length of the data for a ExHyperlinkAtom must be at least 4 bytes, but was only " + this._data.length);
        }
    }

    public int getNumber() {
        return LittleEndian.getInt((byte[])this._data, (int)0);
    }

    public void setNumber(int number) {
        LittleEndian.putInt((byte[])this._data, (int)0, (int)number);
    }

    @Override
    public long getRecordType() {
        return RecordTypes.ExHyperlinkAtom.typeID;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._data);
    }

    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties((String)"number", this::getNumber);
    }
}

