/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.crypt.impl.office;

import com.healthmarketscience.jackcess.crypt.InvalidCryptoConfigurationException;
import com.healthmarketscience.jackcess.crypt.impl.office.EncryptionHeader;
import com.healthmarketscience.jackcess.impl.ByteUtil;
import java.nio.ByteBuffer;

public class EncryptionVerifier {
    private static final int SALT_SIZE = 16;
    private static final int ENC_VERIFIER_SIZE = 16;
    private final int _saltSize;
    private final byte[] _salt;
    private final byte[] _encryptedVerifier;
    private final int _verifierHashSize;
    private final byte[] _encryptedVerifierHash;

    public EncryptionVerifier(ByteBuffer buffer, EncryptionHeader.CryptoAlgorithm cryptoAlg) {
        this._saltSize = buffer.getInt();
        if (this._saltSize != 16) {
            throw new InvalidCryptoConfigurationException("salt size " + this._saltSize + " must be " + 16);
        }
        this._salt = ByteUtil.getBytes((ByteBuffer)buffer, (int)this._saltSize);
        this._encryptedVerifier = ByteUtil.getBytes((ByteBuffer)buffer, (int)16);
        this._verifierHashSize = buffer.getInt();
        this._encryptedVerifierHash = ByteUtil.getBytes((ByteBuffer)buffer, (int)cryptoAlg.getEncryptedVerifierHashLen());
    }

    public int getSaltSize() {
        return this._saltSize;
    }

    public byte[] getSalt() {
        return this._salt;
    }

    public byte[] getEncryptedVerifier() {
        return this._encryptedVerifier;
    }

    public int getVerifierHashSize() {
        return this._verifierHashSize;
    }

    public byte[] getEncryptedVerifierHash() {
        return this._encryptedVerifierHash;
    }
}

