/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.crypt.impl;

import java.util.LinkedHashMap;
import java.util.Map;

public abstract class KeyCache<K> {
    private static final int MAX_KEY_CACHE_SIZE = 5;
    private final KeyMap<K> _map = new KeyMap();

    protected KeyCache() {
    }

    public K get(int pageNumber) {
        Integer pageNumKey = pageNumber;
        Object key = this._map.get(pageNumKey);
        if (key == null) {
            key = this.computeKey(pageNumber);
            this._map.put(pageNumKey, key);
        }
        return (K)key;
    }

    protected abstract K computeKey(int var1);

    private static final class KeyMap<K>
    extends LinkedHashMap<Integer, K> {
        private static final long serialVersionUID = 0L;

        private KeyMap() {
            super(16, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, K> eldest) {
            return this.size() > 5;
        }
    }
}

