/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.thredds;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import thredds.catalog.DataFormatType;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvMetadata;
import thredds.catalog.InvProperty;
import thredds.catalog.MetadataType;
import thredds.catalog.ServiceType;
import ucar.nc2.Attribute;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.stream.CdmRemote;
import ucar.nc2.stream.CdmrFeatureDataset;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.unidata.util.StringUtil2;

public class ThreddsDataFactory {
    public static final String PROTOCOL = "thredds";
    public static final String SCHEME = "thredds:";
    private static boolean preferCdm = true;
    private static boolean debugOpen = false;
    private static boolean debugTypeOpen = false;
    private static boolean enhanceMode = false;

    public static void setPreferCdm(boolean prefer) {
        preferCdm = prefer;
    }

    public static void setDebugFlags(DebugFlags debugFlag) {
        debugOpen = debugFlag.isSet("thredds/debugOpen");
        debugTypeOpen = debugFlag.isSet("thredds/openDatatype");
    }

    public Result openFeatureDataset(String urlString, CancelTask task) throws IOException {
        Result result = new Result();
        InvDataset invDataset = this.processLocation(urlString, task, result);
        if (result.fatalError) {
            return result;
        }
        return this.openFeatureDataset(null, invDataset, task, result);
    }

    public Result openFeatureDataset(FeatureType wantFeatureType, String urlString, CancelTask task) throws IOException {
        Result result = new Result();
        InvDataset invDataset = this.processLocation(urlString, task, result);
        if (result.fatalError || invDataset == null) {
            return result;
        }
        return this.openFeatureDataset(wantFeatureType, invDataset, task, result);
    }

    private InvDataset processLocation(String location, CancelTask task, Result result) {
        StringBuilder buff;
        int pos;
        location = location.trim();
        if ((location = StringUtil2.replace(location, '\\', "/")).startsWith(SCHEME)) {
            location = location.substring(8);
        }
        if (location.startsWith("resolve:")) {
            location = location.substring(8);
            return this.openResolver(location, task, result);
        }
        if (!location.startsWith("http:") && !location.startsWith("file:")) {
            location = "http:" + location;
        }
        if ((pos = location.indexOf(35)) < 0) {
            result.fatalError = true;
            result.errLog.format("Must have the form catalog.xml#datasetId%n", new Object[0]);
            return null;
        }
        InvCatalogFactory catFactory = new InvCatalogFactory("", false);
        String catalogLocation = location.substring(0, pos);
        InvCatalogImpl catalog = catFactory.readXML(catalogLocation);
        if (!catalog.check(buff = new StringBuilder())) {
            result.errLog.format("Invalid catalog from Resolver <%s>%n%s%n", catalogLocation, buff.toString());
            result.fatalError = true;
            return null;
        }
        String datasetId = location.substring(pos + 1);
        InvDataset invDataset = catalog.findDatasetByID(datasetId);
        if (invDataset == null) {
            result.fatalError = true;
            result.errLog.format("Could not find dataset %s in %s %n", datasetId, catalogLocation);
            return null;
        }
        return invDataset;
    }

    public Result openFeatureDataset(InvDataset invDataset, CancelTask task) throws IOException {
        return this.openFeatureDataset(null, invDataset, task, new Result());
    }

    public Result openFeatureDataset(FeatureType wantFeatureType, InvDataset invDataset, CancelTask task, Result result) throws IOException {
        InvAccess access;
        result.featureType = invDataset.getDataType();
        if (result.featureType == null) {
            result.featureType = wantFeatureType;
        }
        if (result.featureType != null && result.featureType.isPointFeatureType() && (access = this.findAccessByServiceType(invDataset.getAccess(), ServiceType.CdmrFeature)) != null) {
            return this.openFeatureDataset(result.featureType, access, task, result);
        }
        if (result.featureType == FeatureType.IMAGE) {
            access = this.getImageAccess(invDataset, task, result);
            if (access != null) {
                return this.openFeatureDataset(result.featureType, access, task, result);
            }
            result.fatalError = true;
            return result;
        }
        InvAccess qc = invDataset.getAccess(ServiceType.QC);
        if (qc != null) {
            if (result.featureType == FeatureType.STATION) {
                result.featureDataset = null;
                result.fatalError = result.featureDataset == null;
            } else {
                result.errLog.format("DQC must be station DQC, dataset = %s %n", invDataset.getName());
                result.fatalError = true;
            }
            return result;
        }
        NetcdfDataset ncd = this.openDataset(invDataset, true, task, result);
        if (null != ncd) {
            result.featureDataset = FeatureDatasetFactoryManager.wrap(result.featureType, ncd, task, result.errLog);
        }
        if (null == result.featureDataset) {
            result.fatalError = true;
        } else {
            result.location = result.featureDataset.getLocation();
            if (result.featureType == null && result.featureDataset != null) {
                result.featureType = result.featureDataset.getFeatureType();
            }
        }
        return result;
    }

    public Result openFeatureDataset(InvAccess access, CancelTask task) throws IOException {
        InvDataset invDataset = access.getDataset();
        Result result = new Result();
        if (invDataset.getDataType() == null) {
            result.errLog.format("InvDatasert must specify a FeatureType%n", new Object[0]);
            result.fatalError = true;
            return result;
        }
        return this.openFeatureDataset(invDataset.getDataType(), access, task, result);
    }

    private Result openFeatureDataset(FeatureType wantFeatureType, InvAccess access, CancelTask task, Result result) throws IOException {
        result.featureType = wantFeatureType;
        result.accessUsed = access;
        if (result.featureType == FeatureType.IMAGE) {
            result.location = result.imageURL = access.getStandardUrlName();
            return result;
        }
        if (access.getService().getServiceType() == ServiceType.CdmrFeature) {
            result.featureDataset = CdmrFeatureDataset.factory(wantFeatureType, access.getStandardUrlName());
        } else {
            NetcdfDataset ncd = this.openDataset(access, true, task, result);
            if (null != ncd) {
                result.featureDataset = FeatureDatasetFactoryManager.wrap(result.featureType, ncd, task, result.errLog);
            }
        }
        if (null == result.featureDataset) {
            result.fatalError = true;
        } else {
            result.location = result.featureDataset.getLocation();
            if (result.featureType == null && result.featureDataset != null) {
                result.featureType = result.featureDataset.getFeatureType();
            }
        }
        return result;
    }

    public NetcdfDataset openDataset(String location, boolean acquire, CancelTask task, Formatter log) throws IOException {
        Result result = new Result();
        InvDataset invDataset = this.processLocation(location, task, result);
        if (result.fatalError || invDataset == null) {
            if (log != null) {
                log.format("%s", result.errLog);
            }
            return null;
        }
        return this.openDataset(invDataset, acquire, task, result);
    }

    public NetcdfDataset openDataset(InvDataset invDataset, boolean acquire, CancelTask task, Formatter log) throws IOException {
        Result result = new Result();
        NetcdfDataset ncd = this.openDataset(invDataset, acquire, task, result);
        if (log != null) {
            log.format("%s", result.errLog);
        }
        return result.fatalError ? null : ncd;
    }

    private NetcdfDataset openDataset(InvDataset invDataset, boolean acquire, CancelTask task, Result result) throws IOException {
        IOException saveException = null;
        ArrayList<InvAccess> accessList = new ArrayList<InvAccess>(invDataset.getAccess());
        while (accessList.size() > 0) {
            NetcdfDataset ds;
            InvAccess access = this.chooseDatasetAccess(accessList);
            if (access == null) {
                result.errLog.format("No access that could be used in dataset %s %n", invDataset);
                if (saveException != null) {
                    throw saveException;
                }
                return null;
            }
            String datasetLocation = access.getStandardUrlName();
            ServiceType serviceType = access.getService().getServiceType();
            if (debugOpen) {
                System.out.println("ThreddsDataset.openDataset try " + datasetLocation + " " + serviceType);
            }
            if (serviceType == ServiceType.RESOLVER) {
                InvDatasetImpl rds = this.openResolver(datasetLocation, task, result);
                if (rds == null) {
                    return null;
                }
                accessList = new ArrayList<InvAccess>(rds.getAccess());
                continue;
            }
            try {
                ds = this.openDataset(access, acquire, task, result);
            }
            catch (IOException e) {
                result.errLog.format("Cant open %s %n err=%s%n", datasetLocation, e.getMessage());
                if (debugOpen) {
                    System.out.println("Cant open= " + datasetLocation + " " + serviceType);
                    e.printStackTrace();
                }
                accessList.remove(access);
                saveException = e;
                continue;
            }
            result.accessUsed = access;
            return ds;
        }
        if (saveException != null) {
            throw saveException;
        }
        return null;
    }

    public NetcdfDataset openDataset(InvAccess access, boolean acquire, CancelTask task, Formatter log) throws IOException {
        Result result = new Result();
        NetcdfDataset ncd = this.openDataset(access, acquire, task, result);
        if (log != null) {
            log.format("%s", result.errLog);
        }
        return result.fatalError ? null : ncd;
    }

    private NetcdfDataset openDataset(InvAccess access, boolean acquire, CancelTask task, Result result) throws IOException {
        NetcdfDataset ds;
        String curl;
        InvDataset invDataset = access.getDataset();
        String datasetId = invDataset.getID();
        String title = invDataset.getName();
        String datasetLocation = access.getStandardUrlName();
        ServiceType serviceType = access.getService().getServiceType();
        if (debugOpen) {
            System.out.println("ThreddsDataset.openDataset= " + datasetLocation);
        }
        if (serviceType == ServiceType.RESOLVER) {
            InvDatasetImpl rds = this.openResolver(datasetLocation, task, result);
            if (rds == null) {
                return null;
            }
            return this.openDataset((InvDataset)rds, acquire, task, result);
        }
        String prefix = null;
        if (serviceType == ServiceType.OPENDAP || serviceType == ServiceType.DODS) {
            prefix = "dods:";
        } else if (serviceType == ServiceType.DAP4) {
            prefix = "dap4:";
        }
        if (prefix != null) {
            curl = datasetLocation;
            if (curl.startsWith("http:")) {
                curl = prefix + datasetLocation.substring(5);
            } else if (curl.startsWith("https:")) {
                curl = prefix + curl.substring(6);
            }
            ds = acquire ? NetcdfDataset.acquireDataset(curl, enhanceMode, task) : NetcdfDataset.openDataset(curl, enhanceMode, task);
        } else if (serviceType == ServiceType.CdmRemote) {
            curl = CdmRemote.canonicalURL(datasetLocation);
            ds = acquire ? NetcdfDataset.acquireDataset(curl, enhanceMode, task) : NetcdfDataset.openDataset(curl, enhanceMode, task);
        } else if (serviceType == ServiceType.HTTP || serviceType == ServiceType.HTTPServer) {
            curl = datasetLocation.startsWith("http:") ? "nodods:" + datasetLocation.substring(5) : datasetLocation;
            ds = acquire ? NetcdfDataset.acquireDataset(curl, enhanceMode, task) : NetcdfDataset.openDataset(curl, enhanceMode, task);
        } else {
            ds = acquire ? NetcdfDataset.acquireDataset(datasetLocation, enhanceMode, task) : NetcdfDataset.openDataset(datasetLocation, enhanceMode, task);
        }
        result.accessUsed = access;
        if (ds == null) {
            return null;
        }
        ds.setId(datasetId);
        ds.setTitle(title);
        ThreddsDataFactory.annotate(invDataset, ds);
        List<InvMetadata> list = invDataset.getMetadata(MetadataType.NcML);
        if (list.size() > 0) {
            InvMetadata ncmlMetadata = list.get(0);
            NcMLReader.wrapNcML(ds, ncmlMetadata.getXlinkHref(), null);
        }
        return ds;
    }

    public InvAccess chooseDatasetAccess(List<InvAccess> accessList) {
        if (accessList.size() == 0) {
            return null;
        }
        InvAccess access = this.findAccessByServiceType(accessList, ServiceType.CdmRemote);
        if (access == null) {
            access = this.findAccessByServiceType(accessList, ServiceType.DODS);
        }
        if (access == null) {
            access = this.findAccessByServiceType(accessList, ServiceType.OPENDAP);
        }
        if (access == null) {
            access = this.findAccessByServiceType(accessList, ServiceType.DAP4);
        }
        if (access == null) {
            access = this.findAccessByServiceType(accessList, ServiceType.FILE);
        }
        if (access == null) {
            access = this.findAccessByServiceType(accessList, ServiceType.NETCDF);
        }
        if (access == null) {
            DataFormatType format;
            InvAccess tryAccess = this.findAccessByServiceType(accessList, ServiceType.HTTPServer);
            if (tryAccess == null) {
                tryAccess = this.findAccessByServiceType(accessList, ServiceType.HTTP);
            }
            if (tryAccess != null && (DataFormatType.BUFR == (format = tryAccess.getDataFormatType()) || DataFormatType.GINI == format || DataFormatType.GRIB1 == format || DataFormatType.GRIB2 == format || DataFormatType.HDF5 == format || DataFormatType.NCML == format || DataFormatType.NETCDF == format || DataFormatType.NEXRAD2 == format || DataFormatType.NIDS == format)) {
                access = tryAccess;
            }
        }
        if (access == null) {
            access = this.findAccessByServiceType(accessList, ServiceType.ADDE);
        }
        if (access == null) {
            access = this.findAccessByServiceType(accessList, ServiceType.RESOLVER);
        }
        return access;
    }

    private InvDatasetImpl openResolver(String urlString, CancelTask task, Result result) {
        InvCatalogFactory catFactory = new InvCatalogFactory("", false);
        InvCatalogImpl catalog = catFactory.readXML(urlString);
        if (catalog == null) {
            result.errLog.format("Couldnt open Resolver %s %n ", urlString);
            return null;
        }
        StringBuilder buff = new StringBuilder();
        if (!catalog.check(buff)) {
            result.errLog.format("Invalid catalog from Resolver <%s>%n%s%n", urlString, buff.toString());
            result.fatalError = true;
            return null;
        }
        InvDatasetImpl top = catalog.getDataset();
        if (top.hasAccess()) {
            return top;
        }
        List<InvDataset> datasets = top.getDatasets();
        return (InvDatasetImpl)datasets.get(0);
    }

    public static void annotate(InvDataset ds, NetcdfDataset ncDataset) {
        ncDataset.setTitle(ds.getName());
        ncDataset.setId(ds.getID());
        for (InvProperty p : ds.getProperties()) {
            String name = p.getName();
            if (null != ncDataset.findGlobalAttribute(name)) continue;
            ncDataset.addAttribute(null, new Attribute(name, p.getValue()));
        }
        ncDataset.finish();
    }

    private InvAccess getImageAccess(InvDataset invDataset, CancelTask task, Result result) {
        ArrayList<InvAccess> accessList = new ArrayList<InvAccess>(invDataset.getAccess());
        while (accessList.size() > 0) {
            InvAccess access = this.chooseImageAccess(accessList);
            if (access != null) {
                return access;
            }
            access = invDataset.getAccess(ServiceType.RESOLVER);
            if (access == null) {
                result.errLog.format("No access that could be used for Image Type %s %n", invDataset);
                return null;
            }
            String datasetLocation = access.getStandardUrlName();
            InvDatasetImpl rds = this.openResolver(datasetLocation, task, result);
            if (rds == null) {
                return null;
            }
            accessList = new ArrayList<InvAccess>(invDataset.getAccess());
        }
        return null;
    }

    private InvAccess chooseImageAccess(List<InvAccess> accessList) {
        String datasetLocation;
        InvAccess access = this.findAccessByDataFormatType(accessList, DataFormatType.JPEG);
        if (access != null) {
            return access;
        }
        access = this.findAccessByDataFormatType(accessList, DataFormatType.GIF);
        if (access != null) {
            return access;
        }
        access = this.findAccessByDataFormatType(accessList, DataFormatType.TIFF);
        if (access != null) {
            return access;
        }
        access = this.findAccessByServiceType(accessList, ServiceType.ADDE);
        if (access != null && (datasetLocation = access.getStandardUrlName()).indexOf("image") > 0) {
            return access;
        }
        return access;
    }

    private InvAccess findAccessByServiceType(List<InvAccess> accessList, ServiceType type) {
        for (InvAccess a : accessList) {
            if (!type.toString().equalsIgnoreCase(a.getService().getServiceType().toString())) continue;
            return a;
        }
        return null;
    }

    private InvAccess findAccessByDataFormatType(List<InvAccess> accessList, DataFormatType type) {
        for (InvAccess a : accessList) {
            if (!type.toString().equalsIgnoreCase(a.getDataFormatType().toString())) continue;
            return a;
        }
        return null;
    }

    public static class Result {
        public boolean fatalError;
        public Formatter errLog = new Formatter();
        public FeatureType featureType;
        public FeatureDataset featureDataset;
        public String imageURL;
        public String location;
        public InvAccess accessUsed;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Result");
            sb.append("{fatalError=").append(this.fatalError);
            sb.append(", errLog=").append(this.errLog);
            sb.append(", featureType=").append((Object)this.featureType);
            sb.append(", featureDataset=").append(this.featureDataset);
            sb.append(", imageURL='").append(this.imageURL).append('\'');
            sb.append(", location='").append(this.location).append('\'');
            sb.append(", accessUsed=").append(this.accessUsed);
            sb.append('}');
            return sb.toString();
        }
    }
}

