/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Provider;
import javax.mail.Service;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.URLName;
import org.apache.geronimo.mail.MailProviderRegistry;
import org.apache.geronimo.osgi.locator.ProviderLocator;

public final class Session {
    private static final Class[] PARAM_TYPES = new Class[]{Session.class, URLName.class};
    private static final WeakHashMap addressMapsByClassLoader = new WeakHashMap();
    private static Session DEFAULT_SESSION;
    private Map passwordAuthentications = new HashMap();
    private final Properties properties;
    private final Authenticator authenticator;
    private boolean debug;
    private PrintStream debugOut = System.out;
    private static final WeakHashMap providersByClassLoader;

    private Session(Properties properties, Authenticator authenticator) {
        this.properties = properties;
        this.authenticator = authenticator;
        this.debug = Boolean.valueOf(properties.getProperty("mail.debug"));
    }

    public static Session getInstance(Properties properties, Authenticator authenticator) {
        if (properties != null) {
            properties = (Properties)properties.clone();
        }
        return new Session(properties, authenticator);
    }

    public static Session getInstance(Properties properties) {
        return Session.getInstance(properties, null);
    }

    public static synchronized Session getDefaultInstance(Properties properties) {
        return Session.getDefaultInstance(properties, null);
    }

    public static synchronized Session getDefaultInstance(Properties properties, Authenticator authenticator) {
        if (DEFAULT_SESSION == null) {
            DEFAULT_SESSION = Session.getInstance(properties, authenticator);
        } else if (authenticator != Session.DEFAULT_SESSION.authenticator && (authenticator == null || Session.DEFAULT_SESSION.authenticator == null || authenticator.getClass().getClassLoader() != Session.DEFAULT_SESSION.authenticator.getClass().getClassLoader())) {
            throw new SecurityException();
        }
        return DEFAULT_SESSION;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebugOut(PrintStream out) {
        this.debugOut = out == null ? System.out : out;
    }

    public PrintStream getDebugOut() {
        return this.debugOut;
    }

    public Provider[] getProviders() {
        ProviderInfo info = this.getProviderInfo();
        return info.all.toArray(new Provider[info.all.size()]);
    }

    public Provider getProvider(String protocol) throws NoSuchProviderException {
        ProviderInfo info = this.getProviderInfo();
        Provider provider = null;
        String providerName = this.properties.getProperty("mail." + protocol + ".class");
        if (providerName != null) {
            provider = (Provider)info.byClassName.get(providerName);
            if (this.debug) {
                this.writeDebug("DEBUG: new provider loaded: " + provider.toString());
            }
        }
        if (provider == null) {
            provider = (Provider)info.byProtocol.get(protocol);
        }
        if (provider == null) {
            throw new NoSuchProviderException("Unable to locate provider for protocol: " + protocol);
        }
        if (this.debug) {
            this.writeDebug("DEBUG: getProvider() returning provider " + provider.toString());
        }
        return provider;
    }

    public void setProvider(Provider provider) throws NoSuchProviderException {
        ProviderInfo info = this.getProviderInfo();
        info.byProtocol.put(provider.getProtocol(), provider);
    }

    public Store getStore() throws NoSuchProviderException {
        String protocol = this.properties.getProperty("mail.store.protocol");
        if (protocol == null) {
            throw new NoSuchProviderException("mail.store.protocol property is not set");
        }
        return this.getStore(protocol);
    }

    public Store getStore(String protocol) throws NoSuchProviderException {
        Provider provider = this.getProvider(protocol);
        return this.getStore(provider);
    }

    public Store getStore(URLName url) throws NoSuchProviderException {
        return (Store)this.getService(this.getProvider(url.getProtocol()), url);
    }

    public Store getStore(Provider provider) throws NoSuchProviderException {
        if (Provider.Type.STORE != provider.getType()) {
            throw new NoSuchProviderException("Not a Store Provider: " + provider);
        }
        return (Store)this.getService(provider, null);
    }

    public Folder getFolder(URLName name) throws MessagingException {
        Store store = this.getStore(name);
        return store.getFolder(name);
    }

    public Transport getTransport() throws NoSuchProviderException {
        String protocol = this.properties.getProperty("mail.transport.protocol");
        if (protocol == null) {
            throw new NoSuchProviderException("mail.transport.protocol property is not set");
        }
        return this.getTransport(protocol);
    }

    public Transport getTransport(String protocol) throws NoSuchProviderException {
        Provider provider = this.getProvider(protocol);
        return this.getTransport(provider);
    }

    public Transport getTransport(URLName name) throws NoSuchProviderException {
        return (Transport)this.getService(this.getProvider(name.getProtocol()), name);
    }

    public Transport getTransport(Address address) throws NoSuchProviderException {
        String type = address.getType();
        Map addressMap = this.getAddressMap();
        String protocolName = (String)addressMap.get(type);
        if (protocolName == null) {
            throw new NoSuchProviderException("No provider for address type " + type);
        }
        return this.getTransport(protocolName);
    }

    public Transport getTransport(Provider provider) throws NoSuchProviderException {
        return (Transport)this.getService(provider, null);
    }

    public void setPasswordAuthentication(URLName name, PasswordAuthentication authenticator) {
        if (authenticator == null) {
            this.passwordAuthentications.remove(name);
        } else {
            this.passwordAuthentications.put(name, authenticator);
        }
    }

    public PasswordAuthentication getPasswordAuthentication(URLName name) {
        return (PasswordAuthentication)this.passwordAuthentications.get(name);
    }

    public PasswordAuthentication requestPasswordAuthentication(InetAddress host, int port, String protocol, String prompt, String defaultUserName) {
        if (this.authenticator == null) {
            return null;
        }
        return this.authenticator.authenticate(host, port, protocol, prompt, defaultUserName);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String property) {
        return this.getProperties().getProperty(property);
    }

    public synchronized void addProvider(Provider provider) {
        ProviderInfo info = this.getProviderInfo();
        info.addProvider(provider);
    }

    public void setProtocolForAddress(String addressType, String protocol) {
        Map addressMap = this.getAddressMap();
        if (protocol == null) {
            addressMap.remove(addressType);
        } else {
            addressMap.put(addressType, protocol);
        }
    }

    private Service getService(Provider provider, URLName name) throws NoSuchProviderException {
        try {
            if (name == null) {
                name = new URLName(provider.getProtocol(), null, -1, null, null, null);
            }
            ClassLoader cl = this.getClassLoader();
            Class<?> clazz = null;
            try {
                clazz = ProviderLocator.loadClass(provider.getClassName(), this.getClass(), cl);
            }
            catch (ClassNotFoundException e) {
                throw (NoSuchProviderException)new NoSuchProviderException("Unable to load class for provider: " + provider).initCause(e);
            }
            Constructor<?> ctr = clazz.getConstructor(PARAM_TYPES);
            return (Service)ctr.newInstance(this, name);
        }
        catch (NoSuchMethodException e) {
            throw (NoSuchProviderException)new NoSuchProviderException("Provider class does not have a constructor(Session, URLName): " + provider).initCause(e);
        }
        catch (InstantiationException e) {
            throw (NoSuchProviderException)new NoSuchProviderException("Unable to instantiate provider class: " + provider).initCause(e);
        }
        catch (IllegalAccessException e) {
            throw (NoSuchProviderException)new NoSuchProviderException("Unable to instantiate provider class: " + provider).initCause(e);
        }
        catch (InvocationTargetException e) {
            throw (NoSuchProviderException)new NoSuchProviderException("Exception from constructor of provider class: " + provider).initCause(e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProviderInfo getProviderInfo() {
        ClassLoader cl = this.getClassLoader();
        WeakHashMap weakHashMap = providersByClassLoader;
        synchronized (weakHashMap) {
            ProviderInfo info = (ProviderInfo)providersByClassLoader.get(cl);
            if (info == null) {
                info = this.loadProviders(cl);
            }
            return info;
        }
    }

    private Map getAddressMap() {
        ClassLoader cl = this.getClassLoader();
        Map addressMap = (Map)addressMapsByClassLoader.get(cl);
        if (addressMap == null) {
            addressMap = Session.loadAddressMap(cl);
        }
        return addressMap;
    }

    private ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.authenticator != null ? this.authenticator.getClass().getClassLoader() : this.getClass().getClassLoader();
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProviderInfo loadProviders(ClassLoader cl) {
        InputStream is;
        Collection<URL> l;
        InputStream is2;
        URL url;
        Enumeration<URL> e;
        ProviderInfo info = new ProviderInfo();
        try {
            File file = new File(System.getProperty("java.home"), "lib/javamail.providers");
            FileInputStream is3 = new FileInputStream(file);
            try {
                this.loadProviders(info, is3);
                if (this.debug) {
                    this.writeDebug("Loaded lib/javamail.providers from " + file.toString());
                }
            }
            finally {
                ((InputStream)is3).close();
            }
        }
        catch (SecurityException e2) {
        }
        catch (IOException e3) {
            // empty catch block
        }
        try {
            e = cl.getResources("META-INF/javamail.providers");
            while (e.hasMoreElements()) {
                url = e.nextElement();
                if (this.debug) {
                    this.writeDebug("Loading META-INF/javamail.providers from " + url.toString());
                }
                is2 = url.openStream();
                try {
                    this.loadProviders(info, is2);
                }
                finally {
                    is2.close();
                }
            }
        }
        catch (SecurityException e4) {
        }
        catch (IOException e5) {
            // empty catch block
        }
        try {
            l = MailProviderRegistry.getProviders();
            for (URL url2 : l) {
                if (this.debug) {
                    this.writeDebug("Loading META-INF/javamail.providers from " + url2.toString());
                }
                is = url2.openStream();
                try {
                    this.loadProviders(info, is);
                }
                finally {
                    is.close();
                }
            }
        }
        catch (SecurityException e6) {
        }
        catch (IOException e7) {
            // empty catch block
        }
        try {
            e = cl.getResources("META-INF/javamail.default.providers");
            while (e.hasMoreElements()) {
                url = e.nextElement();
                if (this.debug) {
                    this.writeDebug("Loading javamail.default.providers from " + url.toString());
                }
                is2 = url.openStream();
                try {
                    this.loadProviders(info, is2);
                }
                finally {
                    is2.close();
                }
            }
        }
        catch (SecurityException e8) {
        }
        catch (IOException e9) {
            // empty catch block
        }
        try {
            l = MailProviderRegistry.getDefaultProviders();
            for (URL url2 : l) {
                if (this.debug) {
                    this.writeDebug("Loading META-INF/javamail.providers from " + url2.toString());
                }
                is = url2.openStream();
                try {
                    this.loadProviders(info, is);
                }
                finally {
                    is.close();
                }
            }
        }
        catch (SecurityException e10) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        providersByClassLoader.put(cl, info);
        return info;
    }

    private void loadProviders(ProviderInfo info, InputStream is) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            StringTokenizer tok = new StringTokenizer(line, ";");
            String protocol = null;
            Provider.Type type = null;
            String className = null;
            String vendor = null;
            String version = null;
            while (tok.hasMoreTokens()) {
                String property = tok.nextToken();
                int index = property.indexOf(61);
                if (index == -1) continue;
                String key = property.substring(0, index).trim().toLowerCase();
                String value = property.substring(index + 1).trim();
                if (protocol == null && "protocol".equals(key)) {
                    protocol = value;
                    continue;
                }
                if (type == null && "type".equals(key)) {
                    if ("store".equals(value)) {
                        type = Provider.Type.STORE;
                        continue;
                    }
                    if (!"transport".equals(value)) continue;
                    type = Provider.Type.TRANSPORT;
                    continue;
                }
                if (className == null && "class".equals(key)) {
                    className = value;
                    continue;
                }
                if ("vendor".equals(key)) {
                    vendor = value;
                    continue;
                }
                if (!"version".equals(key)) continue;
                version = value;
            }
            if (protocol == null || type == null || className == null) continue;
            if (this.debug) {
                this.writeDebug("DEBUG: loading new provider protocol=" + protocol + ", className=" + className + ", vendor=" + vendor + ", version=" + version);
            }
            Provider provider = new Provider(type, protocol, className, vendor, version);
            info.addProvider(provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map loadAddressMap(ClassLoader cl) {
        InputStream is;
        URL url;
        Enumeration<URL> e;
        Properties addressMap = new Properties();
        addressMapsByClassLoader.put(cl, addressMap);
        try {
            e = cl.getResources("META-INF/javamail.default.address.map");
            while (e.hasMoreElements()) {
                url = e.nextElement();
                is = url.openStream();
                try {
                    addressMap.load(is);
                }
                finally {
                    is.close();
                }
            }
        }
        catch (SecurityException e2) {
        }
        catch (IOException e3) {
            // empty catch block
        }
        try {
            e = cl.getResources("META-INF/javamail.address.map");
            while (e.hasMoreElements()) {
                url = e.nextElement();
                is = url.openStream();
                try {
                    addressMap.load(is);
                }
                finally {
                    is.close();
                }
            }
        }
        catch (SecurityException e4) {
        }
        catch (IOException e5) {
            // empty catch block
        }
        try {
            File file = new File(System.getProperty("java.home"), "lib/javamail.address.map");
            FileInputStream is2 = new FileInputStream(file);
            try {
                addressMap.load(is2);
            }
            finally {
                ((InputStream)is2).close();
            }
        }
        catch (SecurityException e6) {
        }
        catch (IOException e7) {
            // empty catch block
        }
        try {
            e = cl.getResources("META-INF/javamail.address.map");
            while (e.hasMoreElements()) {
                url = e.nextElement();
                is = url.openStream();
                try {
                    addressMap.load(is);
                }
                finally {
                    is.close();
                }
            }
        }
        catch (SecurityException e8) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (addressMap.isEmpty()) {
            addressMap.put("rfc822", "smtp");
        }
        return addressMap;
    }

    private void writeDebug(String msg) {
        this.debugOut.println(msg);
    }

    static {
        providersByClassLoader = new WeakHashMap();
    }

    private static class ProviderInfo {
        private final Map byClassName = new HashMap();
        private final Map byProtocol = new HashMap();
        private final List all = new ArrayList();

        private ProviderInfo() {
        }

        public void addProvider(Provider provider) {
            String protocol;
            String className = provider.getClassName();
            if (!this.byClassName.containsKey(className)) {
                this.byClassName.put(className, provider);
            }
            if (!this.byProtocol.containsKey(protocol = provider.getProtocol())) {
                this.byProtocol.put(protocol, provider);
            }
            this.all.add(provider);
        }
    }
}

