/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.logging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.Beta;
import org.openqa.selenium.logging.LogEntries;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.logging.LogLevelMapping;

@Beta
public class SessionLogs {
    private final Map<String, LogEntries> logTypeToEntriesMap = new HashMap<String, LogEntries>();

    public LogEntries getLogs(String logType) {
        if (logType == null || !this.logTypeToEntriesMap.containsKey(logType)) {
            return new LogEntries(Collections.emptyList());
        }
        return this.logTypeToEntriesMap.get(logType);
    }

    public void addLog(String logType, LogEntries logEntries) {
        this.logTypeToEntriesMap.put(logType, logEntries);
    }

    public Set<String> getLogTypes() {
        return this.logTypeToEntriesMap.keySet();
    }

    public Map<String, LogEntries> getAll() {
        return Collections.unmodifiableMap(this.logTypeToEntriesMap);
    }

    public static SessionLogs fromJSON(Map<String, Object> rawSessionLogs) {
        SessionLogs sessionLogs = new SessionLogs();
        for (Map.Entry<String, Object> entry : rawSessionLogs.entrySet()) {
            String logType = entry.getKey();
            Collection rawLogEntries = (Collection)entry.getValue();
            ArrayList<LogEntry> logEntries = new ArrayList<LogEntry>();
            for (Object o : rawLogEntries) {
                Map rawEntry = (Map)o;
                logEntries.add(new LogEntry(LogLevelMapping.toLevel((String)String.valueOf(rawEntry.get("level"))), ((Number)rawEntry.get("timestamp")).longValue(), String.valueOf(rawEntry.get("message"))));
            }
            sessionLogs.addLog(logType, new LogEntries(logEntries));
        }
        return sessionLogs;
    }

    @Beta
    public Map<String, LogEntries> toJson() {
        return this.getAll();
    }
}

