/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueDouble
extends Value {
    public static final int PRECISION = 17;
    public static final int DISPLAY_SIZE = 24;
    public static final long ZERO_BITS = Double.doubleToLongBits(0.0);
    private static final ValueDouble ZERO = new ValueDouble(0.0);
    private static final ValueDouble ONE = new ValueDouble(1.0);
    private static final ValueDouble NAN = new ValueDouble(Double.NaN);
    private final double value;

    private ValueDouble(double d) {
        this.value = d;
    }

    public Value add(Value value) {
        ValueDouble valueDouble = (ValueDouble)value;
        return ValueDouble.get(this.value + valueDouble.value);
    }

    public Value subtract(Value value) {
        ValueDouble valueDouble = (ValueDouble)value;
        return ValueDouble.get(this.value - valueDouble.value);
    }

    public Value negate() {
        return ValueDouble.get(-this.value);
    }

    public Value multiply(Value value) {
        ValueDouble valueDouble = (ValueDouble)value;
        return ValueDouble.get(this.value * valueDouble.value);
    }

    public Value divide(Value value) {
        ValueDouble valueDouble = (ValueDouble)value;
        if (valueDouble.value == 0.0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueDouble.get(this.value / valueDouble.value);
    }

    public ValueDouble modulus(Value value) {
        ValueDouble valueDouble = (ValueDouble)value;
        if (valueDouble.value == 0.0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueDouble.get(this.value % valueDouble.value);
    }

    public String getSQL() {
        if (this.value == Double.POSITIVE_INFINITY) {
            return "POWER(0, -1)";
        }
        if (this.value == Double.NEGATIVE_INFINITY) {
            return "(-POWER(0, -1))";
        }
        if (Double.isNaN(this.value)) {
            return "SQRT(-1)";
        }
        String string = this.getString();
        if (string.equals("-0.0")) {
            return "-CAST(0 AS DOUBLE)";
        }
        return string;
    }

    public int getType() {
        return 7;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueDouble valueDouble = (ValueDouble)value;
        return Double.compare(this.value, valueDouble.value);
    }

    public int getSignum() {
        return this.value == 0.0 ? 0 : (this.value < 0.0 ? -1 : 1);
    }

    public double getDouble() {
        return this.value;
    }

    public String getString() {
        return String.valueOf(this.value);
    }

    public long getPrecision() {
        return 17L;
    }

    public int getScale() {
        return 0;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >> 32);
    }

    public Object getObject() {
        return this.value;
    }

    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setDouble(n, this.value);
    }

    public static ValueDouble get(double d) {
        if (d == 1.0) {
            return ONE;
        }
        if (d == 0.0) {
            if (Double.doubleToLongBits(d) == ZERO_BITS) {
                return ZERO;
            }
        } else if (Double.isNaN(d)) {
            return NAN;
        }
        return (ValueDouble)Value.cache(new ValueDouble(d));
    }

    public int getDisplaySize() {
        return 24;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ValueDouble)) {
            return false;
        }
        return this.compareSecure((ValueDouble)object, null) == 0;
    }
}

