/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.h2.message.DbException;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

public class DateTimeUtils {
    public static final long MILLIS_PER_DAY = 86400000L;
    private static final long NANOS_PER_DAY = 86400000000000L;
    private static final int SHIFT_YEAR = 9;
    private static final int SHIFT_MONTH = 5;
    private static final int[] NORMAL_DAYS_PER_MONTH = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] DAYS_OFFSET = new int[]{0, 31, 61, 92, 122, 153, 184, 214, 245, 275, 306, 337, 366};
    private static int zoneOffset;
    private static Calendar cachedCalendar;

    private DateTimeUtils() {
    }

    public static void resetCalendar() {
        cachedCalendar = null;
        DateTimeUtils.getCalendar();
    }

    private static Calendar getCalendar() {
        if (cachedCalendar == null) {
            cachedCalendar = Calendar.getInstance();
            zoneOffset = cachedCalendar.get(15);
        }
        return cachedCalendar;
    }

    public static java.sql.Date convertDateToCalendar(java.sql.Date date, Calendar calendar) {
        return date == null ? null : new java.sql.Date(DateTimeUtils.convertToLocal(date, calendar));
    }

    public static Time convertTimeToCalendar(Time time, Calendar calendar) {
        return time == null ? null : new Time(DateTimeUtils.convertToLocal(time, calendar));
    }

    public static Timestamp convertTimestampToCalendar(Timestamp timestamp, Calendar calendar) {
        if (timestamp != null) {
            Timestamp timestamp2 = new Timestamp(DateTimeUtils.convertToLocal(timestamp, calendar));
            timestamp2.setNanos(timestamp.getNanos());
            timestamp = timestamp2;
        }
        return timestamp;
    }

    public static Value convertDateToUTC(java.sql.Date date, Calendar calendar) {
        return ValueDate.get(new java.sql.Date(DateTimeUtils.convertToUTC(date, calendar)));
    }

    public static Value convertTimeToUTC(Time time, Calendar calendar) {
        return ValueTime.get(new Time(DateTimeUtils.convertToUTC(time, calendar)));
    }

    public static Value convertTimestampToUTC(Timestamp timestamp, Calendar calendar) {
        Timestamp timestamp2 = new Timestamp(DateTimeUtils.convertToUTC(timestamp, calendar));
        timestamp2.setNanos(timestamp.getNanos());
        return ValueTimestamp.get(timestamp2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long convertToUTC(Date date, Calendar calendar) {
        Calendar calendar2;
        if (calendar == null) {
            throw DbException.getInvalidValueException("calendar", null);
        }
        calendar = (Calendar)calendar.clone();
        Calendar calendar3 = calendar2 = DateTimeUtils.getCalendar();
        synchronized (calendar3) {
            calendar.setTime(date);
            DateTimeUtils.convertTime(calendar, calendar2);
            return calendar2.getTime().getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertToLocal(Date date, Calendar calendar) {
        Calendar calendar2;
        if (calendar == null) {
            throw DbException.getInvalidValueException("calendar", null);
        }
        calendar = (Calendar)calendar.clone();
        Calendar calendar3 = calendar2 = Calendar.getInstance();
        synchronized (calendar3) {
            calendar2.setTime(date);
            DateTimeUtils.convertTime(calendar2, calendar);
        }
        return calendar.getTime().getTime();
    }

    private static void convertTime(Calendar calendar, Calendar calendar2) {
        calendar2.set(0, calendar.get(0));
        calendar2.set(1, calendar.get(1));
        calendar2.set(2, calendar.get(2));
        calendar2.set(5, calendar.get(5));
        calendar2.set(11, calendar.get(11));
        calendar2.set(12, calendar.get(12));
        calendar2.set(13, calendar.get(13));
        calendar2.set(14, calendar.get(14));
    }

    public static long parseDateValue(String string, int n, int n2) {
        int n3;
        int n4;
        if (string.charAt(n) == '+') {
            ++n;
        }
        int n5 = string.indexOf(45, n + 1);
        int n6 = string.indexOf(45, n5 + 1);
        if (n5 <= 0 || n6 <= n5) {
            throw new IllegalArgumentException(string);
        }
        int n7 = Integer.parseInt(string.substring(n, n5));
        if (!DateTimeUtils.isValidDate(n7, n4 = Integer.parseInt(string.substring(n5 + 1, n6)), n3 = Integer.parseInt(string.substring(n6 + 1, n2)))) {
            throw new IllegalArgumentException(n7 + "-" + n4 + "-" + n3);
        }
        return DateTimeUtils.dateValue(n7, n4, n3);
    }

    public static long parseTimeNanos(String string, int n, int n2, boolean bl) {
        boolean bl2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        long l = 0L;
        int n6 = string.indexOf(58, n);
        int n7 = string.indexOf(58, n6 + 1);
        int n8 = string.indexOf(46, n7 + 1);
        if (n6 <= 0 || n7 <= n6) {
            throw new IllegalArgumentException(string);
        }
        n3 = Integer.parseInt(string.substring(n, n6));
        if (n3 < 0) {
            if (bl) {
                throw new IllegalArgumentException(string);
            }
            bl2 = true;
            n3 = -n3;
        } else {
            bl2 = false;
        }
        n4 = Integer.parseInt(string.substring(n6 + 1, n7));
        if (n8 < 0) {
            n5 = Integer.parseInt(string.substring(n7 + 1, n2));
        } else {
            n5 = Integer.parseInt(string.substring(n7 + 1, n8));
            String string2 = (string.substring(n8 + 1, n2) + "000000000").substring(0, 9);
            l = Integer.parseInt(string2);
        }
        if (n3 >= 2000000 || n4 < 0 || n4 >= 60 || n5 < 0 || n5 >= 60) {
            throw new IllegalArgumentException(string);
        }
        if (bl && n3 >= 24) {
            throw new IllegalArgumentException(string);
        }
        return bl2 ? -l : (l += (((long)n3 * 60L + (long)n4) * 60L + (long)n5) * 1000000000L);
    }

    public static long getMillis(TimeZone timeZone, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        try {
            return DateTimeUtils.getTimeTry(false, timeZone, n, n2, n3, n4, n5, n6, n7);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = illegalArgumentException.toString();
            if (string.indexOf("HOUR_OF_DAY") > 0) {
                if (n4 < 0 || n4 > 23) {
                    throw illegalArgumentException;
                }
                return DateTimeUtils.getTimeTry(true, timeZone, n, n2, n3, n4, n5, n6, n7);
            }
            if (string.indexOf("DAY_OF_MONTH") > 0) {
                int n8 = n2 == 2 ? (new GregorianCalendar().isLeapYear(n) ? 29 : 28) : 30 + (n2 + (n2 > 7 ? 1 : 0) & 1);
                if (n3 < 1 || n3 > n8) {
                    throw illegalArgumentException;
                }
                return DateTimeUtils.getTimeTry(true, timeZone, n, n2, n3, n4 += 6, n5, n6, n7);
            }
            return DateTimeUtils.getTimeTry(true, timeZone, n, n2, n3, n4, n5, n6, n7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getTimeTry(boolean bl, TimeZone timeZone, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Calendar calendar = timeZone == null ? DateTimeUtils.getCalendar() : Calendar.getInstance(timeZone);
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            calendar.clear();
            calendar.setLenient(bl);
            if (n <= 0) {
                calendar.set(0, 0);
                calendar.set(1, 1 - n);
            } else {
                calendar.set(0, 1);
                calendar.set(1, n);
            }
            calendar.set(2, n2 - 1);
            calendar.set(5, n3);
            calendar.set(11, n4);
            calendar.set(12, n5);
            calendar.set(13, n6);
            calendar.set(14, n7);
            return calendar.getTime().getTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDatePart(Date date, int n) {
        Calendar calendar;
        Calendar calendar2 = calendar = DateTimeUtils.getCalendar();
        synchronized (calendar2) {
            calendar.setTime(date);
            if (n == 1) {
                return DateTimeUtils.getYear(calendar);
            }
            int n2 = calendar.get(n);
            if (n == 2) {
                return n2 + 1;
            }
            return n2;
        }
    }

    private static int getYear(Calendar calendar) {
        int n = calendar.get(1);
        if (calendar.get(0) == 0) {
            n = 1 - n;
        }
        return n;
    }

    public static long getTimeLocalWithoutDst(Date date) {
        return date.getTime() + (long)zoneOffset;
    }

    public static long getTimeUTCWithoutDst(long l) {
        return l - (long)zoneOffset;
    }

    public static int getIsoDayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        int n = calendar.get(7) - 1;
        return n == 0 ? 7 : n;
    }

    public static int getIsoWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(4);
        return calendar.get(3);
    }

    public static int getIsoYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(4);
        int n = DateTimeUtils.getYear(calendar);
        int n2 = calendar.get(2);
        int n3 = calendar.get(3);
        if (n2 == 0 && n3 > 51) {
            --n;
        } else if (n2 == 11 && n3 == 1) {
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDateTime(Date date, String string, String string2, String string3) {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat = DateTimeUtils.getDateFormat(string, string2, string3);
        synchronized (simpleDateFormat2) {
            return simpleDateFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDateTime(String string, String string2, String string3, String string4) {
        SimpleDateFormat simpleDateFormat = DateTimeUtils.getDateFormat(string2, string3, string4);
        try {
            SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
            synchronized (simpleDateFormat2) {
                return simpleDateFormat.parse(string);
            }
        }
        catch (Exception exception) {
            throw DbException.get(90014, exception, string);
        }
    }

    private static SimpleDateFormat getDateFormat(String string, String string2, String string3) {
        try {
            SimpleDateFormat simpleDateFormat;
            if (string2 == null) {
                simpleDateFormat = new SimpleDateFormat(string);
            } else {
                Locale locale = new Locale(string2);
                simpleDateFormat = new SimpleDateFormat(string, locale);
            }
            if (string3 != null) {
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone(string3));
            }
            return simpleDateFormat;
        }
        catch (Exception exception) {
            throw DbException.get(90014, exception, string + "/" + string2 + "/" + string3);
        }
    }

    public static boolean isValidDate(int n, int n2, int n3) {
        if (n2 < 1 || n2 > 12 || n3 < 1) {
            return false;
        }
        if (n > 1582) {
            if (n2 != 2) {
                return n3 <= NORMAL_DAYS_PER_MONTH[n2];
            }
            if ((n & 3) != 0) {
                return n3 <= 28;
            }
            return n3 <= (n % 100 != 0 || n % 400 == 0 ? 29 : 28);
        }
        if (n == 1582 && n2 == 10) {
            return n3 <= 31 && (n3 < 5 || n3 > 14);
        }
        if (n2 != 2 && n3 <= NORMAL_DAYS_PER_MONTH[n2]) {
            return true;
        }
        return n3 <= ((n & 3) != 0 ? 28 : 29);
    }

    public static java.sql.Date convertDateValueToDate(long l) {
        long l2 = DateTimeUtils.getMillis(TimeZone.getDefault(), DateTimeUtils.yearFromDateValue(l), DateTimeUtils.monthFromDateValue(l), DateTimeUtils.dayFromDateValue(l), 0, 0, 0, 0);
        return new java.sql.Date(l2);
    }

    public static Timestamp convertDateValueToTimestamp(long l, long l2) {
        long l3 = l2 / 1000000L;
        l2 -= l3 * 1000000L;
        long l4 = l3 / 1000L;
        l3 -= l4 * 1000L;
        long l5 = l4 / 60L;
        l4 -= l5 * 60L;
        long l6 = l5 / 60L;
        long l7 = DateTimeUtils.getMillis(TimeZone.getDefault(), DateTimeUtils.yearFromDateValue(l), DateTimeUtils.monthFromDateValue(l), DateTimeUtils.dayFromDateValue(l), (int)l6, (int)(l5 -= l6 * 60L), (int)l4, 0);
        Timestamp timestamp = new Timestamp(l7);
        timestamp.setNanos((int)(l2 + l3 * 1000000L));
        return timestamp;
    }

    public static Time convertNanoToTime(long l) {
        long l2 = l / 1000000L;
        long l3 = l2 / 1000L;
        l2 -= l3 * 1000L;
        long l4 = l3 / 60L;
        l3 -= l4 * 60L;
        long l5 = l4 / 60L;
        long l6 = DateTimeUtils.getMillis(TimeZone.getDefault(), 1970, 1, 1, (int)(l5 % 24L), (int)(l4 -= l5 * 60L), (int)l3, (int)l2);
        return new Time(l6);
    }

    public static int yearFromDateValue(long l) {
        return (int)(l >>> 9);
    }

    public static int monthFromDateValue(long l) {
        return (int)(l >>> 5) & 0xF;
    }

    public static int dayFromDateValue(long l) {
        return (int)(l & 0x1FL);
    }

    public static long dateValue(long l, int n, int n2) {
        return l << 9 | (long)(n << 5) | (long)n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long dateValueFromDate(long l) {
        Calendar calendar;
        Calendar calendar2 = calendar = DateTimeUtils.getCalendar();
        synchronized (calendar2) {
            calendar.clear();
            calendar.setTimeInMillis(l);
            int n = DateTimeUtils.getYear(calendar);
            int n2 = calendar.get(2) + 1;
            int n3 = calendar.get(5);
            return (long)n << 9 | (long)(n2 << 5) | (long)n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long nanosFromDate(long l) {
        Calendar calendar;
        Calendar calendar2 = calendar = DateTimeUtils.getCalendar();
        synchronized (calendar2) {
            calendar.clear();
            calendar.setTimeInMillis(l);
            int n = calendar.get(11);
            int n2 = calendar.get(12);
            int n3 = calendar.get(13);
            int n4 = calendar.get(14);
            return ((((long)n * 60L + (long)n2) * 60L + (long)n3) * 1000L + (long)n4) * 1000000L;
        }
    }

    public static ValueTimestamp normalizeTimestamp(long l, long l2) {
        if (l2 > 86400000000000L || l2 < 0L) {
            long l3 = l2 > 86400000000000L ? l2 / 86400000000000L : (l2 - 86400000000000L + 1L) / 86400000000000L;
            l2 -= l3 * 86400000000000L;
            l += l3;
        }
        return ValueTimestamp.fromDateValueAndNanos(DateTimeUtils.dateValueFromAbsoluteDay(l), l2);
    }

    public static long absoluteDayFromDateValue(long l) {
        long l2 = DateTimeUtils.yearFromDateValue(l);
        int n = DateTimeUtils.monthFromDateValue(l);
        int n2 = DateTimeUtils.dayFromDateValue(l);
        if (n <= 2) {
            --l2;
            n += 12;
        }
        long l3 = (l2 * 2922L >> 3) + (long)DAYS_OFFSET[n - 3] + (long)n2 - 719484L;
        if (l2 <= 1582L && (l2 < 1582L || n * 100 + n2 < 1005)) {
            l3 += 13L;
        } else if (l2 < 1901L || l2 > 2099L) {
            l3 += l2 / 400L - l2 / 100L + 15L;
        }
        return l3;
    }

    public static long dateValueFromAbsoluteDay(long l) {
        long l2;
        long l3;
        long l4 = l + 719468L;
        long l5 = 0L;
        if (l4 > 578040L) {
            l3 = l4 / 146097L;
            l5 = (l4 -= l3 * 146097L) / 36524L;
            l4 -= l5 * 36524L;
            l2 = l3 * 400L + l5 * 100L;
        } else {
            l4 += 292200000002L;
            l2 = -800000000L;
        }
        l3 = l4 / 1461L;
        long l6 = (l4 -= l3 * 1461L) / 365L;
        if ((l4 -= l6 * 365L) == 0L && (l6 == 4L || l5 == 4L)) {
            --l6;
            l4 += 365L;
        }
        l6 += l2 + l3 * 4L;
        int n = ((int)l4 * 2 + 1) * 5 / 306;
        l4 -= (long)(DAYS_OFFSET[n] - 1);
        if (n >= 10) {
            ++l6;
            n -= 12;
        }
        return DateTimeUtils.dateValue(l6, n + 3, (int)l4);
    }

    static {
        DateTimeUtils.getCalendar();
    }
}

