/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.properties.SpaceProperty;
import org.apache.fop.layoutmgr.ConditionalElementListener;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.RelSide;
import org.apache.fop.layoutmgr.UnresolvedListElementWithLength;
import org.apache.fop.traits.MinOptMax;

public class SpaceElement
extends UnresolvedListElementWithLength {
    private int precedence;

    public SpaceElement(Position position, SpaceProperty space, RelSide side, boolean isFirst, boolean isLast, PercentBaseContext context) {
        super(position, space.getSpace().getLengthRange().toMinOptMax(context), side, space.isDiscard(), isFirst, isLast);
        int en = space.getSpace().getPrecedence().getEnum();
        this.precedence = en == 53 ? Integer.MAX_VALUE : space.getSpace().getPrecedence().getNumber().intValue();
    }

    public boolean isForcing() {
        return this.precedence == Integer.MAX_VALUE;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public void notifyLayoutManager(MinOptMax effectiveLength) {
        LayoutManager lm = this.getOriginatingLayoutManager();
        if (lm instanceof ConditionalElementListener) {
            ((ConditionalElementListener)((Object)lm)).notifySpace(this.getSide(), effectiveLength);
        } else {
            log.warn((Object)("Cannot notify LM. It does not implement ConditionalElementListener:" + lm.getClass().getName()));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Space[");
        sb.append(super.toString());
        sb.append(", precedence=");
        if (this.isForcing()) {
            sb.append("forcing");
        } else {
            sb.append(this.getPrecedence());
        }
        sb.append("]");
        return sb.toString();
    }
}

