/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.accessibility;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class StructureTree {
    private final List pageSequenceStructures = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    StructureTree() {
    }

    private static boolean flowOrStaticContentNodes(NodeList nodes) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) {
                return false;
            }
            String name = node.getLocalName();
            if (name.equals("flow") || name.equals("static-content")) continue;
            return false;
        }
        return true;
    }

    void addPageSequenceStructure(NodeList structureTree) {
        if (!$assertionsDisabled && !StructureTree.flowOrStaticContentNodes(structureTree)) {
            throw new AssertionError();
        }
        this.pageSequenceStructures.add(structureTree);
    }

    public NodeList getPageSequence(int index) {
        return (NodeList)this.pageSequenceStructures.get(index);
    }

    public String toString() {
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            StringWriter str = new StringWriter();
            Iterator iter = this.pageSequenceStructures.iterator();
            while (iter.hasNext()) {
                NodeList nodes = (NodeList)iter.next();
                int c = nodes.getLength();
                for (int i = 0; i < c; ++i) {
                    t.transform(new DOMSource(nodes.item(i)), new StreamResult(str));
                }
            }
            return ((Object)str).toString();
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    static {
        $assertionsDisabled = !StructureTree.class.desiredAssertionStatus();
    }
}

