/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.sis.xml.TransformVersion;
import org.apache.sis.xml.TransformingNamespaces;

abstract class TransformedEvent<E extends XMLEvent>
implements XMLEvent {
    final E event;
    final QName name;

    TransformedEvent(E e, QName qName) {
        this.event = e;
        this.name = qName;
    }

    @Override
    public boolean isStartElement() {
        return false;
    }

    @Override
    public boolean isAttribute() {
        return false;
    }

    @Override
    public boolean isNamespace() {
        return false;
    }

    @Override
    public boolean isEndElement() {
        return false;
    }

    @Override
    public boolean isEntityReference() {
        return false;
    }

    @Override
    public boolean isProcessingInstruction() {
        return false;
    }

    @Override
    public boolean isCharacters() {
        return false;
    }

    @Override
    public boolean isStartDocument() {
        return false;
    }

    @Override
    public boolean isEndDocument() {
        return false;
    }

    @Override
    public StartElement asStartElement() {
        throw new ClassCastException();
    }

    @Override
    public EndElement asEndElement() {
        throw new ClassCastException();
    }

    @Override
    public Characters asCharacters() {
        throw new ClassCastException();
    }

    @Override
    public Location getLocation() {
        return this.event.getLocation();
    }

    @Override
    public QName getSchemaType() {
        return this.event.getSchemaType();
    }

    public final QName getName() {
        return this.name;
    }

    final Appendable name(Appendable appendable) throws IOException {
        String string = this.name.getPrefix();
        if (string != null && !string.isEmpty()) {
            appendable.append(string).append(':');
        }
        return appendable.append(this.name.getLocalPart());
    }

    abstract void write(Appendable var1) throws IOException;

    @Override
    public final void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
        try {
            this.write(writer);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            this.write(stringBuilder);
        }
        catch (IOException iOException) {
            return iOException.toString();
        }
        return stringBuilder.toString();
    }

    static class Start
    extends TransformedEvent<StartElement>
    implements StartElement {
        private final List<Namespace> namespaces;
        private final List<Attribute> attributes;
        final TransformVersion version;

        Start(StartElement startElement, QName qName, List<Namespace> list, List<Attribute> list2, TransformVersion transformVersion) {
            super(startElement, qName);
            this.namespaces = list;
            this.attributes = list2;
            this.version = transformVersion;
        }

        @Override
        public final boolean isStartElement() {
            return true;
        }

        @Override
        public final StartElement asStartElement() {
            return this;
        }

        @Override
        public final int getEventType() {
            return 1;
        }

        @Override
        public final Iterator<Namespace> getNamespaces() {
            return this.namespaces.iterator();
        }

        @Override
        public final Iterator<Attribute> getAttributes() {
            return this.attributes.iterator();
        }

        @Override
        public final Attribute getAttributeByName(QName qName) {
            for (Attribute attribute : this.attributes) {
                if (!qName.equals(attribute.getName())) continue;
                return attribute;
            }
            return null;
        }

        @Override
        public String getNamespaceURI(String string) {
            return this.version.importNS(((StartElement)this.event).getNamespaceURI(string));
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            return TransformingNamespaces.asJAXB(((StartElement)this.event).getNamespaceContext(), this.version);
        }

        @Override
        final void write(Appendable appendable) throws IOException {
            this.name(appendable.append('<'));
            int n = this.attributes.size();
            for (int i = 0; i < n; ++i) {
                appendable.append(' ');
                Attr.castOrWrap(this.attributes.get(i)).write(appendable);
            }
            appendable.append('>');
        }
    }

    static final class End
    extends TransformedEvent<EndElement>
    implements EndElement {
        private final List<Namespace> namespaces;

        End(EndElement endElement, QName qName, List<Namespace> list) {
            super(endElement, qName);
            this.namespaces = list;
        }

        @Override
        public boolean isEndElement() {
            return true;
        }

        @Override
        public EndElement asEndElement() {
            return this;
        }

        @Override
        public int getEventType() {
            return 2;
        }

        @Override
        public Iterator<Namespace> getNamespaces() {
            return this.namespaces.iterator();
        }

        @Override
        void write(Appendable appendable) throws IOException {
            this.name(appendable.append("</")).append('>');
        }
    }

    static final class Type
    extends Attr {
        private final String value;
        Namespace namespace;

        Type(Attribute attribute, QName qName, String string) {
            super(attribute, qName);
            this.value = string;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    static class Attr
    extends TransformedEvent<Attribute>
    implements Attribute {
        Attr(Attribute attribute, QName qName) {
            super(attribute, qName);
        }

        static Attr castOrWrap(Attribute attribute) {
            if (attribute instanceof Attr) {
                return (Attr)attribute;
            }
            return new Attr(attribute, attribute.getName());
        }

        @Override
        public boolean isAttribute() {
            return true;
        }

        @Override
        public int getEventType() {
            return 10;
        }

        @Override
        public String getValue() {
            return ((Attribute)this.event).getValue();
        }

        @Override
        public String getDTDType() {
            return ((Attribute)this.event).getDTDType();
        }

        @Override
        public boolean isSpecified() {
            return ((Attribute)this.event).isSpecified();
        }

        @Override
        void write(Appendable appendable) throws IOException {
            this.name(appendable).append("=\"").append(this.getValue()).append('\"');
        }
    }

    static final class NS
    extends TransformedEvent<Attribute>
    implements Namespace {
        private final String namespaceURI;

        NS(Attribute attribute, String string, String string2) {
            super(attribute, new QName("http://www.w3.org/2000/xmlns/", string, "xmlns"));
            this.namespaceURI = string2;
        }

        @Override
        public boolean isNamespace() {
            return true;
        }

        @Override
        public int getEventType() {
            return 13;
        }

        @Override
        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        @Override
        public String getValue() {
            return this.namespaceURI;
        }

        @Override
        public String getDTDType() {
            return ((Attribute)this.event).getDTDType();
        }

        @Override
        public boolean isSpecified() {
            return this.event instanceof Namespace && ((Attribute)this.event).isSpecified();
        }

        @Override
        public String getPrefix() {
            return this.name != null ? this.name.getLocalPart() : null;
        }

        @Override
        public boolean isDefaultNamespaceDeclaration() {
            return this.name != null && this.name.getLocalPart().isEmpty();
        }

        @Override
        void write(Appendable appendable) throws IOException {
            this.name(appendable).append("=\"").append(this.namespaceURI).append('\"');
        }
    }
}

