/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.metadata.replace;

import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.FilterByVersion;
import org.apache.sis.internal.jaxb.metadata.replace.RS_Identifier;
import org.apache.sis.internal.simple.SimpleIdentifiedObject;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.ReferenceSystem;

@XmlType(name="MD_ReferenceSystem_Type", namespace="http://standards.iso.org/iso/19115/-3/mrs/1.0")
@XmlRootElement(name="MD_ReferenceSystem", namespace="http://standards.iso.org/iso/19115/-3/mrs/1.0")
public class ReferenceSystemMetadata
extends SimpleIdentifiedObject
implements ReferenceSystem {
    private static final long serialVersionUID = 2810145397032096087L;
    private boolean isLegacyMetadata;

    public ReferenceSystemMetadata() {
    }

    public ReferenceSystemMetadata(ReferenceSystem referenceSystem) {
        super((IdentifiedObject)referenceSystem);
    }

    public ReferenceSystemMetadata(ReferenceIdentifier referenceIdentifier) {
        super(referenceIdentifier);
    }

    private void beforeMarshal(Marshaller marshaller) {
        this.isLegacyMetadata = !FilterByVersion.CURRENT_METADATA.accept();
    }

    @Override
    @XmlElement(name="referenceSystemIdentifier")
    public final ReferenceIdentifier getName() {
        ReferenceIdentifier referenceIdentifier = super.getName();
        if (this.isLegacyMetadata) {
            referenceIdentifier = RS_Identifier.wrap((Identifier)referenceIdentifier);
        }
        return referenceIdentifier;
    }

    public final void setName(ReferenceIdentifier referenceIdentifier) {
        this.name = referenceIdentifier;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (super.equals(object, comparisonMode) && object instanceof ReferenceSystem) {
            ReferenceSystem referenceSystem = (ReferenceSystem)object;
            if (comparisonMode.isIgnoringMetadata()) {
                return Utilities.deepEquals(this.getName(), referenceSystem.getName(), comparisonMode);
            }
            return referenceSystem.getDomainOfValidity() == null && referenceSystem.getScope() == null;
        }
        return false;
    }
}

