/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.util.Arrays;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.util.ArgumentChecks;

final class GridCoordinatesView {
    private final long[] coordinates;
    private final int offset;

    GridCoordinatesView(long[] lArray, int n) {
        this.coordinates = lArray;
        this.offset = n;
    }

    public final int getDimension() {
        return this.coordinates.length >>> 1;
    }

    public final long[] getCoordinateValues() {
        return Arrays.copyOfRange(this.coordinates, this.offset, this.offset + this.getDimension());
    }

    public final long getCoordinateValue(int n) {
        ArgumentChecks.ensureValidIndex(this.getDimension(), n);
        return this.coordinates[this.offset + n];
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("GridCoordinates[");
        int n = this.getDimension();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.coordinates[i + this.offset]);
        }
        return stringBuilder.append(']').toString();
    }

    public final int hashCode() {
        long l = -3L;
        int n = this.offset + this.getDimension();
        for (int i = this.offset; i < n; ++i) {
            l = 31L * l + this.coordinates[i];
        }
        return Long.hashCode(l);
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof GridCoordinatesView) {
            GridCoordinatesView gridCoordinatesView = (GridCoordinatesView)object;
            return JDK9.equals(this.coordinates, this.offset, this.offset + this.getDimension(), gridCoordinatesView.coordinates, gridCoordinatesView.offset, gridCoordinatesView.offset + gridCoordinatesView.getDimension());
        }
        return false;
    }
}

