/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process.reflect;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType3Font;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.font.FontValidator;
import org.apache.pdfbox.preflight.font.TrueTypeFontValidator;
import org.apache.pdfbox.preflight.font.Type0FontValidator;
import org.apache.pdfbox.preflight.font.Type1FontValidator;
import org.apache.pdfbox.preflight.font.Type3FontValidator;
import org.apache.pdfbox.preflight.font.container.FontContainer;
import org.apache.pdfbox.preflight.process.AbstractProcess;

public class FontValidationProcess
extends AbstractProcess {
    @Override
    public void validate(PreflightContext context) throws ValidationException {
        PreflightPath vPath = context.getValidationPath();
        if (vPath.isEmpty()) {
            return;
        }
        if (!vPath.isExpectedType(PDFont.class)) {
            context.addValidationError(new ValidationResult.ValidationError("3.1", "Font validation process needs at least one PDFont object"));
        } else {
            FontValidator<? extends FontContainer<? extends PDFont>> validator;
            PDFont font = (PDFont)vPath.peek();
            FontContainer<?> fontContainer = context.getFontContainer((COSBase)font.getCOSObject());
            if (fontContainer == null && (validator = this.getFontValidator(context, font)) != null) {
                validator.validate();
            }
        }
    }

    protected FontValidator<? extends FontContainer<? extends PDFont>> getFontValidator(PreflightContext context, PDFont font) {
        String subtype = font.getSubType();
        if ("TrueType".equals(subtype)) {
            return new TrueTypeFontValidator(context, (PDTrueTypeFont)font);
        }
        if ("MMType1".equals(subtype) || "Type1".equals(subtype)) {
            return new Type1FontValidator(context, (PDSimpleFont)font);
        }
        if ("Type3".equals(subtype)) {
            return new Type3FontValidator(context, (PDType3Font)font);
        }
        if ("Type0".equals(subtype)) {
            return new Type0FontValidator(context, font);
        }
        if ("CIDFontType2".equals(subtype) || "Type1C".equals(subtype) || "CIDFontType0C".equals(subtype) || "CIDFontType0".equals(subtype)) {
            return null;
        }
        context.addValidationError(new ValidationResult.ValidationError("3.1.14", "Unknown font type: " + subtype));
        return null;
    }
}

