/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectParseErrorException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectTypeHeaderStart;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.ByteUtil;

public class StorageManifestSchemaGUID
extends StreamObject {
    public UUID guid;

    public StorageManifestSchemaGUID() {
        super(StreamObjectTypeHeaderStart.StorageManifestSchemaGUID);
    }

    @Override
    protected void deserializeItemsFromByteArray(byte[] byteArray, AtomicInteger currentIndex, int lengthOfItems) {
        AtomicInteger index = new AtomicInteger(currentIndex.get());
        byte[] temp = Arrays.copyOf(byteArray, 16);
        this.guid = UUID.nameUUIDFromBytes(temp);
        index.addAndGet(16);
        if (index.get() - currentIndex.get() != lengthOfItems) {
            throw new StreamObjectParseErrorException(currentIndex.get(), "StorageManifestSchemaGUID", "Stream object over-parse error", null);
        }
        currentIndex.set(index.get());
    }

    @Override
    protected int serializeItemsToByteList(List<Byte> byteList) {
        byteList.addAll(ByteUtil.toListOfByte(this.guid.toString().getBytes(StandardCharsets.UTF_8)));
        return 16;
    }
}

