/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote;

import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.OneNotePropertyEnum;

class OneNotePropertyId {
    OneNotePropertyEnum propertyEnum;
    long pid;
    long type;
    boolean inlineBool;

    public OneNotePropertyId() {
    }

    public OneNotePropertyId(long pid) throws TikaException {
        this.pid = pid;
        this.propertyEnum = OneNotePropertyEnum.of(pid);
        this.type = pid >> 26 & 0x1FL;
        this.inlineBool = false;
        if (this.type == 2L) {
            this.inlineBool = (pid >> 31 & 1L) > 0L;
        } else if ((pid >> 31 & 1L) > 0L) {
            throw new TikaException("Reserved non-zero");
        }
    }

    public OneNotePropertyEnum getPropertyEnum() {
        return this.propertyEnum;
    }

    public OneNotePropertyId setPropertyEnum(OneNotePropertyEnum propertyEnum) {
        this.propertyEnum = propertyEnum;
        return this;
    }

    public long getPid() {
        return this.pid;
    }

    public OneNotePropertyId setPid(long pid) {
        this.pid = pid;
        return this;
    }

    public long getType() {
        return this.type;
    }

    public OneNotePropertyId setType(long type) {
        this.type = type;
        return this;
    }

    public boolean isInlineBool() {
        return this.inlineBool;
    }

    public OneNotePropertyId setInlineBool(boolean inlineBool) {
        this.inlineBool = inlineBool;
        return this;
    }

    public String toString() {
        return "{" + (Object)((Object)this.propertyEnum) + ", pid=0x" + Long.toHexString(this.pid) + ", type=0x" + Long.toHexString(this.type) + ", inlineBool=" + this.inlineBool + '}';
    }
}

