/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.artifact;

import org.apache.commons.codec.binary.Base64;
import org.opensaml.SAMLConfig;
import org.opensaml.artifact.Artifact;
import org.opensaml.artifact.ArtifactParseException;
import org.opensaml.artifact.SAMLArtifact;
import org.opensaml.artifact.Util;

public class SAMLArtifactType0001
extends SAMLArtifact {
    public static final Artifact.TypeCode TYPE_CODE = new SAMLArtifact.TypeCode(0, 1);

    public SAMLArtifactType0001(byte[] byArray) {
        SAMLArtifactType0001.checkIdentifierArg(byArray);
        this.typeCode = TYPE_CODE;
        this.remainingArtifact = new RemainingArtifact(byArray);
    }

    public SAMLArtifactType0001(byte[] byArray, byte[] byArray2) {
        SAMLArtifactType0001.checkIdentifierArg(byArray);
        SAMLArtifactType0001.checkHandleArg(byArray2);
        this.typeCode = TYPE_CODE;
        this.remainingArtifact = new RemainingArtifact(byArray, byArray2);
    }

    public SAMLArtifactType0001(Artifact.RemainingArtifact remainingArtifact) {
        SAMLArtifactType0001.checkNullArg(remainingArtifact);
        this.typeCode = TYPE_CODE;
        this.remainingArtifact = remainingArtifact;
    }

    public byte[] getSourceId() {
        return ((RemainingArtifact)this.remainingArtifact).getSourceId();
    }

    public byte[] getAssertionHandle() {
        return ((RemainingArtifact)this.remainingArtifact).getAssertionHandle();
    }

    public static final class Parser
    implements Artifact.Parser {
        public Artifact parse(String string) throws ArtifactParseException {
            int n;
            byte[] byArray = Base64.decodeBase64((byte[])string.getBytes());
            if (byArray.length != (n = 42)) {
                throw new ArtifactParseException(byArray.length, n);
            }
            SAMLArtifact.TypeCode typeCode = new SAMLArtifact.TypeCode(byArray[0], byArray[1]);
            if (!typeCode.equals(TYPE_CODE)) {
                throw new ArtifactParseException(typeCode, TYPE_CODE);
            }
            byte[] byArray2 = new byte[20];
            System.arraycopy(byArray, 2, byArray2, 0, 20);
            byte[] byArray3 = new byte[20];
            System.arraycopy(byArray, 22, byArray3, 0, 20);
            return new SAMLArtifactType0001(byArray2, byArray3);
        }
    }

    public static final class RemainingArtifact
    extends SAMLArtifact.RemainingArtifact {
        private byte[] sourceId;
        private byte[] assertionHandle;

        public RemainingArtifact(byte[] byArray) {
            SAMLArtifact.checkIdentifierArg(byArray);
            this.sourceId = byArray;
            this.assertionHandle = SAMLConfig.instance().getDefaultIDProvider().generateRandomBytes(20);
        }

        public RemainingArtifact(byte[] byArray, byte[] byArray2) {
            SAMLArtifact.checkIdentifierArg(byArray);
            SAMLArtifact.checkHandleArg(byArray2);
            this.sourceId = byArray;
            this.assertionHandle = byArray2;
        }

        public byte[] getSourceId() {
            return this.sourceId;
        }

        public byte[] getAssertionHandle() {
            return this.assertionHandle;
        }

        public int size() {
            return this.sourceId.length + this.assertionHandle.length;
        }

        public byte[] getBytes() {
            byte[] byArray = this.sourceId;
            byte[] byArray2 = this.assertionHandle;
            return Util.concat(byArray, byArray2);
        }

        public int hashCode() {
            return this.sourceId.hashCode() & this.assertionHandle.hashCode();
        }
    }
}

