/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.artifact;

import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.opensaml.artifact.Artifact;
import org.opensaml.artifact.ArtifactParserException;
import org.opensaml.artifact.InvalidArgumentException;
import org.opensaml.artifact.NullArgumentException;
import org.opensaml.artifact.SAMLArtifactChecking;
import org.opensaml.artifact.TwoByteSequence;
import org.opensaml.artifact.Util;

public abstract class SAMLArtifact
implements Artifact,
SAMLArtifactChecking {
    protected Artifact.TypeCode typeCode = null;
    protected Artifact.RemainingArtifact remainingArtifact = null;

    protected SAMLArtifact() {
    }

    public Artifact.TypeCode getTypeCode() {
        return this.typeCode;
    }

    public Artifact.RemainingArtifact getRemainingArtifact() {
        return this.remainingArtifact;
    }

    public int size() {
        return this.typeCode.size() + this.remainingArtifact.size();
    }

    public byte[] getBytes() {
        byte[] byArray = this.typeCode.getBytes();
        byte[] byArray2 = this.remainingArtifact.getBytes();
        return Util.concat(byArray, byArray2);
    }

    public String encode() {
        return new String(Base64.encodeBase64((byte[])this.getBytes()));
    }

    public String toString() {
        return new String(Hex.encodeHex((byte[])this.getBytes()));
    }

    public boolean equals(Object object) {
        if (!(object instanceof SAMLArtifact)) {
            return false;
        }
        SAMLArtifact sAMLArtifact = (SAMLArtifact)object;
        return Arrays.equals(this.getBytes(), sAMLArtifact.getBytes());
    }

    public int hashCode() {
        return this.typeCode.hashCode() & this.remainingArtifact.hashCode();
    }

    public static Artifact.TypeCode getTypeCode(String string) {
        byte[] byArray = Base64.decodeBase64((byte[])string.getBytes());
        return new TypeCode(byArray[0], byArray[1]);
    }

    public static void checkHandleArg(byte[] byArray) {
        SAMLArtifact.checkNullArg(byArray);
        int n = byArray.length;
        if (n != 20) {
            throw new InvalidArgumentException(n, 20);
        }
    }

    public static void checkIdentifierArg(byte[] byArray) {
        SAMLArtifact.checkNullArg(byArray);
        int n = byArray.length;
        if (n != 20) {
            throw new InvalidArgumentException(n, 20);
        }
    }

    public static void checkNullArg(Object object) {
        if (object == null) {
            throw new NullArgumentException();
        }
    }

    public static abstract class Parser
    implements Artifact.Parser {
    }

    public static abstract class RemainingArtifact
    implements Artifact.RemainingArtifact {
        public String toString() {
            return new String(Hex.encodeHex((byte[])this.getBytes()));
        }

        public boolean equals(Object object) {
            if (!(object instanceof Artifact.RemainingArtifact)) {
                return false;
            }
            Artifact.RemainingArtifact remainingArtifact = (Artifact.RemainingArtifact)object;
            return Arrays.equals(this.getBytes(), remainingArtifact.getBytes());
        }
    }

    public static final class TypeCode
    extends TwoByteSequence
    implements Artifact.TypeCode {
        private static final String CLASS_NAME_PREFIX = "org.opensaml.artifact.SAMLArtifactType";
        private static final String CLASS_NAME_SUFFIX = "$Parser";

        public TypeCode(byte by, byte by2) {
            super(by, by2);
        }

        public TypeCode(short s) {
            super(s);
        }

        public String toString() {
            return "0x" + super.toString();
        }

        public Artifact.Parser getParser() throws ArtifactParserException {
            Artifact.Parser parser;
            String string = super.toString();
            String string2 = CLASS_NAME_PREFIX + string + CLASS_NAME_SUFFIX;
            try {
                parser = (Artifact.Parser)Class.forName(string2).newInstance();
            }
            catch (Exception exception) {
                throw new ArtifactParserException(exception.getMessage());
            }
            return parser;
        }
    }
}

