/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import org.opensaml.MalformedException;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLException;
import org.opensaml.SAMLSignedObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLResponse
extends SAMLSignedObject {
    protected int minor;
    protected String responseId;
    protected String inResponseTo;
    protected Date issueInstant;
    protected String recipient;
    protected ArrayList assertions;
    protected SAMLException e;

    protected void insertSignature() throws SAMLException {
        this.root.insertBefore(this.getSignatureElement(), this.root.getFirstChild());
    }

    public SAMLResponse() {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.responseId = null;
        this.inResponseTo = null;
        this.issueInstant = new Date();
        this.recipient = null;
        this.assertions = new ArrayList();
        this.e = null;
    }

    public SAMLResponse(String string, String string2, Collection collection, SAMLException sAMLException) throws SAMLException {
        this(SAMLConfig.instance().getDefaultIDProvider().getIdentifier(), new Date(), string, string2, collection, sAMLException);
    }

    public SAMLResponse(String string, Date date, String string2, String string3, Collection collection, SAMLException sAMLException) throws SAMLException {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.responseId = null;
        this.inResponseTo = null;
        this.issueInstant = new Date();
        this.recipient = null;
        this.assertions = new ArrayList();
        this.e = null;
        this.responseId = XML.assign(string);
        this.issueInstant = date;
        this.inResponseTo = XML.assign(string2);
        this.recipient = XML.assign(string3);
        if (sAMLException != null) {
            this.e = sAMLException.setParent(this);
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.assertions.add(((SAMLAssertion)iterator.next()).setParent(this));
            }
        }
    }

    public SAMLResponse(Element element) throws SAMLException {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.responseId = null;
        this.inResponseTo = null;
        this.issueInstant = new Date();
        this.recipient = null;
        this.assertions = new ArrayList();
        this.e = null;
        this.fromDOM(element);
    }

    public SAMLResponse(InputStream inputStream) throws SAMLException {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.responseId = null;
        this.inResponseTo = null;
        this.issueInstant = new Date();
        this.recipient = null;
        this.assertions = new ArrayList();
        this.e = null;
        this.fromDOM(SAMLResponse.fromStream(inputStream));
    }

    public SAMLResponse(InputStream inputStream, int n) throws SAMLException {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.responseId = null;
        this.inResponseTo = null;
        this.issueInstant = new Date();
        this.recipient = null;
        this.assertions = new ArrayList();
        this.e = null;
        this.fromDOM(SAMLResponse.fromStream(inputStream, n));
    }

    public void fromDOM(Element element) throws SAMLException {
        Object object;
        Object object2;
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:protocol", "Response")) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLResponse.fromDOM() requires samlp:Response at root");
        }
        if (Integer.parseInt(element.getAttributeNS(null, "MajorVersion")) != 1) {
            throw new MalformedException(SAMLException.VERSION, "SAMLResponse() detected incompatible response major version of " + element.getAttributeNS(null, "MajorVersion"));
        }
        this.minor = Integer.parseInt(element.getAttributeNS(null, "MinorVersion"));
        this.responseId = XML.assign(element.getAttributeNS(null, "ResponseID"));
        if (this.minor > 0) {
            element.setIdAttributeNode(element.getAttributeNodeNS(null, "ResponseID"), true);
        }
        this.inResponseTo = XML.assign(element.getAttributeNS(null, "InResponseTo"));
        this.recipient = XML.assign(element.getAttributeNS(null, "Recipient"));
        try {
            object2 = null;
            object = XML.assign(element.getAttributeNS(null, "IssueInstant"));
            int n = ((String)object).indexOf(46);
            object2 = n > 0 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            ((DateFormat)object2).setTimeZone(TimeZone.getTimeZone("UTC"));
            this.issueInstant = ((DateFormat)object2).parse((String)object);
        }
        catch (ParseException parseException) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLResponse() detected an invalid datetime while parsing response", (Exception)parseException);
        }
        object2 = XML.getFirstChildElement(element, "urn:oasis:names:tc:SAML:1.0:protocol", "Status");
        this.e = SAMLException.getInstance((Element)object2);
        object = this.e.getCodes();
        if (object.hasNext() && !object.next().equals(SAMLException.SUCCESS)) {
            throw this.e;
        }
        object2 = XML.getNextSiblingElement((Node)object2, "urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
        while (object2 != null) {
            this.assertions.add(new SAMLAssertion((Element)object2).setParent(this));
            object2 = XML.getNextSiblingElement((Node)object2, "urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
        }
        this.checkValidity();
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public void setMinorVersion(int n) {
        this.minor = n;
        this.setDirty(true);
    }

    public String getId() {
        return this.responseId;
    }

    public void setId(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.responseId = XML.assign(string);
        this.setDirty(true);
    }

    public String getInResponseTo() {
        return this.inResponseTo;
    }

    public void setInResponseTo(String string) {
        this.inResponseTo = XML.assign(string);
        this.setDirty(true);
    }

    public Date getIssueInstant() {
        return this.issueInstant;
    }

    public void setIssueInstant(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("issueInstant cannot be null");
        }
        this.issueInstant = date;
        this.setDirty(true);
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String string) {
        this.recipient = XML.assign(string);
        this.setDirty(true);
    }

    public Iterator getAssertions() {
        return this.assertions.iterator();
    }

    public void setAssertions(Collection collection) throws SAMLException {
        this.assertions.clear();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.assertions.add(((SAMLAssertion)iterator.next()).setParent(this));
            }
        }
        this.setDirty(true);
    }

    public void addAssertion(SAMLAssertion sAMLAssertion) throws SAMLException {
        if (sAMLAssertion == null) {
            throw new IllegalArgumentException("assertion cannot be null");
        }
        this.assertions.add(sAMLAssertion.setParent(this));
        this.setDirty(true);
    }

    public void removeAssertion(int n) throws IndexOutOfBoundsException {
        this.assertions.remove(n);
        this.setDirty(true);
    }

    public SAMLException getStatus() {
        return this.e;
    }

    public void setStatus(SAMLException sAMLException) throws SAMLException {
        this.e = sAMLException.setParent(this);
        this.setDirty(true);
    }

    protected Element buildRoot(Document document, boolean bl) {
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "Response");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:1.0:assertion");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:samlp", "urn:oasis:names:tc:SAML:1.0:protocol");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        }
        return element;
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        super.toDOM(document, bl);
        Element element = (Element)this.root;
        if (this.dirty) {
            Object object;
            if (this.responseId == null) {
                this.responseId = this.config.getDefaultIDProvider().getIdentifier();
            }
            if (this.issueInstant == null) {
                this.issueInstant = new Date();
            }
            element.setAttributeNS(null, "MajorVersion", "1");
            element.setAttributeNS(null, "MinorVersion", String.valueOf(this.minor));
            element.setAttributeNS(null, "ResponseID", this.responseId);
            if (this.minor > 0) {
                element.setIdAttributeNS(null, "ResponseID", true);
            }
            if (!XML.isEmpty(this.inResponseTo)) {
                element.setAttributeNS(null, "InResponseTo", this.inResponseTo);
            }
            if (!XML.isEmpty(this.recipient)) {
                element.setAttributeNS(null, "Recipient", this.recipient);
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            element.setAttributeNS(null, "IssueInstant", simpleDateFormat.format(this.issueInstant));
            if (this.e != null) {
                element.appendChild(this.e.toDOM(document, false));
            } else {
                object = document.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "Status");
                Element element2 = document.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "StatusCode");
                element2.setAttributeNS(null, "Value", "samlp:" + SAMLException.SUCCESS.getLocalPart());
                object.appendChild(element2);
                element.appendChild((Node)object);
            }
            object = this.assertions.iterator();
            while (object.hasNext()) {
                element.appendChild(((SAMLAssertion)object.next()).toDOM(document));
            }
            this.setDirty(false);
        } else if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:1.0:assertion");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:samlp", "urn:oasis:names:tc:SAML:1.0:protocol");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        }
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (this.responseId == null) {
            throw new MalformedException("Response is invalid, must have an ID");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLResponse sAMLResponse = (SAMLResponse)super.clone();
        try {
            if (this.e != null) {
                sAMLResponse.e = ((SAMLException)this.e.clone()).setParent(sAMLResponse);
            }
            sAMLResponse.assertions = new ArrayList();
            Iterator iterator = this.assertions.iterator();
            while (iterator.hasNext()) {
                sAMLResponse.assertions.add(((SAMLAssertion)((SAMLAssertion)iterator.next()).clone()).setParent(sAMLResponse));
            }
        }
        catch (SAMLException sAMLException) {
            throw new CloneNotSupportedException(sAMLException.getMessage());
        }
        return sAMLResponse;
    }
}

