/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkCredentialsInjector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VMParamsZkCredentialsInjector
implements ZkCredentialsInjector {
    public static final String DEFAULT_DIGEST_USERNAME_VM_PARAM_NAME = "zkDigestUsername";
    public static final String DEFAULT_DIGEST_PASSWORD_VM_PARAM_NAME = "zkDigestPassword";
    public static final String DEFAULT_DIGEST_READONLY_USERNAME_VM_PARAM_NAME = "zkDigestReadonlyUsername";
    public static final String DEFAULT_DIGEST_READONLY_PASSWORD_VM_PARAM_NAME = "zkDigestReadonlyPassword";
    public static final String DEFAULT_DIGEST_FILE_VM_PARAM_NAME = "zkDigestCredentialsFile";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final String zkDigestAllUsernameVMParamName;
    final String zkDigestAllPasswordVMParamName;
    final String zkDigestReadonlyUsernameVMParamName;
    final String zkDigestReadonlyPasswordVMParamName;
    final Properties credentialsProps;

    public VMParamsZkCredentialsInjector() {
        this(DEFAULT_DIGEST_USERNAME_VM_PARAM_NAME, DEFAULT_DIGEST_PASSWORD_VM_PARAM_NAME, DEFAULT_DIGEST_READONLY_USERNAME_VM_PARAM_NAME, DEFAULT_DIGEST_READONLY_PASSWORD_VM_PARAM_NAME);
    }

    public VMParamsZkCredentialsInjector(String zkDigestAllUsernameVMParamName, String zkDigestAllPasswordVMParamName, String zkDigestReadonlyUsernameVMParamName, String zkDigestReadonlyPasswordVMParamName) {
        this.zkDigestAllUsernameVMParamName = zkDigestAllUsernameVMParamName;
        this.zkDigestAllPasswordVMParamName = zkDigestAllPasswordVMParamName;
        this.zkDigestReadonlyUsernameVMParamName = zkDigestReadonlyUsernameVMParamName;
        this.zkDigestReadonlyPasswordVMParamName = zkDigestReadonlyPasswordVMParamName;
        String pathToFile = System.getProperty(DEFAULT_DIGEST_FILE_VM_PARAM_NAME);
        this.credentialsProps = pathToFile != null ? VMParamsZkCredentialsInjector.readCredentialsFile(pathToFile) : System.getProperties();
    }

    public static Properties readCredentialsFile(String pathToFile) throws SolrException {
        Properties props = new Properties();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(pathToFile), StandardCharsets.UTF_8);){
            props.load(reader);
        }
        catch (IOException ioExc) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)ioExc);
        }
        return props;
    }

    @Override
    public List<ZkCredentialsInjector.ZkCredential> getZkCredentials() {
        final String digestAllUsername = this.credentialsProps.getProperty(this.zkDigestAllUsernameVMParamName);
        final String digestAllPassword = this.credentialsProps.getProperty(this.zkDigestAllPasswordVMParamName);
        final String digestReadonlyUsername = this.credentialsProps.getProperty(this.zkDigestReadonlyUsernameVMParamName);
        final String digestReadonlyPassword = this.credentialsProps.getProperty(this.zkDigestReadonlyPasswordVMParamName);
        ArrayList<ZkCredentialsInjector.ZkCredential> zkCredentials = new ArrayList<ZkCredentialsInjector.ZkCredential>(2){
            {
                super(arg0);
                ZkCredentialsInjector.ZkCredential allUser = new ZkCredentialsInjector.ZkCredential(digestAllUsername, digestAllPassword, ZkCredentialsInjector.ZkCredential.Perms.ALL);
                ZkCredentialsInjector.ZkCredential readUser = new ZkCredentialsInjector.ZkCredential(digestReadonlyUsername, digestReadonlyPassword, ZkCredentialsInjector.ZkCredential.Perms.READ);
                this.add(allUser);
                this.add(readUser);
            }
        };
        log.info("Using zkCredentials: digestAllUsername: {}, digestReadonlyUsername: {}", (Object)digestAllUsername, (Object)digestReadonlyUsername);
        return zkCredentials;
    }
}

