/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.XML;

public class ClientUtils {
    public static final String TEXT_XML = "application/xml; charset=UTF-8";
    public static final String TEXT_JSON = "application/json; charset=UTF-8";

    public static Collection<ContentStream> toContentStreams(String str, String contentType) {
        if (str == null) {
            return null;
        }
        ArrayList<ContentStream> streams = new ArrayList<ContentStream>(1);
        ContentStreamBase.StringStream ccc = new ContentStreamBase.StringStream(str);
        ccc.setContentType(contentType);
        streams.add(ccc);
        return streams;
    }

    public static void writeXML(SolrInputDocument doc, Writer writer) throws IOException {
        writer.write("<doc>");
        for (SolrInputField field : doc) {
            String name = field.getName();
            for (Object v : field) {
                String update = null;
                if (v instanceof SolrInputDocument) {
                    ClientUtils.writeVal(writer, name, v, null);
                    continue;
                }
                if (v instanceof Map) {
                    for (Map.Entry entry : ((Map)v).entrySet()) {
                        update = entry.getKey().toString();
                        v = entry.getValue();
                        if (v instanceof Collection) {
                            Collection values = (Collection)v;
                            for (Object value : values) {
                                ClientUtils.writeVal(writer, name, value, update);
                            }
                            continue;
                        }
                        ClientUtils.writeVal(writer, name, v, update);
                    }
                    continue;
                }
                ClientUtils.writeVal(writer, name, v, update);
            }
        }
        if (doc.hasChildDocuments()) {
            for (SolrInputDocument childDocument : doc.getChildDocuments()) {
                ClientUtils.writeXML(childDocument, writer);
            }
        }
        writer.write("</doc>");
    }

    private static void writeVal(Writer writer, String name, Object v, String update) throws IOException {
        Object bytes;
        if (v instanceof Date) {
            v = ((Date)v).toInstant().toString();
        } else if (v instanceof byte[]) {
            bytes = (byte[])v;
            v = Base64.getEncoder().encodeToString((byte[])bytes);
        } else if (v instanceof ByteBuffer) {
            bytes = (ByteBuffer)v;
            v = new String(Base64.getEncoder().encode(ByteBuffer.wrap(((ByteBuffer)bytes).array(), ((ByteBuffer)bytes).arrayOffset() + ((Buffer)bytes).position(), ((Buffer)bytes).limit() - ((Buffer)bytes).position())).array(), StandardCharsets.ISO_8859_1);
        }
        XML.Writable valWriter = null;
        if (v instanceof SolrInputDocument) {
            SolrInputDocument solrDoc = (SolrInputDocument)v;
            valWriter = writer1 -> ClientUtils.writeXML(solrDoc, writer1);
        } else if (v != null) {
            Object val = v;
            valWriter = writer1 -> XML.escapeCharData(val.toString(), writer1);
        }
        if (update == null) {
            if (v != null) {
                XML.writeXML(writer, "field", valWriter, "name", name);
            }
        } else if (v == null) {
            XML.writeXML(writer, "field", (XML.Writable)null, "name", name, "update", update, "null", true);
        } else {
            XML.writeXML(writer, "field", valWriter, "name", name, "update", update);
        }
    }

    public static String toXML(SolrInputDocument doc) {
        StringWriter str = new StringWriter();
        try {
            ClientUtils.writeXML(doc, str);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str.toString();
    }

    public static String escapeQueryChars(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?' || c == '|' || c == '&' || c == ';' || c == '/' || Character.isWhitespace(c)) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String encodeLocalParamVal(String val) {
        int i;
        int len = val.length();
        if (len > 0 && val.charAt(0) != '$') {
            char ch;
            for (i = 0; i < len && !Character.isWhitespace(ch = val.charAt(i)) && ch != '}'; ++i) {
            }
        }
        if (i >= len) {
            return val;
        }
        StringBuilder sb = new StringBuilder(val.length() + 4);
        sb.append('\'');
        for (i = 0; i < len; ++i) {
            char ch = val.charAt(i);
            if (ch == '\'') {
                sb.append('\\');
            }
            sb.append(ch);
        }
        sb.append('\'');
        return sb.toString();
    }

    public static void addSlices(Map<String, Slice> target, String collectionName, Collection<Slice> slices, boolean multiCollection) {
        for (Slice slice : slices) {
            Object key = slice.getName();
            if (multiCollection) {
                key = collectionName + "_" + (String)key;
            }
            target.put((String)key, slice);
        }
    }
}

