/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.eval.TwoValueWorker;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class TopFeaturesEvaluator
extends RecursiveObjectEvaluator
implements TwoValueWorker {
    protected static final long serialVersionUID = 1L;

    public TopFeaturesEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly 2 values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object value1, Object value2) throws IOException {
        int k = ((Number)value2).intValue();
        if (value1 instanceof Matrix) {
            Matrix matrix = (Matrix)value1;
            List<String> features = matrix.getColumnLabels();
            if (features == null) {
                throw new IOException("Matrix column labels cannot be null for topFeatures function.");
            }
            double[][] data = matrix.getData();
            ArrayList topFeatures = new ArrayList();
            for (int i = 0; i < data.length; ++i) {
                double[] row = data[i];
                ArrayList<String> featuresRow = new ArrayList<String>();
                List<Integer> indexes = this.getMaxIndexes(row, k);
                for (int index : indexes) {
                    featuresRow.add(features.get(index));
                }
                topFeatures.add(featuresRow);
            }
            return topFeatures;
        }
        throw new IOException("The topFeatures function expects a matrix as the first parameter");
    }

    private List<Integer> getMaxIndexes(double[] values, int k) {
        TreeSet<Pair> set = new TreeSet<Pair>();
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] > 0.0)) continue;
            set.add(new Pair(i, values[i]));
            if (set.size() <= k) continue;
            set.pollFirst();
        }
        ArrayList<Integer> top = new ArrayList<Integer>(k);
        while (set.size() > 0) {
            top.add(((Pair)set.pollLast()).getIndex());
        }
        return top;
    }

    public static class Pair
    implements Comparable<Pair> {
        private Integer index;
        private Double value;

        public Pair(int _index, Number value) {
            this.index = _index;
            this.value = value.doubleValue();
        }

        @Override
        public int compareTo(Pair pair) {
            int c = this.value.compareTo(pair.value);
            if (c == 0) {
                return this.index.compareTo(pair.index);
            }
            return c;
        }

        public int getIndex() {
            return this.index;
        }

        public Number getValue() {
            return this.value;
        }
    }
}

