/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.analysis.interpolation.LoessInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.eval.VectorFunction;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class LoessEvaluator
extends RecursiveNumericEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;
    private double bandwidth = 0.25;
    private int robustIterations = 2;

    public LoessEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("bandwidth")) {
                this.bandwidth = Double.parseDouble(namedParam.getParameter().toString().trim());
                continue;
            }
            if (namedParam.getName().equals("robustIterations")) {
                this.robustIterations = Integer.parseInt(namedParam.getParameter().toString().trim());
                continue;
            }
            throw new IOException("Unexpected named parameter:" + namedParam.getName());
        }
    }

    @Override
    public Object doWork(Object ... objects) throws IOException {
        Object first = objects[0];
        double[] x = null;
        double[] y = null;
        if (objects.length == 1) {
            y = ((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
            x = new double[y.length];
            for (int i = 0; i < y.length; ++i) {
                x[i] = i;
            }
        } else if (objects.length == 2) {
            Object second = objects[1];
            x = ((List)first).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
            y = ((List)second).stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
        }
        LoessInterpolator interpolator = new LoessInterpolator(this.bandwidth, this.robustIterations);
        double[] smooth = interpolator.smooth(x, y);
        ArrayList<Double> list = new ArrayList<Double>();
        for (double yvalue : smooth) {
            list.add(yvalue);
        }
        PolynomialSplineFunction spline = interpolator.interpolate(x, y);
        VectorFunction vec = new VectorFunction((Object)spline, list);
        vec.addToContext("x", x);
        vec.addToContext("y", y);
        return vec;
    }

    public static class LoessRegressionTuple
    extends Tuple {
        private PolynomialSplineFunction spline;

        public LoessRegressionTuple(PolynomialSplineFunction spline, Map<String, Object> map) {
            super(map);
            this.spline = spline;
        }

        public double predict(double value) {
            return this.spline.value(value);
        }
    }
}

