/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import org.jdom2.Element;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionUpdateType;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateEns;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeIntv;
import ucar.coord.CoordinateVert;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.CF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.grib.EnsCoord;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribStatType;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.grib.collection.PartitionCollection;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.Misc;
import ucar.nc2.wmo.CommonCodeTable;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Parameter;

public abstract class GribIosp
extends AbstractIOServiceProvider {
    public static final String VARIABLE_ID_ATTNAME = "Grib_Variable_Id";
    public static final String GRIB_VALID_TIME = "GRIB forecast or observation time";
    public static boolean debugRead = false;
    public static int debugIndexOnlyCount = 0;
    static boolean debugIndexOnly = false;
    static boolean debugIndexOnlyShow = false;
    private static final boolean debug = false;
    private static final boolean debugTime = false;
    private static final boolean debugName = false;
    protected FeatureCollectionConfig config = new FeatureCollectionConfig();
    protected final boolean isGrib1;
    protected final Logger logger;
    protected GribCollection gribCollection;
    protected GribCollection.GroupGC gHcs;
    protected GribCollection.Type gtype;
    protected boolean isPartitioned;
    protected boolean owned;
    protected GribTables gribTable;

    public static void setDebugFlags(DebugFlags debugFlag) {
        debugRead = debugFlag.isSet("Grib/showRead");
        debugIndexOnly = debugFlag.isSet("Grib/indexOnly");
        debugIndexOnlyShow = debugFlag.isSet("Grib/indexOnlyShow");
    }

    public void setParamTable(Element paramTable) {
        this.config.gribConfig.paramTable = paramTable;
    }

    public void setLookupTablePath(String lookupTablePath) {
        this.config.gribConfig.lookupTablePath = lookupTablePath;
    }

    public void setParamTablePath(String paramTablePath) {
        this.config.gribConfig.paramTablePath = paramTablePath;
    }

    @Override
    public Object sendIospMessage(Object special) {
        if (special instanceof String) {
            int pos;
            String s = (String)special;
            if (s.startsWith("gribParameterTableLookup")) {
                int pos2 = s.indexOf("=");
                if (pos2 > 0) {
                    this.config.gribConfig.lookupTablePath = s.substring(pos2 + 1).trim();
                }
            } else if (s.startsWith("gribParameterTable") && (pos = s.indexOf("=")) > 0) {
                this.config.gribConfig.paramTablePath = s.substring(pos + 1).trim();
            }
            return null;
        }
        if (special instanceof Element) {
            Element root = (Element)special;
            this.config.gribConfig.configFromXml(root, NcMLReader.ncNS);
            return null;
        }
        return super.sendIospMessage(special);
    }

    public GribIosp(boolean isGrib1, Logger logger) {
        this.isGrib1 = isGrib1;
        this.logger = logger;
    }

    protected abstract GribTables createCustomizer() throws IOException;

    protected abstract String makeVariableName(GribCollection.VariableIndex var1);

    protected abstract String makeVariableNameFromRecord(GribCollection.VariableIndex var1);

    protected abstract String makeVariableLongName(GribCollection.VariableIndex var1);

    protected abstract String makeVariableUnits(GribCollection.VariableIndex var1);

    protected abstract String getVerticalCoordDesc(int var1);

    protected abstract GribTables.Parameter getParameter(GribCollection.VariableIndex var1);

    protected abstract void addGlobalAttributes(NetcdfFile var1);

    protected abstract void addVariableAttributes(Variable var1, GribCollection.VariableIndex var2);

    protected abstract void show(RandomAccessFile var1, long var2) throws IOException;

    protected abstract float[] readData(RandomAccessFile var1, DataRecord var2) throws IOException;

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        if (this.gHcs != null) {
            this.gribCollection = this.gHcs.getGribCollection();
            if (this.gribCollection instanceof PartitionCollection) {
                this.isPartitioned = true;
            }
            this.gribTable = this.createCustomizer();
            this.addGroup(ncfile, ncfile.getRootGroup(), this.gHcs, this.gtype, false);
        } else if (this.gribCollection == null) {
            this.gribCollection = GribCdmIndex.makeGribCollectionFromRaf(raf, this.config, CollectionUpdateType.testIndexOnly, this.logger);
            if (this.gribCollection == null) {
                throw new IllegalStateException("Not a GRIB data file or ncx2 file " + raf.getLocation());
            }
            this.isPartitioned = this.gribCollection instanceof PartitionCollection;
            this.gribTable = this.createCustomizer();
            boolean useDatasetGroup = this.gribCollection.getDatasets().size() > 1;
            for (GribCollection.Dataset ds : this.gribCollection.getDatasets()) {
                Group topGroup;
                if (useDatasetGroup) {
                    topGroup = new Group(ncfile, null, ds.getType().toString());
                    ncfile.addGroup(null, topGroup);
                } else {
                    topGroup = ncfile.getRootGroup();
                }
                Iterable<GribCollection.GroupGC> groups = ds.getGroups();
                boolean useGroups = ds.getGroupsSize() > 1;
                for (GribCollection.GroupGC g : groups) {
                    this.addGroup(ncfile, topGroup, g, ds.getType(), useGroups);
                }
            }
        }
        String val = CommonCodeTable.getCenterName(this.gribCollection.getCenter(), 2);
        ncfile.addAttribute(null, new Attribute("Originating_or_generating_Center", val == null ? Integer.toString(this.gribCollection.getCenter()) : val));
        val = this.gribTable.getSubCenterName(this.gribCollection.getCenter(), this.gribCollection.getSubcenter());
        ncfile.addAttribute(null, new Attribute("Originating_or_generating_Subcenter", val == null ? Integer.toString(this.gribCollection.getSubcenter()) : val));
        ncfile.addAttribute(null, new Attribute("GRIB_table_version", this.gribCollection.getMaster() + "," + this.gribCollection.getLocal()));
        this.addGlobalAttributes(ncfile);
        ncfile.addAttribute(null, new Attribute("Conventions", "CF-1.6"));
        ncfile.addAttribute(null, new Attribute("history", "Read using CDM IOSP GribCollection v2"));
        ncfile.addAttribute(null, new Attribute("featureType", FeatureType.GRID.name()));
        ncfile.addAttribute(null, new Attribute("file_format", this.getFileTypeId()));
        if (this.gribCollection.getParams() != null) {
            for (Parameter p : this.gribCollection.getParams()) {
                ncfile.addAttribute(null, new Attribute(p));
            }
        }
    }

    private void addGroup(NetcdfFile ncfile, Group parent, GribCollection.GroupGC gHcs, GribCollection.Type gctype, boolean useGroups) {
        Group g;
        if (useGroups) {
            g = new Group(ncfile, parent, gHcs.getId());
            g.addAttribute(new Attribute("long_name", gHcs.getDescription()));
            try {
                ncfile.addGroup(parent, g);
            }
            catch (Exception e) {
                this.logger.warn("Duplicate Group - skipping");
                return;
            }
        } else {
            g = parent;
        }
        this.makeGroup(ncfile, g, gHcs, gctype);
    }

    private void makeGroup(NetcdfFile ncfile, Group g, GribCollection.GroupGC gHcs, GribCollection.Type gctype) {
        String horizDims;
        boolean isLatLon;
        GdsHorizCoordSys hcs = gHcs.getGdsHorizCoordSys();
        String grid_mapping = hcs.getName() + "_Projection";
        boolean isLatLon2D = !this.isGrib1 && Grib2Utils.isLatLon2D(hcs.template, this.gribCollection.getCenter());
        boolean bl = isLatLon = this.isGrib1 ? hcs.isLatLon() : Grib2Utils.isLatLon(hcs.template, this.gribCollection.getCenter());
        if (isLatLon2D) {
            horizDims = "lat lon";
            ncfile.addDimension(g, new Dimension("lon", hcs.nx));
            ncfile.addDimension(g, new Dimension("lat", hcs.ny));
        } else if (isLatLon) {
            horizDims = "lat lon";
            ncfile.addDimension(g, new Dimension("lon", hcs.nx));
            ncfile.addDimension(g, new Dimension("lat", hcs.ny));
            Variable cv = ncfile.addVariable(g, new Variable(ncfile, g, null, "lat", DataType.FLOAT, "lat"));
            cv.addAttribute(new Attribute("units", "degrees_north"));
            if (hcs.gaussLats != null) {
                cv.setCachedData(hcs.gaussLats);
            } else {
                cv.setCachedData(Array.makeArray(DataType.FLOAT, hcs.ny, hcs.starty, hcs.dy));
            }
            cv = ncfile.addVariable(g, new Variable(ncfile, g, null, "lon", DataType.FLOAT, "lon"));
            cv.addAttribute(new Attribute("units", "degrees_east"));
            cv.setCachedData(Array.makeArray(DataType.FLOAT, hcs.nx, hcs.startx, hcs.dx));
        } else {
            Variable hcsV = ncfile.addVariable(g, new Variable(ncfile, g, null, grid_mapping, DataType.INT, ""));
            hcsV.setCachedData(Array.factory(DataType.INT, new int[0], (Object)new int[]{0}));
            for (Parameter p : hcs.proj.getProjectionParameters()) {
                hcsV.addAttribute(new Attribute(p));
            }
            horizDims = "y x";
            ncfile.addDimension(g, new Dimension("x", hcs.nx));
            ncfile.addDimension(g, new Dimension("y", hcs.ny));
            Variable cv = ncfile.addVariable(g, new Variable(ncfile, g, null, "x", DataType.FLOAT, "x"));
            cv.addAttribute(new Attribute("standard_name", "projection_x_coordinate"));
            cv.addAttribute(new Attribute("units", "km"));
            cv.setCachedData(Array.makeArray(DataType.FLOAT, hcs.nx, hcs.startx, hcs.dx));
            cv = ncfile.addVariable(g, new Variable(ncfile, g, null, "y", DataType.FLOAT, "y"));
            cv.addAttribute(new Attribute("standard_name", "projection_y_coordinate"));
            cv.addAttribute(new Attribute("units", "km"));
            cv.setCachedData(Array.makeArray(DataType.FLOAT, hcs.ny, hcs.starty, hcs.dy));
        }
        boolean is2Dtime = gctype == GribCollection.Type.TwoD;
        CoordinateRuntime runtime = null;
        for (Coordinate coord : gHcs.coords) {
            Coordinate.Type ctype = coord.getType();
            switch (ctype) {
                case runtime: {
                    runtime = (CoordinateRuntime)coord;
                    this.makeRuntimeCoordinate(ncfile, g, (CoordinateRuntime)coord);
                    break;
                }
                case timeIntv: {
                    if (is2Dtime) {
                        this.makeTimeCoordinate2D(ncfile, g, coord, runtime);
                        break;
                    }
                    this.makeTimeCoordinate1D(ncfile, g, (CoordinateTimeIntv)coord, runtime);
                    break;
                }
                case time: {
                    if (is2Dtime) {
                        this.makeTimeCoordinate2D(ncfile, g, coord, runtime);
                        break;
                    }
                    this.makeTimeCoordinate1D(ncfile, g, (CoordinateTime)coord, runtime);
                    break;
                }
                case vert: {
                    this.makeVerticalCoordinate(ncfile, g, (CoordinateVert)coord);
                    break;
                }
                case ens: {
                    this.makeEnsembleCoordinate(ncfile, g, (CoordinateEns)coord);
                    break;
                }
                case time2D: {
                    this.makeTime2D(ncfile, g, (CoordinateTime2D)coord, is2Dtime);
                }
            }
        }
        for (GribCollection.VariableIndex vindex : gHcs.variList) {
            Formatter dims = new Formatter();
            Formatter coords = new Formatter();
            for (Coordinate coord : vindex.getCoordinates()) {
                if (!is2Dtime && coord.getType() == Coordinate.Type.runtime) continue;
                String coordName = coord.getType() == Coordinate.Type.vert ? coord.getName().toLowerCase() : coord.getName();
                dims.format("%s ", coordName);
                coords.format("%s ", coordName);
            }
            dims.format("%s", horizDims);
            String vname = this.makeVariableName(vindex);
            Variable v = new Variable(ncfile, g, null, vname, DataType.FLOAT, dims.toString());
            ncfile.addVariable(g, v);
            String desc = this.makeVariableLongName(vindex);
            v.addAttribute(new Attribute("long_name", desc));
            v.addAttribute(new Attribute("units", this.makeVariableUnits(vindex)));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(Float.NaN)));
            GribTables.Parameter gp = this.getParameter(vindex);
            if (gp != null) {
                if (gp.getDescription() != null) {
                    v.addAttribute(new Attribute("description", gp.getDescription()));
                }
                if (gp.getAbbrev() != null) {
                    v.addAttribute(new Attribute("abbreviation", gp.getAbbrev()));
                }
            }
            if (isLatLon2D) {
                String s = this.searchCoord(Grib2Utils.getLatLon2DcoordType(desc), gHcs.variList);
                if (s == null) {
                    v.setDimensions(horizDims);
                    String units = desc.contains("Latitude of") ? "degrees_north" : "degrees_east";
                    v.addAttribute(new Attribute("units", units));
                } else {
                    coords.format("%s ", s);
                }
            } else if (!hcs.isLatLon()) {
                v.addAttribute(new Attribute("grid_mapping", grid_mapping));
            }
            v.addAttribute(new Attribute("coordinates", coords.toString()));
            if (vindex.intvType >= 0) {
                GribStatType statType = this.gribTable.getStatType(vindex.intvType);
                if (statType != null) {
                    v.addAttribute(new Attribute("Grib_Statistical_Interval_Type", statType.toString()));
                    CF.CellMethods cm = GribStatType.getCFCellMethod(statType);
                    Coordinate timeCoord = vindex.getCoordinate(Coordinate.Type.timeIntv);
                    if (cm != null && timeCoord != null) {
                        v.addAttribute(new Attribute("cell_methods", timeCoord.getName() + ": " + cm.toString()));
                    }
                } else {
                    v.addAttribute(new Attribute("Grib_Statistical_Interval_Type", vindex.intvType));
                }
            }
            this.addVariableAttributes(v, vindex);
            v.setSPobject(vindex);
        }
    }

    private void makeRuntimeCoordinate(NetcdfFile ncfile, Group g, CoordinateRuntime rtc) {
        int n = rtc.getSize();
        String tcName = rtc.getName();
        ncfile.addDimension(g, new Dimension(tcName, n));
        Variable v = ncfile.addVariable(g, new Variable(ncfile, g, null, tcName, DataType.DOUBLE, tcName));
        v.addAttribute(new Attribute("units", rtc.getUnit()));
        v.addAttribute(new Attribute("standard_name", "forecast_reference_time"));
        v.addAttribute(new Attribute("long_name", "GRIB reference time"));
        v.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        String vsName = tcName + "_ISO";
        Variable vs = ncfile.addVariable(g, new Variable(ncfile, g, null, vsName, DataType.STRING, tcName));
        vs.addAttribute(new Attribute("units", "ISO8601"));
        v.addAttribute(new Attribute("long_name", "GRIB reference time"));
        v.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        String[] dataS = new String[n];
        int count = 0;
        for (CalendarDate val : rtc.getRuntimesSorted()) {
            dataS[count++] = val.toString();
        }
        vs.setCachedData(Array.factory(DataType.STRING, new int[]{n}, (Object)dataS));
        double[] data = new double[n];
        count = 0;
        for (double val : rtc.getOffsetsInTimeUnits()) {
            data[count++] = val;
        }
        v.setCachedData(Array.factory(DataType.DOUBLE, new int[]{n}, (Object)data));
    }

    private void makeTime2D(NetcdfFile ncfile, Group g, CoordinateTime2D time2D, boolean is2Dtime) {
        CoordinateRuntime runtime = time2D.getRuntimeCoordinate();
        int ntimes = time2D.getNtimes();
        String tcName = time2D.getName();
        String dims = is2Dtime ? runtime.getName() + " " + tcName : tcName;
        ncfile.addDimension(g, new Dimension(tcName, ntimes));
        Variable v = ncfile.addVariable(g, new Variable(ncfile, g, null, tcName, DataType.DOUBLE, dims));
        String units = runtime.getUnit();
        v.addAttribute(new Attribute("units", units));
        v.addAttribute(new Attribute("standard_name", "time"));
        v.addAttribute(new Attribute("long_name", GRIB_VALID_TIME));
        v.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        if (!time2D.isTimeInterval()) {
            v.setSPobject(new Time2Dinfo(Time2DinfoType.off, time2D, is2Dtime));
        } else {
            v.setSPobject(new Time2Dinfo(Time2DinfoType.intv, time2D, is2Dtime));
            String bounds_name = tcName + "_bounds";
            Variable bounds = ncfile.addVariable(g, new Variable(ncfile, g, null, bounds_name, DataType.DOUBLE, dims + " 2"));
            v.addAttribute(new Attribute("bounds", bounds_name));
            bounds.addAttribute(new Attribute("units", units));
            bounds.addAttribute(new Attribute("long_name", "bounds for " + tcName));
            bounds.setSPobject(new Time2Dinfo(Time2DinfoType.bounds, time2D, is2Dtime));
        }
    }

    private Array makeTime2Darray(Time2Dinfo info) {
        CoordinateTime2D time2D = info.time2D;
        CoordinateRuntime runtime = time2D.getRuntimeCoordinate();
        int nruns = runtime.getSize();
        int ntimes = time2D.getNtimes();
        double[] data = new double[nruns * ntimes];
        for (int i = 0; i < nruns * ntimes; ++i) {
            data[i] = Double.NaN;
        }
        switch (info.which) {
            case off: {
                int[] nArray;
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTime coordTime = (CoordinateTime)time2D.getTimeCoordinate(runIdx);
                    int timeIdx = 0;
                    for (int val : coordTime.getOffsetSorted()) {
                        data[runIdx * ntimes + timeIdx] = val + time2D.getOffset(runIdx);
                        ++timeIdx;
                    }
                }
                if (info.is2Dtime) {
                    int[] nArray2 = new int[2];
                    nArray2[0] = nruns;
                    nArray = nArray2;
                    nArray2[1] = ntimes;
                } else {
                    int[] nArray3 = new int[1];
                    nArray = nArray3;
                    nArray3[0] = ntimes;
                }
                int[] shape = nArray;
                return Array.factory(DataType.DOUBLE, shape, (Object)data);
            }
            case intv: {
                int[] nArray;
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                    int timeIdx = 0;
                    for (TimeCoord.Tinv tinv : timeIntv.getTimeIntervals()) {
                        data[runIdx * ntimes + timeIdx] = tinv.getBounds2() + time2D.getOffset(runIdx);
                        ++timeIdx;
                    }
                }
                if (info.is2Dtime) {
                    int[] nArray4 = new int[2];
                    nArray4[0] = nruns;
                    nArray = nArray4;
                    nArray4[1] = ntimes;
                } else {
                    int[] nArray5 = new int[1];
                    nArray = nArray5;
                    nArray5[0] = ntimes;
                }
                int[] shape = nArray;
                return Array.factory(DataType.DOUBLE, shape, (Object)data);
            }
            case bounds: {
                int[] nArray;
                data = new double[nruns * ntimes * 2];
                for (int i = 0; i < nruns * ntimes * 2; ++i) {
                    data[i] = Double.NaN;
                }
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                    int timeIdx = 0;
                    for (TimeCoord.Tinv tinv : timeIntv.getTimeIntervals()) {
                        data[runIdx * ntimes * 2 + timeIdx] = tinv.getBounds1() + time2D.getOffset(runIdx);
                        data[runIdx * ntimes * 2 + timeIdx + 1] = tinv.getBounds2() + time2D.getOffset(runIdx);
                        timeIdx += 2;
                    }
                }
                if (info.is2Dtime) {
                    int[] nArray6 = new int[3];
                    nArray6[0] = nruns;
                    nArray6[1] = ntimes;
                    nArray = nArray6;
                    nArray6[2] = 2;
                } else {
                    int[] nArray7 = new int[2];
                    nArray7[0] = ntimes;
                    nArray = nArray7;
                    nArray7[1] = 2;
                }
                int[] shapeb = nArray;
                return Array.factory(DataType.DOUBLE, shapeb, (Object)data);
            }
        }
        return null;
    }

    private void makeTimeCoordinate2D(NetcdfFile ncfile, Group g, Coordinate tc, CoordinateRuntime runtime) {
        int nruns = runtime.getSize();
        int ntimes = tc.getSize();
        String tcName = tc.getName();
        String dims = runtime.getName() + " " + tc.getName();
        ncfile.addDimension(g, new Dimension(tcName, ntimes));
        Variable v = ncfile.addVariable(g, new Variable(ncfile, g, null, tcName, DataType.DOUBLE, dims));
        String units = tc.getUnit() + " since " + runtime.getFirstDate();
        v.addAttribute(new Attribute("units", units));
        v.addAttribute(new Attribute("standard_name", "time"));
        v.addAttribute(new Attribute("long_name", GRIB_VALID_TIME));
        v.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        double[] data = new double[nruns * ntimes];
        int count = 0;
        if (tc instanceof CoordinateTime) {
            CoordinateTime coordTime = (CoordinateTime)tc;
            CalendarPeriod period = coordTime.getPeriod();
            for (CalendarDate cd : runtime.getRuntimesSorted()) {
                double offset = period.getOffset(runtime.getFirstDate(), cd);
                for (int val : coordTime.getOffsetSorted()) {
                    data[count++] = offset + (double)val;
                }
            }
            v.setCachedData(Array.factory(DataType.DOUBLE, new int[]{nruns, ntimes}, (Object)data));
        } else if (tc instanceof CoordinateTimeIntv) {
            CoordinateTimeIntv coordTime = (CoordinateTimeIntv)tc;
            CalendarPeriod period = coordTime.getPeriod();
            for (CalendarDate cd : runtime.getRuntimesSorted()) {
                double offset = period.getOffset(runtime.getFirstDate(), cd);
                for (TimeCoord.Tinv tinv : coordTime.getTimeIntervals()) {
                    data[count++] = offset + (double)tinv.getBounds2();
                }
            }
            v.setCachedData(Array.factory(DataType.DOUBLE, new int[]{nruns, ntimes}, (Object)data));
            String bounds_name = tcName + "_bounds";
            Variable bounds = ncfile.addVariable(g, new Variable(ncfile, g, null, bounds_name, DataType.DOUBLE, dims + " 2"));
            v.addAttribute(new Attribute("bounds", bounds_name));
            bounds.addAttribute(new Attribute("units", units));
            bounds.addAttribute(new Attribute("long_name", "bounds for " + tcName));
            data = new double[nruns * ntimes * 2];
            count = 0;
            for (CalendarDate cd : runtime.getRuntimesSorted()) {
                double offset = period.getOffset(runtime.getFirstDate(), cd);
                for (TimeCoord.Tinv tinv : coordTime.getTimeIntervals()) {
                    data[count++] = offset + (double)tinv.getBounds1();
                    data[count++] = offset + (double)tinv.getBounds2();
                }
            }
            bounds.setCachedData(Array.factory(DataType.DOUBLE, new int[]{nruns, ntimes, 2}, (Object)data));
        }
    }

    private void makeTimeCoordinate1D(NetcdfFile ncfile, Group g, CoordinateTime coordTime, CoordinateRuntime runtime) {
        int ntimes = coordTime.getSize();
        String tcName = coordTime.getName();
        String dims = coordTime.getName();
        ncfile.addDimension(g, new Dimension(tcName, ntimes));
        Variable v = ncfile.addVariable(g, new Variable(ncfile, g, null, tcName, DataType.DOUBLE, dims));
        String units = coordTime.getUnit() + " since " + runtime.getFirstDate();
        v.addAttribute(new Attribute("units", units));
        v.addAttribute(new Attribute("standard_name", "time"));
        v.addAttribute(new Attribute("long_name", GRIB_VALID_TIME));
        v.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        double[] data = new double[ntimes];
        int count = 0;
        for (int val : coordTime.getOffsetSorted()) {
            data[count++] = val;
        }
        v.setCachedData(Array.factory(DataType.DOUBLE, new int[]{ntimes}, (Object)data));
    }

    private void makeTimeCoordinate1D(NetcdfFile ncfile, Group g, CoordinateTimeIntv coordTime, CoordinateRuntime runtime) {
        int ntimes = coordTime.getSize();
        String tcName = coordTime.getName();
        String dims = coordTime.getName();
        ncfile.addDimension(g, new Dimension(tcName, ntimes));
        Variable v = ncfile.addVariable(g, new Variable(ncfile, g, null, tcName, DataType.DOUBLE, dims));
        String units = coordTime.getUnit() + " since " + runtime.getFirstDate();
        v.addAttribute(new Attribute("units", units));
        v.addAttribute(new Attribute("standard_name", "time"));
        v.addAttribute(new Attribute("long_name", GRIB_VALID_TIME));
        v.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        double[] data = new double[ntimes];
        int count = 0;
        CalendarPeriod period = coordTime.getPeriod();
        for (TimeCoord.Tinv tinv : coordTime.getTimeIntervals()) {
            data[count++] = tinv.getBounds2();
        }
        v.setCachedData(Array.factory(DataType.DOUBLE, new int[]{ntimes}, (Object)data));
        String bounds_name = tcName + "_bounds";
        Variable bounds = ncfile.addVariable(g, new Variable(ncfile, g, null, bounds_name, DataType.DOUBLE, dims + " 2"));
        v.addAttribute(new Attribute("bounds", bounds_name));
        bounds.addAttribute(new Attribute("units", units));
        bounds.addAttribute(new Attribute("long_name", "bounds for " + tcName));
        data = new double[ntimes * 2];
        count = 0;
        for (TimeCoord.Tinv tinv : coordTime.getTimeIntervals()) {
            data[count++] = tinv.getBounds1();
            data[count++] = tinv.getBounds2();
        }
        bounds.setCachedData(Array.factory(DataType.DOUBLE, new int[]{ntimes, 2}, (Object)data));
    }

    private void makeVerticalCoordinate(NetcdfFile ncfile, Group g, CoordinateVert vc) {
        int n = vc.getSize();
        String vcName = vc.getName().toLowerCase();
        ncfile.addDimension(g, new Dimension(vcName, n));
        Variable v = ncfile.addVariable(g, new Variable(ncfile, g, null, vcName, DataType.FLOAT, vcName));
        if (vc.getUnit() != null) {
            v.addAttribute(new Attribute("units", vc.getUnit()));
            String desc = this.getVerticalCoordDesc(vc.getCode());
            if (desc != null) {
                v.addAttribute(new Attribute("long_name", desc));
            }
            v.addAttribute(new Attribute("positive", vc.isPositiveUp() ? "up" : "down"));
        }
        v.addAttribute(new Attribute("Grib_level_type", vc.getCode()));
        VertCoord.VertUnit vu = vc.getVertUnit();
        if (vu != null && vu.getDatum() != null) {
            v.addAttribute(new Attribute("datum", vu.getDatum()));
        }
        if (vc.isLayer()) {
            float[] data = new float[n];
            int count = 0;
            for (VertCoord.Level val : vc.getLevelSorted()) {
                data[count++] = (float)(val.getValue1() + val.getValue2()) / 2.0f;
            }
            v.setCachedData(Array.factory(DataType.FLOAT, new int[]{n}, (Object)data));
            Variable bounds = ncfile.addVariable(g, new Variable(ncfile, g, null, vcName + "_bounds", DataType.FLOAT, vcName + " 2"));
            v.addAttribute(new Attribute("bounds", vcName + "_bounds"));
            String vcUnit = vc.getUnit();
            if (vcUnit != null) {
                bounds.addAttribute(new Attribute("units", vcUnit));
            }
            bounds.addAttribute(new Attribute("long_name", "bounds for " + vcName));
            data = new float[2 * n];
            count = 0;
            for (VertCoord.Level level : vc.getLevelSorted()) {
                data[count++] = (float)level.getValue1();
                data[count++] = (float)level.getValue2();
            }
            bounds.setCachedData(Array.factory(DataType.FLOAT, new int[]{n, 2}, (Object)data));
        } else {
            float[] data = new float[n];
            int count = 0;
            for (VertCoord.Level val : vc.getLevelSorted()) {
                data[count++] = (float)val.getValue1();
            }
            v.setCachedData(Array.factory(DataType.FLOAT, new int[]{n}, (Object)data));
        }
    }

    private void makeEnsembleCoordinate(NetcdfFile ncfile, Group g, CoordinateEns ec) {
        int n = ec.getSize();
        String ecName = ec.getName().toLowerCase();
        ncfile.addDimension(g, new Dimension(ecName, n));
        Variable v = new Variable(ncfile, g, null, ecName, DataType.INT, ecName);
        ncfile.addVariable(g, v);
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Ensemble.toString()));
        int[] data = new int[n];
        int count = 0;
        for (EnsCoord.Coord ecc : ec.getEnsSorted()) {
            data[count++] = ecc.getEnsMember();
        }
        v.setCachedData(Array.factory(DataType.INT, new int[]{n}, (Object)data));
    }

    private String searchCoord(Grib2Utils.LatLonCoordType type, List<GribCollection.VariableIndex> list) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case U: {
                GribCollection.VariableIndex lat = this.searchCoord(list, 198);
                GribCollection.VariableIndex lon = this.searchCoord(list, 199);
                return lat != null && lon != null ? this.makeVariableName(lat) + " " + this.makeVariableName(lon) : null;
            }
            case V: {
                GribCollection.VariableIndex lat = this.searchCoord(list, 200);
                GribCollection.VariableIndex lon = this.searchCoord(list, 201);
                return lat != null && lon != null ? this.makeVariableName(lat) + " " + this.makeVariableName(lon) : null;
            }
            case P: {
                GribCollection.VariableIndex lat = this.searchCoord(list, 202);
                GribCollection.VariableIndex lon = this.searchCoord(list, 203);
                return lat != null && lon != null ? this.makeVariableName(lat) + "  " + this.makeVariableName(lon) : null;
            }
        }
        return null;
    }

    private GribCollection.VariableIndex searchCoord(List<GribCollection.VariableIndex> list, int p) {
        for (GribCollection.VariableIndex vindex : list) {
            if (vindex.discipline != 0 || vindex.category != 2 || vindex.parameter != p) continue;
            return vindex;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (!this.owned && this.gribCollection != null) {
            this.gribCollection.close();
        }
        this.gribCollection = null;
        super.close();
    }

    @Override
    public String getDetailInfo() {
        Formatter f = new Formatter();
        f.format("%s", super.getDetailInfo());
        if (this.gribCollection != null) {
            this.gribCollection.showIndex(f);
        }
        return f.toString();
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        long start = System.currentTimeMillis();
        if (v2.getSPobject() instanceof Time2Dinfo) {
            Time2Dinfo info = (Time2Dinfo)v2.getSPobject();
            Array data = this.makeTime2Darray(info);
            Section sectionFilled = Section.fill(section, v2.getShape());
            return data.sectionNoReduce(sectionFilled.getRanges());
        }
        Array result = this.isPartitioned ? this.readDataFromPartition(v2, section, null) : this.readDataFromCollection(v2, section, null);
        long took = System.currentTimeMillis() - start;
        return result;
    }

    @Override
    public long streamToByteChannel(Variable v2, Section section, WritableByteChannel channel) throws IOException, InvalidRangeException {
        long start = System.currentTimeMillis();
        this.readDataFromCollection(v2, section, channel);
        long took = System.currentTimeMillis() - start;
        return 0L;
    }

    private Array readDataFromCollection(Variable v, Section section, WritableByteChannel channel) throws IOException, InvalidRangeException {
        GribCollection.VariableIndex vindex = (GribCollection.VariableIndex)v.getSPobject();
        vindex.readRecords();
        int sectionLen = section.getRank();
        Range yRange = section.getRange(sectionLen - 2);
        Range xRange = section.getRange(sectionLen - 1);
        Section sectionWanted = section.subSection(0, sectionLen - 2);
        Section.Iterator iterWanted = sectionWanted.getIterator(v.getShape());
        int[] indexWanted = new int[sectionLen - 2];
        DataReader dataReader = new DataReader(vindex);
        int count = 0;
        while (iterWanted.hasNext()) {
            int sourceIndex = iterWanted.next(indexWanted);
            dataReader.addRecord(sourceIndex, count++);
        }
        DataReceiverIF dataReceiver = channel == null ? new DataReceiver(section, yRange, xRange) : new ChannelReceiver(channel, yRange, xRange);
        dataReader.read(dataReceiver);
        return dataReceiver.getArray();
    }

    private Array readDataFromPartition(Variable v, Section section, WritableByteChannel channel) throws IOException, InvalidRangeException {
        PartitionCollection.VariableIndexPartitioned vindexP = (PartitionCollection.VariableIndexPartitioned)v.getSPobject();
        int sectionLen = section.getRank();
        Range yRange = section.getRange(sectionLen - 2);
        Range xRange = section.getRange(sectionLen - 1);
        Section sectionWanted = section.subSection(0, sectionLen - 2);
        Section.Iterator iterWanted = sectionWanted.getIterator(v.getShape());
        int[] indexWanted = new int[sectionLen - 2];
        DataReaderPartitioned dataReader = new DataReaderPartitioned();
        int resultPos = 0;
        while (iterWanted.hasNext()) {
            iterWanted.next(indexWanted);
            PartitionCollection.DataRecord record = vindexP.getDataRecord(indexWanted);
            if (record == null) {
                if (debugRead) {
                    System.out.printf("readDataFromPartition missing data%n", new Object[0]);
                }
                ++resultPos;
                continue;
            }
            record.resultIndex = resultPos++;
            dataReader.addRecord(record);
        }
        DataReceiverIF dataReceiver = channel == null ? new DataReceiver(section, yRange, xRange) : new ChannelReceiver(channel, yRange, xRange);
        dataReader.read(dataReceiver);
        vindexP.cleanup();
        return dataReceiver.getArray();
    }

    public abstract Object getLastRecordRead();

    public abstract void clearLastRecordRead();

    public abstract Object getGribCustomizer();

    private class DataReaderPartitioned {
        List<PartitionCollection.DataRecord> records = new ArrayList<PartitionCollection.DataRecord>();

        private DataReaderPartitioned() {
        }

        void addRecord(PartitionCollection.DataRecord dr) {
            if (dr != null) {
                this.records.add(dr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void read(DataReceiverIF dataReceiver) throws IOException {
            Collections.sort(this.records);
            PartitionCollection.DataRecord lastRecord = null;
            try (RandomAccessFile rafData = null;){
                for (PartitionCollection.DataRecord dr : this.records) {
                    if (debugIndexOnly) {
                        ++debugIndexOnlyCount;
                        if (debugIndexOnlyShow) {
                            dr.show();
                        }
                        GdsHorizCoordSys hcs = dr.hcs;
                        float[] data = new float[hcs.nx * hcs.ny];
                        dataReceiver.addData(data, dr.resultIndex, hcs.nx);
                        continue;
                    }
                    if (rafData == null || !dr.usesSameFile(lastRecord)) {
                        if (rafData != null) {
                            rafData.close();
                        }
                        rafData = dr.usePartition.getRaf(dr.partno, dr.fileno);
                    }
                    lastRecord = dr;
                    if (dr.dataPos == -1L) continue;
                    if (debugRead) {
                        GribIosp.this.show(rafData, dr.dataPos);
                    }
                    float[] data = GribIosp.this.readData(rafData, dr);
                    GdsHorizCoordSys hcs = dr.hcs;
                    dataReceiver.addData(data, dr.resultIndex, hcs.nx);
                }
            }
        }
    }

    private static class ChannelReceiver
    implements DataReceiverIF {
        private WritableByteChannel channel;
        private DataOutputStream outStream;
        private Range yRange;
        private Range xRange;

        ChannelReceiver(WritableByteChannel channel, Range yRange, Range xRange) {
            this.channel = channel;
            this.outStream = new DataOutputStream(Channels.newOutputStream(channel));
            this.yRange = yRange;
            this.xRange = xRange;
        }

        @Override
        public void addData(float[] data, int resultIndex, int nx) throws IOException {
            for (int y = this.yRange.first(); y <= this.yRange.last(); y += this.yRange.stride()) {
                for (int x = this.xRange.first(); x <= this.xRange.last(); x += this.xRange.stride()) {
                    int dataIdx = y * nx + x;
                    this.outStream.writeFloat(data[dataIdx]);
                }
            }
        }

        @Override
        public Array getArray() {
            return null;
        }
    }

    private static class DataReceiver
    implements DataReceiverIF {
        private Array dataArray;
        private Range yRange;
        private Range xRange;
        private int horizSize;

        DataReceiver(Section section, Range yRange, Range xRange) {
            this.dataArray = Array.factory(DataType.FLOAT, section.getShape());
            this.yRange = yRange;
            this.xRange = xRange;
            this.horizSize = yRange.length() * xRange.length();
            IndexIterator iter = this.dataArray.getIndexIterator();
            while (iter.hasNext()) {
                iter.setFloatNext(Float.NaN);
            }
        }

        @Override
        public void addData(float[] data, int resultIndex, int nx) throws IOException {
            int start = resultIndex * this.horizSize;
            int count = 0;
            for (int y = this.yRange.first(); y <= this.yRange.last(); y += this.yRange.stride()) {
                for (int x = this.xRange.first(); x <= this.xRange.last(); x += this.xRange.stride()) {
                    int dataIdx = y * nx + x;
                    if (dataIdx >= data.length) {
                        System.out.println("HEY");
                    }
                    this.dataArray.setFloat(start + count, data[dataIdx]);
                    ++count;
                }
            }
        }

        @Override
        public Array getArray() {
            return this.dataArray;
        }
    }

    private static interface DataReceiverIF {
        public void addData(float[] var1, int var2, int var3) throws IOException;

        public Array getArray();
    }

    protected class DataReader {
        GribCollection.VariableIndex vindex;
        List<DataRecord> records = new ArrayList<DataRecord>();

        private DataReader(GribCollection.VariableIndex vindex) {
            this.vindex = vindex;
        }

        void addRecord(int sourceIndex, int resultIndex) {
            GribCollection.Record record = this.vindex.getSparseArray().getContent(sourceIndex);
            if (debugRead) {
                System.out.printf("GribIosp debugRead sourceIndex=%d resultIndex=%d record is null=%s%n", sourceIndex, resultIndex, record == null);
            }
            if (record != null) {
                this.records.add(new DataRecord(resultIndex, record.fileno, record.pos, record.bmsPos, record.scanMode, this.vindex.group.getGdsHorizCoordSys()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void read(DataReceiverIF dataReceiver) throws IOException {
            Collections.sort(this.records);
            int currFile = -1;
            try (RandomAccessFile rafData = null;){
                for (DataRecord dr : this.records) {
                    if (debugIndexOnly) {
                        ++debugIndexOnlyCount;
                        if (debugIndexOnlyShow) {
                            dr.show(GribIosp.this.gribCollection);
                        }
                        GdsHorizCoordSys hcs = dr.hcs;
                        float[] data = new float[hcs.nx * hcs.ny];
                        dataReceiver.addData(data, dr.resultIndex, hcs.nx);
                        continue;
                    }
                    if (dr.fileno != currFile) {
                        if (rafData != null) {
                            rafData.close();
                        }
                        rafData = GribIosp.this.gribCollection.getDataRaf(dr.fileno);
                        currFile = dr.fileno;
                    }
                    if (dr.dataPos == -1L) continue;
                    if (debugRead && rafData != null) {
                        GribIosp.this.show(rafData, dr.dataPos);
                    }
                    float[] data = GribIosp.this.readData(rafData, dr);
                    GdsHorizCoordSys hcs = this.vindex.group.getGdsHorizCoordSys();
                    dataReceiver.addData(data, dr.resultIndex, hcs.nx);
                }
            }
        }
    }

    static class DataRecord
    implements Comparable<DataRecord> {
        int resultIndex;
        int fileno;
        long dataPos;
        long bmsPos;
        int scanMode;
        GdsHorizCoordSys hcs;

        DataRecord(int resultIndex, int fileno, long dataPos, long bmsPos, int scanMode, GdsHorizCoordSys hcs) {
            this.resultIndex = resultIndex;
            this.fileno = fileno;
            this.dataPos = dataPos;
            this.bmsPos = bmsPos;
            this.scanMode = scanMode;
            this.hcs = hcs;
        }

        @Override
        public int compareTo(DataRecord o) {
            int r = Misc.compare(this.fileno, o.fileno);
            if (r != 0) {
                return r;
            }
            return Misc.compare(this.dataPos, o.dataPos);
        }

        public void show(GribCollection gribCollection) throws IOException {
            String dataFilename = gribCollection.getFilename(this.fileno);
            System.out.printf(" fileno=%d filename=%s datapos=%d%n", this.fileno, dataFilename, this.dataPos);
        }
    }

    private static class Time2Dinfo {
        Time2DinfoType which;
        CoordinateTime2D time2D;
        boolean is2Dtime;

        private Time2Dinfo(Time2DinfoType which, CoordinateTime2D time2D, boolean is2Dtime) {
            this.which = which;
            this.time2D = time2D;
            this.is2Dtime = is2Dtime;
        }
    }

    private static enum Time2DinfoType {
        off,
        intv,
        bounds;

    }
}

