/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.selectors;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ElementSubsequent;
import com.github.sommeri.less4j.core.ast.SelectorPart;
import com.github.sommeri.less4j.core.ast.SimpleSelector;
import com.github.sommeri.less4j.core.compiler.selectors.SimpleSelectorComparator;
import com.github.sommeri.less4j.core.problems.BugHappened;
import com.github.sommeri.less4j.utils.ListsComparator;
import java.util.List;

public class SelectorPartComparator
implements ListsComparator.ListMemberComparator<SelectorPart> {
    private final SimpleSelectorComparator simpleSelectorComparator;

    public SelectorPartComparator(SimpleSelectorComparator simpleSelectorComparator) {
        this.simpleSelectorComparator = simpleSelectorComparator;
    }

    @Override
    public boolean equals(SelectorPart first, SelectorPart second) {
        if (!this.prefix(first, second)) {
            return false;
        }
        List<ElementSubsequent> firstSubsequent = ((SimpleSelector)first).getSubsequent();
        List<ElementSubsequent> secondSubsequent = ((SimpleSelector)second).getSubsequent();
        return firstSubsequent.size() == secondSubsequent.size();
    }

    @Override
    public boolean prefix(SelectorPart lookFor, SelectorPart inside) {
        this.validateSimpleSelector(lookFor);
        this.validateSimpleSelector(inside);
        return this.simpleSelectorComparator.prefix((SimpleSelector)lookFor, (SimpleSelector)inside);
    }

    private void validateSimpleSelector(SelectorPart selector) {
        if (selector.getType() != ASTCssNodeType.SIMPLE_SELECTOR) {
            throw new BugHappened("Unexpected selector part type " + (Object)((Object)selector.getType()) + ". Anything but simple selector should have been removed from tree. ", (ASTCssNode)selector);
        }
    }

    @Override
    public boolean suffix(SelectorPart lookFor, SelectorPart inside) {
        this.validateSimpleSelector(lookFor);
        this.validateSimpleSelector(inside);
        return this.simpleSelectorComparator.suffix((SimpleSelector)lookFor, (SimpleSelector)inside);
    }

    public SelectorPart cutSuffix(SelectorPart lookFor, SelectorPart inside) {
        this.validateSimpleSelector(lookFor);
        this.validateSimpleSelector(inside);
        SimpleSelector remainder = this.simpleSelectorComparator.cutSuffix((SimpleSelector)lookFor, (SimpleSelector)inside);
        return remainder;
    }

    public SelectorPart cutPrefix(SelectorPart lookFor, SelectorPart inside) {
        this.validateSimpleSelector(lookFor);
        this.validateSimpleSelector(inside);
        SimpleSelector remainder = this.simpleSelectorComparator.cutPrefix((SimpleSelector)lookFor, (SimpleSelector)inside);
        return remainder;
    }

    @Override
    public boolean contains(SelectorPart lookFor, SelectorPart inside) {
        this.validateSimpleSelector(lookFor);
        this.validateSimpleSelector(inside);
        return this.simpleSelectorComparator.contains((SimpleSelector)lookFor, (SimpleSelector)inside);
    }

    public SelectorPart[] splitOn(SelectorPart lookFor, SelectorPart inside) {
        this.validateSimpleSelector(lookFor);
        this.validateSimpleSelector(inside);
        return this.simpleSelectorComparator.splitOn((SimpleSelector)lookFor, (SimpleSelector)inside);
    }
}

