/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class VariableCycleDetector {
    private Stack<String> names = new Stack();
    private Stack<Variable> variables = new Stack();

    protected VariableCycleDetector() {
    }

    public boolean wouldCycle(Variable input) {
        return this.names.contains(input.getName());
    }

    public void leftVariableValue() {
        this.names.pop();
        this.variables.pop();
    }

    public void enteringVariableValue(Variable input) {
        this.names.add(input.getName());
        this.variables.add(input);
    }

    public List<Variable> getCycleFor(Variable input) {
        if (!this.wouldCycle(input)) {
            return Collections.emptyList();
        }
        int position = this.names.indexOf(input.getName());
        ArrayList<Variable> result = new ArrayList<Variable>(this.variables.subList(position, this.variables.size()));
        result.add(input);
        return result;
    }
}

