/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.EmbeddedScript;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FaultyExpression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.compiler.expressions.Function;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.List;

class ScriptFunction
implements Function {
    private final String name;
    private final String errorName;

    public ScriptFunction(String name, String errorName) {
        this.name = name;
        this.errorName = errorName;
    }

    @Override
    public Expression evaluate(List<Expression> parameters, ProblemsHandler problemsHandler, FunctionExpression call, Expression evaluatedParameter) {
        Expression parameter;
        if (parameters.size() > 1) {
            problemsHandler.wrongNumberOfArgumentsToFunctionMin(call.getParameter(), call.getName(), 1);
        }
        if (!((parameter = parameters.get(0)) instanceof EmbeddedScript)) {
            problemsHandler.wrongArgumentTypeToFunction(parameter, this.name + "...`", parameter.getType(), ASTCssNodeType.EMBEDDED_SCRIPT);
            return new FaultyExpression(call);
        }
        this.warn(call, problemsHandler);
        EmbeddedScript parameterAsStr = (EmbeddedScript)parameter;
        String value = this.name + parameterAsStr.getValue() + "`";
        return new CssString(call.getUnderlyingStructure(), value, "");
    }

    private void warn(FunctionExpression call, ProblemsHandler problemsHandler) {
        problemsHandler.warnScriptingNotSupported(call, this.errorName);
    }

    @Override
    public boolean acceptsParameters(List<Expression> parameters) {
        return true;
    }
}

