/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.ListExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.compiler.expressions.AbtractMultiParameterMathFunction;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.List;

class Length
extends AbtractMultiParameterMathFunction {
    Length() {
    }

    @Override
    protected String getName() {
        return "length";
    }

    @Override
    protected Expression evaluate(List<Expression> splitParameters, ProblemsHandler problemsHandler, FunctionExpression call, HiddenTokenAwareTree token) {
        Expression expression = splitParameters.get(0);
        if (expression.getType() != ASTCssNodeType.LIST_EXPRESSION) {
            return new NumberExpression(call.getUnderlyingStructure(), 1.0, "", null, NumberExpression.Dimension.NUMBER);
        }
        ListExpression list = (ListExpression)expression;
        int length = list.getExpressions().size();
        return new NumberExpression(call.getUnderlyingStructure(), Double.valueOf(length), "", null, NumberExpression.Dimension.NUMBER);
    }

    @Override
    protected boolean validateParameter(Expression parameter, int position, ProblemsHandler problemsHandler) {
        return true;
    }

    @Override
    protected int getMinParameters() {
        return 1;
    }

    @Override
    protected int getMaxParameters() {
        return Integer.MAX_VALUE;
    }
}

