/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.BinaryExpression;
import com.github.sommeri.less4j.core.ast.BinaryExpressionOperator;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FaultyExpression;
import com.github.sommeri.less4j.core.ast.NumberExpression;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.BugHappened;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;

class ArithmeticCalculator {
    private ProblemsHandler problemsHandler;

    public ArithmeticCalculator(ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
    }

    public Expression evalute(BinaryExpression originalExpression, Expression firstNumber, Expression secondNumber) {
        NumberExpression first = (NumberExpression)firstNumber;
        NumberExpression second = (NumberExpression)secondNumber;
        String resultSuffix = this.resultDimension(first, second);
        BinaryExpressionOperator operator = originalExpression.getOperator();
        if (this.shouldConvert(operator)) {
            first = first.convertIfPossible(resultSuffix);
            second = second.convertIfPossible(resultSuffix);
        }
        switch (operator.getOperator()) {
            case SOLIDUS: {
                return this.divide(first, second, resultSuffix, originalExpression);
            }
            case STAR: {
                return this.multiply(first, second, resultSuffix, originalExpression);
            }
            case MINUS: {
                return this.subtract(first, second, resultSuffix, originalExpression);
            }
            case PLUS: {
                return this.add(first, second, resultSuffix, originalExpression);
            }
        }
        throw new BugHappened("Unknown operator.", (ASTCssNode)operator);
    }

    private boolean shouldConvert(BinaryExpressionOperator operator) {
        return operator.getOperator() == BinaryExpressionOperator.Operator.PLUS || operator.getOperator() == BinaryExpressionOperator.Operator.MINUS;
    }

    private Expression subtract(NumberExpression first, NumberExpression second, String resultSuffix, BinaryExpression originalExpression) {
        return this.subtractNumbers(first, second, resultSuffix, originalExpression.getUnderlyingStructure());
    }

    private Expression subtractNumbers(NumberExpression first, NumberExpression second, String resultSuffix, HiddenTokenAwareTree parentToken) {
        Double firstVal = first.getValueAsDouble();
        Double secondVal = second.getValueAsDouble();
        Double resultVal = firstVal - secondVal;
        return this.createResultNumber(parentToken, resultVal, first, second, resultSuffix);
    }

    private Expression multiply(NumberExpression first, NumberExpression second, String resultSuffix, BinaryExpression originalExpression) {
        return this.multiplyNumbers(first, second, resultSuffix, originalExpression.getUnderlyingStructure());
    }

    private Expression multiplyNumbers(NumberExpression first, NumberExpression second, String resultSuffix, HiddenTokenAwareTree parentToken) {
        Double firstVal = first.getValueAsDouble();
        Double secondVal = second.getValueAsDouble();
        Double resultVal = firstVal * secondVal;
        return this.createResultNumber(parentToken, resultVal, first, second, resultSuffix);
    }

    private Expression divide(NumberExpression first, NumberExpression second, String resultSuffix, BinaryExpression originalExpression) {
        return this.divideNumbers(first, second, resultSuffix, originalExpression.getUnderlyingStructure());
    }

    private Expression divideNumbers(NumberExpression first, NumberExpression second, String resultSuffix, HiddenTokenAwareTree parentToken) {
        Double firstVal = first.getValueAsDouble();
        Double secondVal = second.getValueAsDouble();
        Double resultVal = firstVal / secondVal;
        return this.createResultNumber(parentToken, resultVal, first, second, resultSuffix);
    }

    private Expression add(NumberExpression first, NumberExpression second, String resultSuffix, BinaryExpression originalExpression) {
        return this.addNumbers(first, second, resultSuffix, originalExpression.getUnderlyingStructure());
    }

    private Expression addNumbers(NumberExpression first, NumberExpression second, String resultSuffix, HiddenTokenAwareTree parentToken) {
        Double firstVal = first.getValueAsDouble();
        Double secondVal = second.getValueAsDouble();
        Double resultVal = firstVal + secondVal;
        return this.createResultNumber(parentToken, resultVal, first, second, resultSuffix);
    }

    private Expression createResultNumber(HiddenTokenAwareTree parentToken, Double resultVal, NumberExpression first, NumberExpression second, String resultSuffix) {
        if (resultVal.isInfinite()) {
            this.problemsHandler.divisionByZero(second);
            return new FaultyExpression(second);
        }
        return new NumberExpression(parentToken, resultVal, resultSuffix, null, NumberExpression.Dimension.forSuffix(resultSuffix));
    }

    private String resultDimension(NumberExpression first, NumberExpression second) {
        if (first.getDimension() != NumberExpression.Dimension.NUMBER) {
            return first.getSuffix();
        }
        return second.getSuffix();
    }

    public boolean accepts(BinaryExpressionOperator operator, Expression first, Expression second) {
        return this.acceptedOperand(first, second);
    }

    private boolean acceptedOperand(Expression first, Expression second) {
        return first.getType() == ASTCssNodeType.NUMBER && second.getType() == ASTCssNodeType.NUMBER;
    }
}

